/*
 * Decompiled with CFR 0.152.
 */
package com.linln.component.shiro;

import com.linln.common.utils.EncryptUtil;
import com.linln.common.utils.HttpServletUtil;
import com.linln.common.utils.SpringContextUtil;
import com.linln.modules.system.domain.Role;
import com.linln.modules.system.domain.User;
import com.linln.modules.system.service.RoleService;
import com.linln.modules.system.service.UserService;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.SecurityUtils;
import org.hibernate.Hibernate;
import org.hibernate.LazyInitializationException;
import org.springframework.beans.BeanUtils;

public class ShiroUtil {
    public static final String HASH_ALGORITHM_NAME = "SHA-256";
    public static final int HASH_ITERATIONS = 1024;

    public static String encrypt(String password, String salt) {
        return EncryptUtil.encrypt((String)password, (String)salt, (String)HASH_ALGORITHM_NAME, (int)1024);
    }

    public static String getRandomSalt() {
        return EncryptUtil.getRandomSalt();
    }

    public static User getSubject() {
        User user = (User)SecurityUtils.getSubject().getPrincipal();
        if (user != null && !Hibernate.isInitialized((Object)user.getDept())) {
            try {
                Hibernate.initialize((Object)user.getDept());
            }
            catch (LazyInitializationException e) {
                UserService userService = (UserService)SpringContextUtil.getBean(UserService.class);
                User reload = userService.getById(user.getId());
                Hibernate.initialize((Object)reload.getDept());
                BeanUtils.copyProperties((Object)reload, (Object)user, (String[])new String[]{"roles"});
            }
        }
        return user;
    }

    public static Set<Role> getSubjectRoles() {
        User user = (User)SecurityUtils.getSubject().getPrincipal();
        if (user == null) {
            user = new User();
        }
        if (!Hibernate.isInitialized((Object)user.getRoles())) {
            try {
                Hibernate.initialize((Object)user.getRoles());
            }
            catch (LazyInitializationException e) {
                RoleService roleService = (RoleService)SpringContextUtil.getBean(RoleService.class);
                user.setRoles(roleService.getUserOkRoleList(user.getId()));
            }
        }
        return user.getRoles();
    }

    public static String getIp() {
        HttpServletRequest request = HttpServletUtil.getRequest();
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("X-Forwarded-For");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("X-Real-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }
}

