/*
 * Decompiled with CFR 0.152.
 */
package com.linln.component.shiro;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.filter.AccessControlFilter;
import org.apache.shiro.web.util.WebUtils;
import org.springframework.http.HttpStatus;

public class UserAuthFilter
extends AccessControlFilter {
    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) {
        if (this.isLoginRequest(request, response)) {
            return true;
        }
        Subject subject = this.getSubject(request, response);
        return subject.getPrincipal() != null && (subject.isRemembered() || subject.isAuthenticated());
    }

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws Exception {
        HttpServletRequest httpRequest = WebUtils.toHttp((ServletRequest)request);
        HttpServletResponse httpResponse = WebUtils.toHttp((ServletResponse)response);
        if (httpRequest.getHeader("X-Requested-With") != null && "XMLHttpRequest".equalsIgnoreCase(httpRequest.getHeader("X-Requested-With"))) {
            httpResponse.sendError(HttpStatus.UNAUTHORIZED.value());
        } else {
            this.redirectToLogin(request, response);
        }
        return false;
    }
}

