/*
 * Decompiled with CFR 0.152.
 */
package com.linln.component.shiro.config;

import com.linln.modules.system.domain.User;
import java.util.Optional;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.UnavailableSecurityManagerException;
import org.apache.shiro.subject.Subject;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.domain.AuditorAware;
import org.springframework.lang.NonNull;

@Configuration
public class AuditorConfig
implements AuditorAware<User> {
    @NonNull
    public Optional<User> getCurrentAuditor() {
        try {
            Subject subject = SecurityUtils.getSubject();
            User user = (User)subject.getPrincipal();
            return Optional.ofNullable(user);
        }
        catch (UnavailableSecurityManagerException e) {
            return Optional.empty();
        }
    }
}

