/*
 * Decompiled with CFR 0.152.
 */
package com.linln.component.shiro.exception;

import com.linln.common.enums.ResultEnum;
import com.linln.common.utils.ResultVoUtil;
import com.linln.common.utils.SpringContextUtil;
import com.linln.common.vo.ResultVo;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.spring.web.ShiroFilterFactoryBean;
import org.springframework.core.annotation.Order;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
@Order(value=-1)
public class AuthorizationExceptionHandler {
    @ExceptionHandler(value={AuthorizationException.class})
    @ResponseBody
    public ResultVo authorizationException(AuthorizationException e, HttpServletRequest request, HttpServletResponse response) {
        Class<ResultVo> resultVoClass;
        Integer code = ResultEnum.NO_PERMISSIONS.getCode();
        String msg = ResultEnum.NO_PERMISSIONS.getMessage();
        Throwable cause = e.getCause();
        String message = cause.getMessage();
        if (!message.contains((resultVoClass = ResultVo.class).getName())) {
            try {
                String contextPath = request.getContextPath();
                ShiroFilterFactoryBean shiroFilter = (ShiroFilterFactoryBean)SpringContextUtil.getBean(ShiroFilterFactoryBean.class);
                response.sendRedirect(contextPath + shiroFilter.getUnauthorizedUrl());
            }
            catch (IOException e1) {
                return ResultVoUtil.error((Integer)code, (String)msg);
            }
        }
        return ResultVoUtil.error((Integer)code, (String)msg);
    }
}

