/*
 * Decompiled with CFR 0.152.
 */
package com.linln.component.shiro.remember;

import com.linln.common.utils.EntityBeanUtil;
import com.linln.component.shiro.AuthRealm;
import com.linln.component.shiro.ShiroUtil;
import com.linln.component.shiro.remember.RememberMeDept;
import com.linln.modules.system.domain.Dept;
import com.linln.modules.system.domain.User;
import java.util.Arrays;
import java.util.Set;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.apache.shiro.web.mgt.CookieRememberMeManager;
import org.hibernate.collection.internal.PersistentSet;

public class RememberMeManager
extends CookieRememberMeManager {
    private final String CIPHER_KEY = "(\uff5e\uffe3\u25bd\uffe3)\uff5e";
    private final int ENCRYPT_LENGTH = 64;

    protected byte[] serialize(PrincipalCollection principals) {
        User user = (User)principals.getPrimaryPrincipal();
        String[] ignores = new String[]{"password", "salt", "dept", "roles"};
        User principal = (User)EntityBeanUtil.cloneBean((Object)user, (String[])ignores);
        String password = ShiroUtil.encrypt(user.getPassword(), user.getSalt());
        principal.setPassword(password);
        SimplePrincipalCollection collection = new SimplePrincipalCollection((Object)principal, AuthRealm.class.getName());
        return this.confusion(super.serialize((PrincipalCollection)collection), password);
    }

    protected PrincipalCollection deserialize(byte[] serializedIdentity) {
        PrincipalCollection collection = super.deserialize(this.extSerializeData(serializedIdentity));
        User principal = (User)collection.getPrimaryPrincipal();
        byte[] encrypt = new byte[64];
        System.arraycopy(serializedIdentity, 0, encrypt, 0, encrypt.length);
        String password = principal.getPassword();
        byte[] verifyEncrypt = ShiroUtil.encrypt(password, "(\uff5e\uffe3\u25bd\uffe3)\uff5e").getBytes();
        if (!Arrays.equals(encrypt, verifyEncrypt)) {
            throw new AuthenticationException();
        }
        principal.setDept((Dept)new RememberMeDept());
        principal.setRoles((Set)new PersistentSet());
        return collection;
    }

    private byte[] confusion(byte[] serializeData, String password) {
        byte[] encrypt = ShiroUtil.encrypt(password, "(\uff5e\uffe3\u25bd\uffe3)\uff5e").getBytes();
        byte[] confusionData = new byte[64 + serializeData.length];
        System.arraycopy(encrypt, 0, confusionData, 0, 64);
        System.arraycopy(serializeData, 0, confusionData, 64, serializeData.length);
        return confusionData;
    }

    private byte[] extSerializeData(byte[] serializedIdentity) {
        if (serializedIdentity.length > 64) {
            byte[] serializeData = new byte[serializedIdentity.length - 64];
            System.arraycopy(serializedIdentity, 64, serializeData, 0, serializeData.length);
            return serializeData;
        }
        return serializedIdentity;
    }
}

