/*
 * Decompiled with CFR 0.152.
 */
package com.linln.component.fileUpload;

import com.linln.common.exception.ResultException;
import com.linln.common.exception.interfaces.ResultInterface;
import com.linln.common.utils.SpringContextUtil;
import com.linln.common.utils.ToolUtil;
import com.linln.component.fileUpload.config.properties.UploadProjectProperties;
import com.linln.component.fileUpload.enums.UploadResultEnum;
import com.linln.modules.system.domain.Upload;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.springframework.web.multipart.MultipartFile;

public class FileUpload {
    public static Upload getFile(MultipartFile multipartFile, String modulePath) {
        if (multipartFile.getSize() == 0L) {
            throw new ResultException((ResultInterface)UploadResultEnum.NO_FILE_NULL);
        }
        Upload upload = new Upload();
        upload.setMime(multipartFile.getContentType());
        upload.setSize(Long.valueOf(multipartFile.getSize()));
        upload.setName(FileUpload.genFileName(multipartFile.getOriginalFilename()));
        upload.setPath(FileUpload.getPathPattern() + modulePath + FileUpload.genDateMkdir("yyyyMMdd") + upload.getName());
        return upload;
    }

    public static boolean isContentType(MultipartFile multipartFile, String[] types) {
        List<String> typeList = Arrays.asList(types);
        return typeList.contains(multipartFile.getContentType());
    }

    public static String getUploadPath() {
        UploadProjectProperties properties = (UploadProjectProperties)SpringContextUtil.getBean(UploadProjectProperties.class);
        return properties.getFilePath();
    }

    public static String getPathPattern() {
        UploadProjectProperties properties = (UploadProjectProperties)SpringContextUtil.getBean(UploadProjectProperties.class);
        return properties.getStaticPath().replace("/**", "");
    }

    public static String genFileName(String originalFilename) {
        String fileSuffix = ToolUtil.getFileSuffix((String)originalFilename);
        return UUID.randomUUID().toString().replace("-", "") + fileSuffix;
    }

    public static String genDateMkdir(String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return "/" + sdf.format(new Date()) + "/";
    }

    public static File getDestFile(Upload upload) throws IOException {
        String path = upload.getPath().replace(FileUpload.getPathPattern(), "");
        String filePath = FileUpload.getUploadPath() + path;
        File dest = new File(filePath.replace("//", "/"));
        if (!dest.exists()) {
            dest.getParentFile().mkdirs();
            dest.createNewFile();
        }
        return dest;
    }

    public static void transferTo(MultipartFile multipartFile, Upload upload) throws IOException, NoSuchAlgorithmException {
        byte[] buffer = new byte[4096];
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        MessageDigest sha1 = MessageDigest.getInstance("SHA1");
        try (OutputStream fos = Files.newOutputStream(FileUpload.getDestFile(upload).toPath(), new OpenOption[0]);
             InputStream fis = multipartFile.getInputStream();){
            int len = 0;
            while ((len = fis.read(buffer)) != -1) {
                fos.write(buffer, 0, len);
                md5.update(buffer, 0, len);
                sha1.update(buffer, 0, len);
            }
            fos.flush();
        }
        BigInteger md5Bi = new BigInteger(1, md5.digest());
        BigInteger sha1Bi = new BigInteger(1, sha1.digest());
        upload.setMd5(md5Bi.toString(16));
        upload.setSha1(sha1Bi.toString(16));
    }

    public static String getFileSha1(MultipartFile multipartFile) {
        String string;
        block10: {
            if (multipartFile.getSize() == 0L) {
                throw new ResultException((ResultInterface)UploadResultEnum.NO_FILE_NULL);
            }
            byte[] buffer = new byte[4096];
            InputStream fis = multipartFile.getInputStream();
            try {
                MessageDigest sha1 = MessageDigest.getInstance("SHA1");
                int len = 0;
                while ((len = fis.read(buffer)) != -1) {
                    sha1.update(buffer, 0, len);
                }
                BigInteger sha1Bi = new BigInteger(1, sha1.digest());
                string = sha1Bi.toString(16);
                if (fis == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | NoSuchAlgorithmException e) {
                    return null;
                }
            }
            fis.close();
        }
        return string;
    }
}

