/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.scanners;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import java.util.Collection;
import java.util.Set;
import springfox.documentation.service.ApiDescription;
import springfox.documentation.service.ResourceGroup;
import springfox.documentation.spi.service.contexts.Orderings;

class ResourceGroups {
    private ResourceGroups() {
        throw new UnsupportedOperationException();
    }

    static Iterable<ResourceGroup> collectResourceGroups(Collection<ApiDescription> apiDescriptions) {
        return FluentIterable.from(apiDescriptions).transform(ResourceGroups.toResourceGroups());
    }

    static Iterable<ResourceGroup> sortedByName(Set<ResourceGroup> resourceGroups) {
        return FluentIterable.from(resourceGroups).toSortedList(Orderings.resourceGroupComparator());
    }

    static Predicate<ApiDescription> belongsTo(final String groupName) {
        return new Predicate<ApiDescription>(){

            public boolean apply(ApiDescription input) {
                return !input.getGroupName().isPresent() || groupName.equals(input.getGroupName().get());
            }
        };
    }

    private static Function<ApiDescription, ResourceGroup> toResourceGroups() {
        return new Function<ApiDescription, ResourceGroup>(){

            public ResourceGroup apply(ApiDescription input) {
                return new ResourceGroup((String)input.getGroupName().or((Object)"default"), null);
            }
        };
    }
}

