/*
 * Decompiled with CFR 0.152.
 */
package com.linln.modules.system.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.linln.common.utils.HttpServletUtil;
import com.linln.modules.system.domain.User;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.servlet.http.HttpServletRequest;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;
import org.springframework.util.StringUtils;

@Entity
@Table(name="sys_file")
@EntityListeners(value={AuditingEntityListener.class})
public class Upload
implements Serializable {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    private String name;
    private String path;
    private String mime;
    private Long size;
    private String md5;
    private String sha1;
    @CreatedDate
    private Date createDate;
    @CreatedBy
    @ManyToOne(fetch=FetchType.LAZY)
    @NotFound(action=NotFoundAction.IGNORE)
    @JoinColumn(name="create_by")
    @JsonIgnore
    private User createBy;

    public String getUrl() {
        HttpServletRequest request = HttpServletUtil.getRequest();
        if (!StringUtils.isEmpty((Object)this.path)) {
            StringBuffer url = request.getRequestURL();
            String baseUrl = url.delete(url.length() - request.getRequestURI().length(), url.length()).append(request.getContextPath()).toString();
            return baseUrl + this.path;
        }
        return this.path;
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public String getMime() {
        return this.mime;
    }

    public Long getSize() {
        return this.size;
    }

    public String getMd5() {
        return this.md5;
    }

    public String getSha1() {
        return this.sha1;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public User getCreateBy() {
        return this.createBy;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMime(String mime) {
        this.mime = mime;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public void setMd5(String md5) {
        this.md5 = md5;
    }

    public void setSha1(String sha1) {
        this.sha1 = sha1;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public void setCreateBy(User createBy) {
        this.createBy = createBy;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Upload)) {
            return false;
        }
        Upload other = (Upload)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        String this$mime = this.getMime();
        String other$mime = other.getMime();
        if (this$mime == null ? other$mime != null : !this$mime.equals(other$mime)) {
            return false;
        }
        Long this$size = this.getSize();
        Long other$size = other.getSize();
        if (this$size == null ? other$size != null : !((Object)this$size).equals(other$size)) {
            return false;
        }
        String this$md5 = this.getMd5();
        String other$md5 = other.getMd5();
        if (this$md5 == null ? other$md5 != null : !this$md5.equals(other$md5)) {
            return false;
        }
        String this$sha1 = this.getSha1();
        String other$sha1 = other.getSha1();
        if (this$sha1 == null ? other$sha1 != null : !this$sha1.equals(other$sha1)) {
            return false;
        }
        Date this$createDate = this.getCreateDate();
        Date other$createDate = other.getCreateDate();
        if (this$createDate == null ? other$createDate != null : !((Object)this$createDate).equals(other$createDate)) {
            return false;
        }
        User this$createBy = this.getCreateBy();
        User other$createBy = other.getCreateBy();
        return !(this$createBy == null ? other$createBy != null : !((Object)this$createBy).equals(other$createBy));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Upload;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        String $mime = this.getMime();
        result = result * 59 + ($mime == null ? 43 : $mime.hashCode());
        Long $size = this.getSize();
        result = result * 59 + ($size == null ? 43 : ((Object)$size).hashCode());
        String $md5 = this.getMd5();
        result = result * 59 + ($md5 == null ? 43 : $md5.hashCode());
        String $sha1 = this.getSha1();
        result = result * 59 + ($sha1 == null ? 43 : $sha1.hashCode());
        Date $createDate = this.getCreateDate();
        result = result * 59 + ($createDate == null ? 43 : ((Object)$createDate).hashCode());
        User $createBy = this.getCreateBy();
        result = result * 59 + ($createBy == null ? 43 : ((Object)$createBy).hashCode());
        return result;
    }

    public String toString() {
        return "Upload(id=" + this.getId() + ", name=" + this.getName() + ", path=" + this.getPath() + ", mime=" + this.getMime() + ", size=" + this.getSize() + ", md5=" + this.getMd5() + ", sha1=" + this.getSha1() + ", createDate=" + this.getCreateDate() + ", createBy=" + this.getCreateBy() + ")";
    }
}

