/*
 * Decompiled with CFR 0.152.
 */
package com.linln.modules.system.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.linln.common.enums.StatusEnum;
import com.linln.component.excel.annotation.Excel;
import com.linln.component.excel.enums.ExcelType;
import com.linln.modules.system.domain.Dept;
import com.linln.modules.system.domain.Role;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity
@Table(name="sys_user")
@EntityListeners(value={AuditingEntityListener.class})
@SQLDelete(sql="update sys_user set status=3 WHERE id=?")
@Where(clause="status != 3")
@Excel(value="\u7528\u6237\u6570\u636e")
public class User
implements Serializable {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Excel(value="\u7528\u6237ID", type=ExcelType.EXPORT)
    private Long id;
    @Excel(value="\u7528\u6237\u540d")
    private String username;
    @JsonIgnore
    private String password;
    @JsonIgnore
    private String salt;
    @Excel(value="\u6635\u79f0")
    private String nickname;
    private String picture;
    @Excel(value="\u6027\u522b", dict="USER_SEX")
    private Byte sex;
    @Excel(value="\u624b\u673a\u53f7\u7801")
    private String phone;
    @Excel(value="\u7535\u5b50\u90ae\u7bb1")
    private String email;
    @CreatedDate
    @Excel(value="\u521b\u5efa\u65f6\u95f4")
    private Date createDate;
    @LastModifiedDate
    @Excel(value="\u66f4\u65b0\u65f6\u95f4")
    private Date updateDate;
    @Excel(value="\u5907\u6ce8")
    private String remark;
    @Excel(value="\u72b6\u6001", dict="DATA_STATUS")
    private Byte status = StatusEnum.OK.getCode();
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="dept_id")
    @JsonIgnore
    private Dept dept;
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="sys_user_role", joinColumns={@JoinColumn(name="user_id")}, inverseJoinColumns={@JoinColumn(name="role_id")})
    @JsonIgnore
    private Set<Role> roles = new HashSet<Role>(0);

    public Long getId() {
        return this.id;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getSalt() {
        return this.salt;
    }

    public String getNickname() {
        return this.nickname;
    }

    public String getPicture() {
        return this.picture;
    }

    public Byte getSex() {
        return this.sex;
    }

    public String getPhone() {
        return this.phone;
    }

    public String getEmail() {
        return this.email;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public Date getUpdateDate() {
        return this.updateDate;
    }

    public String getRemark() {
        return this.remark;
    }

    public Byte getStatus() {
        return this.status;
    }

    public Dept getDept() {
        return this.dept;
    }

    public Set<Role> getRoles() {
        return this.roles;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setSalt(String salt) {
        this.salt = salt;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public void setPicture(String picture) {
        this.picture = picture;
    }

    public void setSex(Byte sex) {
        this.sex = sex;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public void setStatus(Byte status) {
        this.status = status;
    }

    public void setDept(Dept dept) {
        this.dept = dept;
    }

    public void setRoles(Set<Role> roles) {
        this.roles = roles;
    }

    public String toString() {
        return "User(id=" + this.getId() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", salt=" + this.getSalt() + ", nickname=" + this.getNickname() + ", picture=" + this.getPicture() + ", sex=" + this.getSex() + ", phone=" + this.getPhone() + ", email=" + this.getEmail() + ", createDate=" + this.getCreateDate() + ", updateDate=" + this.getUpdateDate() + ", remark=" + this.getRemark() + ", status=" + this.getStatus() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof User)) {
            return false;
        }
        User other = (User)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$salt = this.getSalt();
        String other$salt = other.getSalt();
        if (this$salt == null ? other$salt != null : !this$salt.equals(other$salt)) {
            return false;
        }
        String this$nickname = this.getNickname();
        String other$nickname = other.getNickname();
        if (this$nickname == null ? other$nickname != null : !this$nickname.equals(other$nickname)) {
            return false;
        }
        String this$picture = this.getPicture();
        String other$picture = other.getPicture();
        if (this$picture == null ? other$picture != null : !this$picture.equals(other$picture)) {
            return false;
        }
        Byte this$sex = this.getSex();
        Byte other$sex = other.getSex();
        if (this$sex == null ? other$sex != null : !((Object)this$sex).equals(other$sex)) {
            return false;
        }
        String this$phone = this.getPhone();
        String other$phone = other.getPhone();
        if (this$phone == null ? other$phone != null : !this$phone.equals(other$phone)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        Date this$createDate = this.getCreateDate();
        Date other$createDate = other.getCreateDate();
        if (this$createDate == null ? other$createDate != null : !((Object)this$createDate).equals(other$createDate)) {
            return false;
        }
        Date this$updateDate = this.getUpdateDate();
        Date other$updateDate = other.getUpdateDate();
        if (this$updateDate == null ? other$updateDate != null : !((Object)this$updateDate).equals(other$updateDate)) {
            return false;
        }
        String this$remark = this.getRemark();
        String other$remark = other.getRemark();
        if (this$remark == null ? other$remark != null : !this$remark.equals(other$remark)) {
            return false;
        }
        Byte this$status = this.getStatus();
        Byte other$status = other.getStatus();
        return !(this$status == null ? other$status != null : !((Object)this$status).equals(other$status));
    }

    protected boolean canEqual(Object other) {
        return other instanceof User;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $salt = this.getSalt();
        result = result * 59 + ($salt == null ? 43 : $salt.hashCode());
        String $nickname = this.getNickname();
        result = result * 59 + ($nickname == null ? 43 : $nickname.hashCode());
        String $picture = this.getPicture();
        result = result * 59 + ($picture == null ? 43 : $picture.hashCode());
        Byte $sex = this.getSex();
        result = result * 59 + ($sex == null ? 43 : ((Object)$sex).hashCode());
        String $phone = this.getPhone();
        result = result * 59 + ($phone == null ? 43 : $phone.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        Date $createDate = this.getCreateDate();
        result = result * 59 + ($createDate == null ? 43 : ((Object)$createDate).hashCode());
        Date $updateDate = this.getUpdateDate();
        result = result * 59 + ($updateDate == null ? 43 : ((Object)$updateDate).hashCode());
        String $remark = this.getRemark();
        result = result * 59 + ($remark == null ? 43 : $remark.hashCode());
        Byte $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        return result;
    }
}

