/*
 * Decompiled with CFR 0.152.
 */
package com.linln.modules.system.service.impl;

import com.linln.common.data.PageSort;
import com.linln.modules.system.domain.ActionLog;
import com.linln.modules.system.repository.ActionLogRepository;
import com.linln.modules.system.service.ActionLogService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ActionLogServiceImpl
implements ActionLogService {
    @Autowired
    private ActionLogRepository actionLogRepository;

    @Override
    @Transactional
    public ActionLog getById(Long id) {
        return this.actionLogRepository.findById(id).orElse(null);
    }

    @Override
    public Page<ActionLog> getPageList(Example<ActionLog> example) {
        PageRequest page = PageSort.pageRequest();
        return this.actionLogRepository.findAll(example, (Pageable)page);
    }

    @Override
    public List<ActionLog> getDataLogList(String model, Long recordId) {
        return this.actionLogRepository.findByModelAndRecordId(model, recordId);
    }

    @Override
    public ActionLog save(ActionLog actionLog) {
        return (ActionLog)this.actionLogRepository.save(actionLog);
    }

    @Override
    @Transactional
    public void deleteId(Long id) {
        this.actionLogRepository.deleteById(id);
    }

    @Override
    @Transactional
    public void emptyLog() {
        this.actionLogRepository.deleteAll();
    }
}

