/*
 * Decompiled with CFR 0.152.
 */
package com.linln.modules.system.service.impl;

import com.linln.common.enums.ResultEnum;
import com.linln.common.enums.StatusEnum;
import com.linln.common.exception.ResultException;
import com.linln.modules.system.domain.Dept;
import com.linln.modules.system.domain.User;
import com.linln.modules.system.repository.DeptRepository;
import com.linln.modules.system.repository.UserRepository;
import com.linln.modules.system.service.DeptService;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DeptServiceImpl
implements DeptService {
    @Autowired
    private DeptRepository deptRepository;
    @Autowired
    private UserRepository userRepository;

    @Override
    @Transactional
    public Dept getById(Long id) {
        return this.deptRepository.findById(id).orElse(null);
    }

    @Override
    public List<Dept> getListByExample(Example<Dept> example, Sort sort) {
        return this.deptRepository.findAll(example, sort);
    }

    @Override
    public Integer getSortMax(Long pid) {
        return this.deptRepository.findSortMax(pid);
    }

    @Override
    public List<Dept> getListByPid(Long pid, Long notId) {
        Sort sort = new Sort(Sort.Direction.ASC, new String[]{"sort"});
        return this.deptRepository.findByPidAndIdNot(sort, pid, notId);
    }

    @Override
    public List<Dept> getListByPidLikeOk(Long id) {
        return this.deptRepository.findByPidsLikeAndStatus("%[" + id + "]%", StatusEnum.OK.getCode());
    }

    @Override
    public Dept save(Dept dept) {
        return (Dept)this.deptRepository.save(dept);
    }

    @Override
    public List<Dept> save(List<Dept> deptList) {
        return this.deptRepository.saveAll(deptList);
    }

    @Override
    @Transactional
    public Boolean updateStatus(StatusEnum statusEnum, List<Long> ids) {
        HashSet treeDepts = new HashSet();
        List<Dept> depts = this.deptRepository.findByIdIn(ids);
        depts.forEach(dept -> {
            treeDepts.add(dept);
            treeDepts.addAll(this.deptRepository.findByPidsLikeAndStatus("%[" + dept.getId() + "]%", dept.getStatus()));
        });
        treeDepts.forEach(dept -> {
            List<User> users;
            if (statusEnum == StatusEnum.DELETE && (users = this.userRepository.findByDept((Dept)dept)).size() > 0) {
                throw new ResultException(ResultEnum.DEPT_EXIST_USER);
            }
            dept.setStatus(statusEnum.getCode());
        });
        return treeDepts.size() > 0;
    }
}

