/*
 * Decompiled with CFR 0.152.
 */
package com.linln.modules.system.service.impl;

import com.linln.common.data.PageSort;
import com.linln.common.enums.StatusEnum;
import com.linln.modules.system.domain.Dict;
import com.linln.modules.system.repository.DictRepository;
import com.linln.modules.system.service.DictService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DictServiceImpl
implements DictService {
    @Autowired
    private DictRepository dictRepository;

    @Override
    @Transactional
    public Dict getById(Long id) {
        return this.dictRepository.findById(id).orElse(null);
    }

    @Override
    public Dict getByNameOk(String name) {
        return this.dictRepository.findByNameAndStatus(name, StatusEnum.OK.getCode());
    }

    @Override
    public Page<Dict> getPageList(Example<Dict> example) {
        PageRequest page = PageSort.pageRequest();
        return this.dictRepository.findAll(example, (Pageable)page);
    }

    @Override
    public boolean repeatByName(Dict dict) {
        Long id = dict.getId() != null ? dict.getId() : Long.MIN_VALUE;
        return this.dictRepository.findByNameAndIdNot(dict.getName(), id) != null;
    }

    @Override
    public Dict save(Dict dict) {
        return (Dict)this.dictRepository.save(dict);
    }

    @Override
    @Transactional
    public Boolean updateStatus(StatusEnum statusEnum, List<Long> idList) {
        return this.dictRepository.updateStatus(statusEnum.getCode(), idList) > 0;
    }
}

