/*
 * Decompiled with CFR 0.152.
 */
package com.linln.modules.system.service.impl;

import com.linln.common.enums.StatusEnum;
import com.linln.modules.system.domain.Menu;
import com.linln.modules.system.repository.MenuRepository;
import com.linln.modules.system.service.MenuService;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MenuServiceImpl
implements MenuService {
    @Autowired
    private MenuRepository menuRepository;

    @Override
    @Transactional
    public Menu getById(Long id) {
        if (id == 0L) {
            return new Menu(id, "\u9876\u7ea7\u83dc\u5355", "");
        }
        return this.menuRepository.findById(id).orElse(null);
    }

    @Override
    @Transactional
    public Menu getByUrl(String url) {
        return this.menuRepository.findByUrl(url);
    }

    @Override
    public List<Menu> getListByExample(Example<Menu> example, Sort sort) {
        return this.menuRepository.findAll(example, sort);
    }

    @Override
    public Menu getByMenuToExample(Menu menu) {
        return this.menuRepository.findOne(Example.of((Object)menu)).orElse(null);
    }

    @Override
    public List<Menu> getListBySortOk() {
        Sort sort = new Sort(Sort.Direction.ASC, new String[]{"type", "sort"});
        return this.menuRepository.findAllByStatus(sort, StatusEnum.OK.getCode());
    }

    @Override
    public Integer getSortMax(Long pid) {
        return this.menuRepository.findSortMax(pid);
    }

    @Override
    public List<Menu> getListByPid(Long pid, Long notId) {
        Sort sort = new Sort(Sort.Direction.ASC, new String[]{"sort"});
        return this.menuRepository.findByPidAndIdNot(sort, pid, notId);
    }

    @Override
    public Menu save(Menu menu) {
        return (Menu)this.menuRepository.save(menu);
    }

    @Override
    public List<Menu> save(List<Menu> menuList) {
        return this.menuRepository.saveAll(menuList);
    }

    @Override
    @Transactional
    public Boolean updateStatus(StatusEnum statusEnum, List<Long> ids) {
        HashSet treeMenus = new HashSet();
        List<Menu> menus = this.menuRepository.findByIdIn(ids);
        menus.forEach(menu -> {
            treeMenus.add(menu);
            treeMenus.addAll(this.menuRepository.findByPidsLikeAndStatus("%[" + menu.getId() + "]%", menu.getStatus()));
        });
        treeMenus.forEach(menu -> {
            if (statusEnum == StatusEnum.DELETE) {
                this.menuRepository.cancelRoleJoin(menu.getId());
            }
            menu.setStatus(statusEnum.getCode());
        });
        return treeMenus.size() > 0;
    }
}

