/*
 * Decompiled with CFR 0.152.
 */
package com.linln.modules.system.service.impl;

import com.linln.common.data.PageSort;
import com.linln.common.enums.StatusEnum;
import com.linln.modules.system.domain.Role;
import com.linln.modules.system.repository.RoleRepository;
import com.linln.modules.system.service.RoleService;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RoleServiceImpl
implements RoleService {
    @Autowired
    private RoleRepository roleRepository;

    @Override
    @Transactional
    public Set<Role> getUserOkRoleList(Long id) {
        Byte status = StatusEnum.OK.getCode();
        return this.roleRepository.findByUsers_IdAndStatus(id, status);
    }

    @Override
    public Boolean existsUserOk(Long id) {
        Byte status = StatusEnum.OK.getCode();
        return this.roleRepository.existsByUsers_IdAndStatus(id, status);
    }

    @Override
    @Transactional
    public Role getById(Long id) {
        return this.roleRepository.findById(id).orElse(null);
    }

    @Override
    public Page<Role> getPageList(Example<Role> example) {
        PageRequest page = PageSort.pageRequest((Sort.Direction)Sort.Direction.ASC);
        return this.roleRepository.findAll(example, (Pageable)page);
    }

    @Override
    public List<Role> getListBySortOk(Sort sort) {
        return this.roleRepository.findAllByStatus(sort, StatusEnum.OK.getCode());
    }

    @Override
    public boolean repeatByName(Role role) {
        Long id = role.getId() != null ? role.getId() : Long.MIN_VALUE;
        return this.roleRepository.findByNameAndIdNot(role.getName(), id) != null;
    }

    @Override
    public Role save(Role role) {
        return (Role)this.roleRepository.save(role);
    }

    @Override
    @Transactional
    public Boolean updateStatus(StatusEnum statusEnum, List<Long> ids) {
        if (statusEnum == StatusEnum.DELETE) {
            this.roleRepository.cancelUserJoin(ids);
            this.roleRepository.cancelMenuJoin(ids);
        }
        return this.roleRepository.updateStatus(statusEnum.getCode(), ids) > 0;
    }
}

