/*
 * Decompiled with CFR 0.152.
 */
package com.linln.modules.system.service.impl;

import com.linln.common.data.PageSort;
import com.linln.common.enums.StatusEnum;
import com.linln.modules.system.domain.Dept;
import com.linln.modules.system.domain.User;
import com.linln.modules.system.repository.UserRepository;
import com.linln.modules.system.service.DeptService;
import com.linln.modules.system.service.UserService;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserServiceImpl
implements UserService {
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private DeptService deptService;

    @Override
    public User getByName(String username) {
        return this.userRepository.findByUsername(username);
    }

    @Override
    public Boolean repeatByUsername(User user) {
        Long id = user.getId() != null ? user.getId() : Long.MIN_VALUE;
        return this.userRepository.findByUsernameAndIdNot(user.getUsername(), id) != null;
    }

    @Override
    public User getById(Long id) {
        return this.userRepository.findById(id).orElse(null);
    }

    @Override
    @Transactional
    public Page<User> getPageList(final User user) {
        PageRequest page = PageSort.pageRequest((Sort.Direction)Sort.Direction.ASC);
        return this.userRepository.findAll((Specification)new Specification<User>(){

            public Predicate toPredicate(Root<User> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                ArrayList<Object> preList = new ArrayList<Object>();
                if (user.getId() != null) {
                    preList.add(cb.equal(root.get("id").as(Long.class), (Object)user.getId()));
                }
                if (user.getUsername() != null) {
                    preList.add(cb.equal(root.get("username").as(String.class), (Object)user.getUsername()));
                }
                if (user.getNickname() != null) {
                    preList.add(cb.like(root.get("nickname").as(String.class), "%" + user.getNickname() + "%"));
                }
                if (user.getDept() != null) {
                    Dept dept = user.getDept();
                    ArrayList<Long> deptIn = new ArrayList<Long>();
                    deptIn.add(dept.getId());
                    List<Dept> deptList = UserServiceImpl.this.deptService.getListByPidLikeOk(dept.getId());
                    deptList.forEach(item -> deptIn.add(item.getId()));
                    Join join = root.join("dept", JoinType.INNER);
                    CriteriaBuilder.In in = cb.in(join.get("id").as(Long.class));
                    deptIn.forEach(arg_0 -> ((CriteriaBuilder.In)in).value(arg_0));
                    preList.add(in);
                }
                if (user.getStatus() != null) {
                    preList.add(cb.equal(root.get("status").as(Byte.class), (Object)user.getStatus()));
                }
                Predicate[] pres = new Predicate[preList.size()];
                return query.where(preList.toArray(pres)).getRestriction();
            }
        }, (Pageable)page);
    }

    @Override
    public User save(User user) {
        return (User)this.userRepository.save(user);
    }

    @Override
    @Transactional
    public List<User> save(List<User> userList) {
        return this.userRepository.saveAll(userList);
    }

    @Override
    @Transactional
    public Boolean updateStatus(StatusEnum statusEnum, List<Long> ids) {
        if (statusEnum == StatusEnum.DELETE) {
            return this.userRepository.deleteByIdIn(ids) > 0;
        }
        return this.userRepository.updateStatus(statusEnum.getCode(), ids) > 0;
    }
}

