/*
 * Decompiled with CFR 0.152.
 */
package com.linln.devtools.generate;

import com.linln.common.constant.AdminConst;
import com.linln.common.utils.ResultVoUtil;
import com.linln.common.utils.ToolUtil;
import com.linln.common.vo.ResultVo;
import com.linln.devtools.generate.DefaultValue;
import com.linln.devtools.generate.domain.Basic;
import com.linln.devtools.generate.domain.Generate;
import com.linln.devtools.generate.domain.Template;
import com.linln.devtools.generate.enums.FieldQuery;
import com.linln.devtools.generate.enums.FieldType;
import com.linln.devtools.generate.enums.FieldVerify;
import com.linln.devtools.generate.enums.ModuleType;
import com.linln.devtools.generate.template.AddHtmlTemplate;
import com.linln.devtools.generate.template.ControllerTemplate;
import com.linln.devtools.generate.template.DetailHtmlTemplate;
import com.linln.devtools.generate.template.EntityTemplate;
import com.linln.devtools.generate.template.IndexHtmlTemplate;
import com.linln.devtools.generate.template.RepositoryTemplate;
import com.linln.devtools.generate.template.ServiceImplTemplate;
import com.linln.devtools.generate.template.ServiceTemplate;
import com.linln.devtools.generate.template.ValidatorTemplate;
import com.linln.devtools.generate.utils.GenerateUtil;
import com.linln.modules.system.domain.Menu;
import com.linln.modules.system.domain.Role;
import com.linln.modules.system.enums.MenuTypeEnum;
import com.linln.modules.system.service.MenuService;
import com.linln.modules.system.service.RoleService;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/dev/code"})
public class GenerateController {
    @Autowired
    private MenuService menuService;
    @Autowired
    private RoleService roleService;

    @GetMapping
    public String index(Model model) {
        model.addAttribute("basic", (Object)DefaultValue.getBasic());
        model.addAttribute("fieldList", DefaultValue.fieldList());
        model.addAttribute("fieldType", (Object)ToolUtil.enumToMap(FieldType.class));
        model.addAttribute("fieldQuery", (Object)ToolUtil.enumToMap(FieldQuery.class));
        model.addAttribute("fieldVerify", (Object)ToolUtil.enumToMap(FieldVerify.class));
        return "/devtools/generate/index";
    }

    @PostMapping(value={"/save"})
    @ResponseBody
    public ResultVo save(@RequestBody Generate generate) {
        LinkedHashMap<String, String> fieldMap = new LinkedHashMap<String, String>();
        if (generate.getTemplate().isEntity()) {
            fieldMap.put("\u5b9e\u4f53\u7c7b", EntityTemplate.generate(generate));
        }
        if (generate.getTemplate().isValidator()) {
            fieldMap.put("\u9a8c\u8bc1\u7c7b", ValidatorTemplate.generate(generate));
        }
        if (generate.getTemplate().isRepository()) {
            fieldMap.put("\u6570\u636e\u8bbf\u95ee\u5c42", RepositoryTemplate.generate(generate));
        }
        if (generate.getTemplate().isService()) {
            fieldMap.put("\u670d\u52a1\u5c42", ServiceTemplate.generate(generate));
            fieldMap.put("\u670d\u52a1\u5b9e\u73b0\u5c42", ServiceImplTemplate.generate(generate));
        }
        if (generate.getTemplate().isController()) {
            fieldMap.put("\u63a7\u5236\u5668", ControllerTemplate.generate(generate));
        }
        if (generate.getTemplate().isIndex()) {
            fieldMap.put("\u5217\u8868\u9875\u9762", IndexHtmlTemplate.generate(generate));
        }
        if (generate.getTemplate().isAdd()) {
            fieldMap.put("\u6dfb\u52a0\u9875\u9762", AddHtmlTemplate.generate(generate));
        }
        if (generate.getTemplate().isDetail()) {
            fieldMap.put("\u8be6\u7ec6\u9875\u9762", DetailHtmlTemplate.generate(generate));
        }
        if (generate.getBasic().getModuleType().equals(ModuleType.ALONE.getCode())) {
            GenerateUtil.genMavenModule(generate);
        }
        if (generate.getTemplate().isController()) {
            this.genMenuRule(generate);
        }
        return ResultVoUtil.success(fieldMap);
    }

    private void genMenuRule(Generate generate) {
        Template temp = generate.getTemplate();
        Basic basic = generate.getBasic();
        Long pid = basic.getGenPMenu();
        Menu pMenu = this.menuService.getById(pid);
        String pids = pMenu.getPids() + ",[" + pid + "]";
        Integer sortMax = this.menuService.getSortMax(pid);
        int sort = sortMax != null ? sortMax + 1 : 1;
        String preUrl = basic.getRequestMapping() + "/";
        String prePerms = preUrl.substring(1).replace("/", ":");
        boolean[] status = new boolean[]{temp.isIndex(), temp.isAdd(), temp.isAdd(), temp.isDetail(), temp.isIndex()};
        String[] titles = new String[]{basic.getGenTitle(), "\u6dfb\u52a0", "\u7f16\u8f91", "\u8be6\u7ec6", "\u4fee\u6539\u72b6\u6001"};
        String[] name = new String[]{"index", "add", "edit", "detail", "status"};
        ArrayList<Menu> bthMenus = new ArrayList<Menu>();
        for (int i = 0; i < titles.length; ++i) {
            if (!status[i]) continue;
            Menu menu = new Menu();
            menu.setTitle(titles[i]);
            menu.setPid(pid);
            menu.setPids(pids);
            menu.setUrl(preUrl + name[i]);
            menu.setPerms(prePerms + name[i]);
            if (i == 0) {
                if (pid == 0L) {
                    menu.setType(MenuTypeEnum.DIRECTORY.getCode());
                } else {
                    menu.setType(MenuTypeEnum.MENU.getCode());
                }
                pMenu = this.menuService.getByMenuToExample(menu);
                if (pMenu == null) {
                    menu.setSort(Integer.valueOf(sort));
                    pMenu = this.menuService.save(menu);
                }
                pid = pMenu.getId();
                pids = pids + ",[" + pid + "]";
                continue;
            }
            Menu bthMenu = this.menuService.getByMenuToExample(menu);
            if (bthMenu != null) continue;
            Integer bthSort = this.menuService.getSortMax(pid);
            menu.setSort(Integer.valueOf(bthSort != null ? bthSort + 1 : 1));
            menu.setType(MenuTypeEnum.BUTTON.getCode());
            bthMenus.add(menu);
        }
        this.menuService.save(bthMenus);
        Role role = this.roleService.getById(AdminConst.ADMIN_ROLE_ID);
        bthMenus.add(pMenu);
        role.getMenus().addAll(bthMenus);
        this.roleService.save(role);
    }
}

