/*
 * Decompiled with CFR 0.152.
 */
package com.linln.devtools.generate.template;

import com.linln.common.utils.ToolUtil;
import com.linln.devtools.generate.domain.Field;
import com.linln.devtools.generate.domain.Generate;
import com.linln.devtools.generate.enums.TierType;
import com.linln.devtools.generate.utils.FileUtil;
import com.linln.devtools.generate.utils.GenerateUtil;
import com.linln.devtools.generate.utils.parser.HtmlParseUtil;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.util.Arrays;
import java.util.List;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public class AddHtmlTemplate {
    private static String genHtmlBody(Generate generate) throws IOException {
        String var = ToolUtil.lowerFirst((String)generate.getBasic().getTableEntity());
        String baseUrl = generate.getBasic().getRequestMapping();
        String path = FileUtil.templatePath(AddHtmlTemplate.class);
        Document document = HtmlParseUtil.document(path);
        Element fieldNode = HtmlParseUtil.getJsoup(document, "field");
        StringBuilder fieldBuilder = new StringBuilder();
        String[] ignore = new String[]{"id", "remark", "createDate", "updateDate", "createBy", "updateBy", "status"};
        List<String> ignoreList = Arrays.asList(ignore);
        boolean fieldRemark = false;
        for (Field field : generate.getFields()) {
            if (!ignoreList.contains(field.getName())) {
                String temp = fieldNode.toString();
                temp = temp.replace("#{field.title}", field.getTitle());
                temp = temp.replace("#{field.name}", field.getName());
                fieldBuilder.append(HtmlParseUtil.tabBreak(fieldNode)).append(temp);
            }
            if (!"remark".equals(field.getName())) continue;
            fieldRemark = true;
        }
        fieldNode.after(fieldBuilder.toString());
        fieldNode.remove();
        Element remarkNode = HtmlParseUtil.getJsoup(document, "remark");
        if (!fieldRemark) {
            remarkNode.remove();
        }
        String html = HtmlParseUtil.html(document);
        html = html.replace("#{var}", var);
        html = html.replace("#{baseUrl}", baseUrl);
        return html;
    }

    public static String generate(Generate generate) {
        String filePath = GenerateUtil.getHtmlFilePath(generate, TierType.ADD);
        try {
            String content = AddHtmlTemplate.genHtmlBody(generate);
            GenerateUtil.generateFile(filePath, content);
        }
        catch (FileAlreadyExistsException e) {
            return GenerateUtil.fileExist(filePath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return filePath;
    }
}

