/*
 * Decompiled with CFR 0.152.
 */
package com.linln.devtools.generate.template;

import com.linln.common.utils.ToolUtil;
import com.linln.devtools.generate.domain.Field;
import com.linln.devtools.generate.domain.Generate;
import com.linln.devtools.generate.enums.TierType;
import com.linln.devtools.generate.utils.CodeUtil;
import com.linln.devtools.generate.utils.FileUtil;
import com.linln.devtools.generate.utils.GenerateUtil;
import com.linln.devtools.generate.utils.parser.HtmlParseUtil;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.util.Arrays;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public class DetailHtmlTemplate {
    private static String[] fixedSort = new String[]{"user", "date", "remark"};
    private static String[] ignore = new String[]{"status"};

    private static Element appendElement(Element element, String name) {
        element.append(HtmlParseUtil.tabBreak(element) + CodeUtil.tabBreak);
        return element.appendElement(name);
    }

    private static Element fixedElement(Element fixeds, String groupName) {
        Element element = fixeds.getElementById(groupName);
        if (element == null) {
            fixeds.append(HtmlParseUtil.tabBreak(fixeds) + CodeUtil.tabBreak);
            element = fixeds.appendElement("tr").attr("id", groupName);
        }
        return element;
    }

    private static String genHtmlBody(Generate generate) throws IOException {
        String var = ToolUtil.lowerFirst((String)generate.getBasic().getTableEntity());
        String path = FileUtil.templatePath(DetailHtmlTemplate.class);
        Document document = HtmlParseUtil.document(path);
        Element detailNode = HtmlParseUtil.getJsoup(document, "detail");
        String tabBreak = HtmlParseUtil.tabBreak(detailNode);
        Element lastNode = null;
        for (Field field : generate.getFields()) {
            Element trNode = null;
            String thText = "${%s.%s}";
            switch (field.getName()) {
                case "createBy": 
                case "updateBy": {
                    trNode = DetailHtmlTemplate.fixedElement(detailNode, fixedSort[0]);
                    thText = "${%s.%s?.nickname}";
                    break;
                }
                case "createDate": 
                case "updateDate": {
                    trNode = DetailHtmlTemplate.fixedElement(detailNode, fixedSort[1]);
                    thText = "${#dates.format(%s.%s, 'yyyy-MM-dd HH:mm:ss')}";
                    break;
                }
                case "remark": {
                    trNode = DetailHtmlTemplate.fixedElement(detailNode, fixedSort[2]);
                    break;
                }
                default: {
                    if (Arrays.asList(ignore).contains(field.getName())) break;
                    if (lastNode == null || lastNode.children().size() >= 4) {
                        lastNode = DetailHtmlTemplate.appendElement(detailNode, "tr");
                    }
                    trNode = lastNode;
                }
            }
            if (trNode == null) continue;
            DetailHtmlTemplate.appendElement(trNode, "th").text(field.getTitle());
            DetailHtmlTemplate.appendElement(trNode, "td").attr("th:text", String.format(thText, var, field.getName()));
            trNode.append(tabBreak + CodeUtil.tabBreak);
        }
        for (String fixed : fixedSort) {
            Element node = detailNode.getElementById(fixed);
            if (node == null) continue;
            if (node.children().size() < 4 && !fixed.equals(fixedSort[2])) {
                if (lastNode == null || lastNode.children().size() >= 4) {
                    lastNode = DetailHtmlTemplate.appendElement(detailNode, "tr");
                }
                lastNode.append(node.html());
                node.remove();
                continue;
            }
            node.appendTo(detailNode.append(HtmlParseUtil.tabBreak(detailNode) + CodeUtil.tabBreak)).removeAttr("id");
        }
        detailNode.append(tabBreak);
        for (int i = 0; i < 2; ++i) {
            if (lastNode != null && lastNode.children().size() < 4) {
                lastNode.children().last().attr("colspan", "3");
            }
            lastNode = detailNode.children().last();
        }
        return HtmlParseUtil.html(document);
    }

    public static String generate(Generate generate) {
        String filePath = GenerateUtil.getHtmlFilePath(generate, TierType.DETAIL);
        try {
            String content = DetailHtmlTemplate.genHtmlBody(generate);
            GenerateUtil.generateFile(filePath, content);
        }
        catch (FileAlreadyExistsException e) {
            return GenerateUtil.fileExist(filePath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return filePath;
    }
}

