/*
 * Decompiled with CFR 0.152.
 */
package com.linln.devtools.generate.template;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.linln.common.enums.StatusEnum;
import com.linln.common.utils.StatusUtil;
import com.linln.common.utils.ToolUtil;
import com.linln.devtools.generate.domain.Generate;
import com.linln.devtools.generate.enums.FieldType;
import com.linln.devtools.generate.enums.TierType;
import com.linln.devtools.generate.utils.GenerateUtil;
import com.linln.devtools.generate.utils.jAngel.nodes.ClassNode;
import com.linln.devtools.generate.utils.jAngel.nodes.Document;
import com.linln.devtools.generate.utils.jAngel.nodes.FieldNode;
import com.linln.devtools.generate.utils.jAngel.nodes.Format;
import com.linln.devtools.generate.utils.jAngel.nodes.Modifier;
import com.linln.devtools.generate.utils.parser.JavaParseUtil;
import com.linln.modules.system.domain.User;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.file.FileAlreadyExistsException;
import java.util.Date;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import lombok.Data;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.annotations.Where;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;
import org.springframework.format.annotation.DateTimeFormat;

public class EntityTemplate {
    private static Document genClazzBody(Generate generate) {
        String prefix = generate.getBasic().getTablePrefix();
        String tableName = generate.getBasic().getTableName();
        Document document = JavaParseUtil.document(generate, TierType.DOMAIN);
        ClassNode clazz = document.getClazz();
        clazz.addImplements(Serializable.class);
        clazz.addAnnotation(Data.class);
        clazz.addAnnotation(Entity.class);
        clazz.addAnnotation(Table.class, Format.of("name=$S", prefix + tableName));
        clazz.addAnnotation(EntityListeners.class, Format.of("$T.class", AuditingEntityListener.class));
        clazz.addAnnotation(Where.class, Format.of("clause = $T.NOT_DELETE", StatusUtil.class));
        generate.getFields().forEach(field -> {
            String name = field.getName();
            FieldNode node = new FieldNode(name);
            switch (name) {
                case "id": {
                    node.addAnnotation(Id.class);
                    node.addAnnotation(GeneratedValue.class, Format.of("strategy=$T.IDENTITY", GenerationType.class));
                    break;
                }
                case "createDate": {
                    node.addAnnotation(CreatedDate.class);
                    node.setType(Date.class);
                    break;
                }
                case "updateDate": {
                    node.addAnnotation(LastModifiedDate.class);
                    node.setType(Date.class);
                    break;
                }
                case "createBy": {
                    node.addAnnotation(CreatedBy.class);
                    node.addAnnotation(ManyToOne.class, Format.of("fetch=$T.LAZY", FetchType.class));
                    node.addAnnotation(NotFound.class, Format.of("action=$T.IGNORE", NotFoundAction.class));
                    node.addAnnotation(JoinColumn.class, Format.of("name=$S", "create_by"));
                    node.addAnnotation(JsonIgnore.class);
                    node.setType(User.class);
                    break;
                }
                case "updateBy": {
                    node.addAnnotation(LastModifiedBy.class);
                    node.addAnnotation(ManyToOne.class, Format.of("fetch=$T.LAZY", FetchType.class));
                    node.addAnnotation(NotFound.class, Format.of("action=$T.IGNORE", NotFoundAction.class));
                    node.addAnnotation(JoinColumn.class, Format.of("name=$S", "update_by"));
                    node.addAnnotation(JsonIgnore.class);
                    node.setType(User.class);
                    break;
                }
                case "status": {
                    node.setValue(Format.of("$T.OK.getCode()", StatusEnum.class));
                    break;
                }
            }
            Map fieldType = ToolUtil.enumToMap(FieldType.class);
            String type = (String)fieldType.get(field.getType());
            if (type.equals(FieldType.Text.getMessage())) {
                node.addAnnotation(Lob.class);
                node.addAnnotation(Column.class, Format.of("columnDefinition=$S", "TEXT"));
                node.setType(String.class);
            }
            if (node.getType() == null) {
                node.setType(type);
                if (type.equals(FieldType.Date.getMessage())) {
                    node.addAnnotation(DateTimeFormat.class, Format.of("pattern=$S", "yyyy-MM-dd HH:mm:ss"));
                }
                if (type.equals(FieldType.BigDecimal.getMessage())) {
                    document.getContainer().importClass(BigDecimal.class);
                }
            }
            if (!"name".equals(name)) {
                node.setComments("// " + field.getTitle());
            }
            node.accessSym(Modifier.PRIVATE);
            clazz.append(node);
        });
        return document;
    }

    public static String generate(Generate generate) {
        String filePath = GenerateUtil.getJavaFilePath(generate, TierType.DOMAIN);
        try {
            Document document = EntityTemplate.genClazzBody(generate);
            GenerateUtil.generateFile(filePath, document.content());
        }
        catch (FileAlreadyExistsException e) {
            return GenerateUtil.fileExist(filePath);
        }
        return filePath;
    }
}

