/*
 * Decompiled with CFR 0.152.
 */
package com.linln.devtools.generate.template;

import com.linln.devtools.generate.domain.Generate;
import com.linln.devtools.generate.utils.FileUtil;
import com.linln.devtools.generate.utils.GenerateUtil;
import com.linln.devtools.generate.utils.parser.XmlParseUtil;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import org.jsoup.nodes.Document;

public class PomXmlTemplate {
    private static String genHtmlBody(Generate generate) throws IOException {
        String module = generate.getBasic().getGenModule();
        String path = FileUtil.templatePath(PomXmlTemplate.class);
        Document document = XmlParseUtil.document(path);
        String html = XmlParseUtil.html(document);
        return html.replace("#{module}", module);
    }

    public static String generate(Generate generate, String filePath) {
        try {
            String content = PomXmlTemplate.genHtmlBody(generate);
            GenerateUtil.generateFile(filePath, content);
        }
        catch (FileAlreadyExistsException e) {
            return GenerateUtil.fileExist(filePath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return filePath;
    }
}

