/*
 * Decompiled with CFR 0.152.
 */
package com.linln.devtools.generate.template;

import com.linln.common.utils.ToolUtil;
import com.linln.devtools.generate.domain.Generate;
import com.linln.devtools.generate.enums.FieldType;
import com.linln.devtools.generate.enums.FieldVerify;
import com.linln.devtools.generate.enums.TierType;
import com.linln.devtools.generate.utils.GenerateUtil;
import com.linln.devtools.generate.utils.jAngel.nodes.ClassNode;
import com.linln.devtools.generate.utils.jAngel.nodes.Document;
import com.linln.devtools.generate.utils.jAngel.nodes.FieldNode;
import com.linln.devtools.generate.utils.jAngel.nodes.Format;
import com.linln.devtools.generate.utils.jAngel.nodes.Modifier;
import com.linln.devtools.generate.utils.parser.JavaParseUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.file.FileAlreadyExistsException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Email;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import lombok.Data;
import org.hibernate.validator.constraints.URL;
import org.springframework.format.annotation.DateTimeFormat;

public class ValidatorTemplate {
    private static Map<FieldVerify, Format> verifyRule() {
        HashMap<FieldVerify, Format> verify = new HashMap<FieldVerify, Format>(16);
        verify.put(FieldVerify.NotNull, Format.of("$T(message = $S)", NotNull.class, "#T\u4e0d\u80fd\u4e3a\u7a7a"));
        verify.put(FieldVerify.Email, Format.of("$T(message = $S)", Email.class, "\u90ae\u7bb1\u683c\u5f0f\u4e0d\u6b63\u786e"));
        verify.put(FieldVerify.Phone, Format.of("$T(regexp = $R, message = $S)", Pattern.class, "^((17[0-9])|(14[0-9])|(13[0-9])|(15[^4,\\D])|(18[0,5-9]))\\d{8}$", "\u624b\u673a\u53f7\u7801\u683c\u5f0f\u4e0d\u6b63\u786e"));
        verify.put(FieldVerify.Number, Format.of("$T(integer = 12, fraction = 2, message = $S)", Digits.class, "#T\u4e0d\u662f\u6570\u5b57"));
        verify.put(FieldVerify.Date, Format.of("$T(regexp = $R, message = $S)", Pattern.class, "[0-9]{4}-[0-9]{2}-[0-9]{2}", "\u65e5\u671f\u683c\u5f0f\u4e0d\u5bf9"));
        verify.put(FieldVerify.Url, Format.of("$T(message = $S)", URL.class, "URL\u5730\u5740\u683c\u5f0f\u4e0d\u5bf9"));
        verify.put(FieldVerify.IdKey, Format.of("$T(regexp = $R, message = $S)", Pattern.class, "(^(\\d{14}|\\d{17})(\\d|[xX])$)?", "\u8eab\u4efd\u8bc1\u53f7\u7801\u9519\u8bef"));
        return verify;
    }

    private static Document genClazzBody(Generate generate) {
        Document document = JavaParseUtil.document(generate, TierType.VALID);
        ClassNode clazz = document.getClazz();
        clazz.addImplements(Serializable.class);
        clazz.addAnnotation(Data.class);
        Map<FieldVerify, Format> ruleList = ValidatorTemplate.verifyRule();
        generate.getFields().forEach(field -> {
            List<Integer> verifys = field.getVerify();
            if (verifys.size() > 0) {
                String name = field.getName();
                FieldNode node = new FieldNode(name);
                FieldType typeEnum = (FieldType)((Object)((Object)ToolUtil.enumCode(FieldType.class, (Object)field.getType())));
                verifys.forEach(verifyCode -> {
                    FieldVerify verifyEnum = (FieldVerify)((Object)((Object)((Object)ToolUtil.enumCode(FieldVerify.class, (Object)verifyCode))));
                    Format format = (Format)ruleList.get((Object)verifyEnum);
                    if (verifyEnum.equals(FieldVerify.NotNull) && typeEnum.equals((Object)FieldType.String)) {
                        format = Format.of("$T(message = $S)", NotEmpty.class, "#T\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (format != null) {
                        document.getContainer().importClass(format.getImports());
                        String content = format.getContent().replace("#T", field.getTitle());
                        node.addAnnotation(content);
                    }
                });
                if (typeEnum.equals((Object)FieldType.Text)) {
                    node.setType(String.class);
                }
                if (typeEnum.equals((Object)FieldType.BigDecimal)) {
                    document.getContainer().importClass(BigDecimal.class);
                }
                if (typeEnum.equals((Object)FieldType.Date)) {
                    document.getContainer().importClass(Date.class);
                    node.addAnnotation(DateTimeFormat.class, Format.of("pattern=$S", "yyyy-MM-dd HH:mm:ss"));
                }
                if (node.getType() == null) {
                    node.setType(typeEnum.getMessage());
                }
                node.accessSym(Modifier.PRIVATE);
                clazz.append(node);
            }
        });
        return document;
    }

    public static String generate(Generate generate) {
        String filePath = GenerateUtil.getJavaFilePath(generate, TierType.VALID);
        try {
            Document document = ValidatorTemplate.genClazzBody(generate);
            GenerateUtil.generateFile(filePath, document.content());
        }
        catch (FileAlreadyExistsException e) {
            return GenerateUtil.fileExist(filePath);
        }
        return filePath;
    }
}

