/*
 * Decompiled with CFR 0.152.
 */
package com.linln.devtools.generate.utils;

import com.linln.devtools.generate.domain.Generate;
import com.linln.devtools.generate.enums.ModuleType;
import com.linln.devtools.generate.enums.TierType;
import com.linln.devtools.generate.template.PomXmlTemplate;
import com.linln.devtools.generate.utils.CodeUtil;
import com.linln.devtools.generate.utils.FileUtil;
import com.linln.devtools.generate.utils.parser.JavaParseUtil;
import com.linln.devtools.generate.utils.parser.XmlParseUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.util.Arrays;
import java.util.List;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class GenerateUtil {
    private static final String JAVA_SUFFIX = ".java";
    private static final String HTML_SUFFIX = ".html";
    private static final TierType[] MODULE_TIER = new TierType[]{TierType.DOMAIN, TierType.DAO, TierType.SERVICE, TierType.SERVICE_IMPL};

    public static String getJavaFilePath(Generate generate, TierType tierType) {
        String projectPath = generate.getBasic().getProjectPath();
        String module = generate.getBasic().getGenModule();
        Integer moduleType = generate.getBasic().getModuleType();
        String packageName = JavaParseUtil.getPackage(generate, tierType);
        String javaPath = packageName.replace(".", "/") + JAVA_SUFFIX;
        String mavenModule = "admin";
        if (moduleType.equals(ModuleType.ALONE.getCode()) && Arrays.asList(MODULE_TIER).contains((Object)tierType)) {
            mavenModule = "modules/" + module;
        }
        return projectPath + mavenModule + "/src/main" + "/java/" + javaPath;
    }

    public static String getHtmlFilePath(Generate generate, TierType tierType) {
        String projectPath = generate.getBasic().getProjectPath();
        String requestMapping = generate.getBasic().getRequestMapping();
        return projectPath + "admin" + "/src/main" + "/resources/templates" + requestMapping + "/" + tierType.name().toLowerCase() + HTML_SUFFIX;
    }

    public static void genMavenModule(Generate generate) {
        String module = generate.getBasic().getGenModule();
        List<String> moduleList = XmlParseUtil.getPomModuleList();
        if (moduleList != null && !moduleList.contains(module)) {
            XmlParseUtil.addPomModule(module);
            String projectPath = generate.getBasic().getProjectPath();
            String pomPath = projectPath + "modules" + "/" + module + "/pom.xml";
            PomXmlTemplate.generate(generate, pomPath);
            String packagePath = generate.getBasic().getPackagePath();
            String adminPom = projectPath + "admin" + "/pom.xml";
            try {
                Document document = XmlParseUtil.document(adminPom);
                String groupId = packagePath + "." + "modules";
                Elements dependencys = document.getElementsContainingText(groupId);
                Element lastDependency = dependencys.last();
                String dependency = XmlParseUtil.getDependency(module);
                if (lastDependency != null && "groupId".equals(lastDependency.tagName())) {
                    dependency = CodeUtil.lineBreak + CodeUtil.tabBreak + dependency;
                    lastDependency.parent().after(dependency);
                } else {
                    Element des = (Element)document.getElementsByTag("dependencies").get(0);
                    des.append(dependency + CodeUtil.lineBreak + CodeUtil.tabBreak);
                }
                String html = XmlParseUtil.html(document);
                html = html.replace("groupid", "groupId");
                html = html.replace("artifactid", "artifactId");
                FileUtil.saveWriter(new File(adminPom), html);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String fileExist(String filePath) {
        return "exist:" + filePath;
    }

    public static void generateFile(String filePath, String content) throws FileAlreadyExistsException {
        File file = new File(filePath);
        if (file.exists()) {
            throw new FileAlreadyExistsException(filePath + "\u6587\u4ef6\u5df2\u7ecf\u5b58\u5728");
        }
        FileUtil.saveWriter(file, content);
    }
}

