/*
 * Decompiled with CFR 0.152.
 */
package com.linln.devtools.generate.utils.jAngel.nodes;

import com.linln.devtools.generate.utils.jAngel.JAngel;
import com.linln.devtools.generate.utils.jAngel.nodes.Node;
import java.util.ArrayList;
import java.util.List;

public class ClassNode
extends Node {
    public static final String CLASS = "class";
    public static final String INTERFACE = "interface";
    public static final String ENUM = "enum";
    private String type = "class";
    private List<String> extClass = new ArrayList<String>();
    private List<String> implClass = new ArrayList<String>();

    public ClassNode(String className) {
        this.name = className;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getExtends() {
        return this.extClass.get(0);
    }

    public List<String> getExtendsList() {
        return this.extClass;
    }

    public void addExtends(String clazz) {
        this.extClass.add(clazz);
    }

    public void addExtends(Class<?> clazz) {
        this.importClass(clazz);
        this.extClass.add(clazz.getSimpleName());
    }

    public List<String> getImplements() {
        return this.implClass;
    }

    public void addImplements(String impl) {
        this.implClass.add(impl);
    }

    public void addImplements(Class<?> clazz) {
        this.importClass(clazz);
        this.implClass.add(clazz.getSimpleName());
    }

    @Override
    public String body() {
        int i;
        StringBuilder builder = new StringBuilder();
        builder.append("public ").append(this.type).append(" ").append(this.name);
        builder.append(this.extClass.size() > 0 ? " extends" : "");
        for (i = 0; i < this.extClass.size(); ++i) {
            builder.append(" ").append(this.extClass.get(i));
            if (i == this.extClass.size() - 1) continue;
            builder.append(",");
        }
        builder.append(this.implClass.size() > 0 ? " implements" : "");
        for (i = 0; i < this.implClass.size(); ++i) {
            builder.append(" ").append(this.implClass.get(i));
            if (i == this.implClass.size() - 1) continue;
            builder.append(",");
        }
        builder.append(" {").append(JAngel.lineBreak);
        builder.append(this.childrenContent());
        builder.append("}");
        return builder.toString();
    }
}

