/*
 * Decompiled with CFR 0.152.
 */
package com.linln.devtools.generate.utils.jAngel.nodes;

import com.linln.devtools.generate.utils.jAngel.JAngel;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Format {
    private static final String SIGN_T = "$T";
    private static final String SIGN_S = "$S";
    private static final String SIGN_R = "$R";
    private static final String SIGN_O = "$O";
    private String content;
    private Set<String> imports = new TreeSet<String>();

    public Format(String format, Object ... args) {
        StringBuffer buffer = new StringBuffer();
        Pattern pattern = Pattern.compile("\\$[A-Z]");
        Matcher matcher = pattern.matcher(format);
        int index = 0;
        block11: while (matcher.find()) {
            switch (matcher.group()) {
                case "$T": {
                    Class clazz = (Class)args[index++];
                    if (!clazz.getName().startsWith("java.lang")) {
                        this.imports.add("import " + clazz.getName() + ";" + JAngel.lineBreak);
                    }
                    matcher.appendReplacement(buffer, clazz.getSimpleName());
                    continue block11;
                }
                case "$S": {
                    matcher.appendReplacement(buffer, "\"" + String.valueOf(args[index++]) + "\"");
                    continue block11;
                }
                case "$R": {
                    String value = String.valueOf(args[index++]);
                    value = value.replace("\\", "\\\\\\\\");
                    value = value.replace("$", "\\$");
                    matcher.appendReplacement(buffer, "\"" + value + "\"");
                    continue block11;
                }
            }
            matcher.appendReplacement(buffer, String.valueOf(args[index++]));
        }
        matcher.appendTail(buffer);
        this.content = buffer.toString();
    }

    public static Format of(String format, Object ... args) {
        return new Format(format, args);
    }

    public String getContent() {
        return this.content;
    }

    public Set<String> getImports() {
        return this.imports;
    }
}

