/*
 * Decompiled with CFR 0.152.
 */
package com.linln.devtools.generate.utils.jAngel.nodes;

import com.linln.devtools.generate.utils.jAngel.nodes.Node;

public class Modifier
extends Node {
    public static String PUBLIC = "public";
    public static String PROTECTED = "protected";
    public static String PRIVATE = "private";
    protected String type;
    private String accessSym;
    private boolean staticSym;
    private boolean finalSym;
    private boolean abstractSym;

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setType(Class<?> clazz) {
        this.importClass(clazz);
        this.type = clazz.getSimpleName();
    }

    public Modifier access() {
        this.accessSym = PUBLIC;
        return this;
    }

    public Modifier accessSym(String symbol) {
        this.accessSym = symbol;
        return this;
    }

    public Modifier staticSym() {
        this.staticSym = true;
        return this;
    }

    public Modifier finalSym() {
        this.finalSym = true;
        return this;
    }

    public Modifier abstractSym() {
        this.abstractSym = true;
        return this;
    }

    protected String getModifier() {
        StringBuilder builder = new StringBuilder();
        if (this.accessSym != null) {
            builder.append(this.accessSym).append(" ");
        }
        if (this.staticSym) {
            builder.append("static ");
        }
        if (this.finalSym) {
            builder.append("final ");
        }
        if (this.abstractSym) {
            builder.append("abstract ");
        }
        if (this.type != null) {
            builder.append(this.type).append(" ");
        }
        return builder.toString();
    }
}

