/*
 * Decompiled with CFR 0.152.
 */
package com.linln.devtools.generate.utils.jAngel.nodes;

import com.linln.devtools.generate.utils.jAngel.JAngel;
import com.linln.devtools.generate.utils.jAngel.JAngelContainer;
import com.linln.devtools.generate.utils.jAngel.nodes.Format;
import com.linln.devtools.generate.utils.jAngel.select.Nodes;
import com.linln.devtools.generate.utils.jAngel.select.Select;
import com.linln.devtools.generate.utils.jAngel.utils.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class Node<T> {
    protected String name;
    protected List<String> annotation = new ArrayList<String>();
    protected String comments;
    protected int level = 0;
    protected Node parent;
    protected Nodes children = new Nodes();
    protected JAngelContainer container;
    protected String body;
    protected Set<String> imports = new TreeSet<String>();

    public Node() {
    }

    public Node(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Node pushAnnotation(String anno) {
        this.annotation.add(0, anno);
        return this;
    }

    public Node addAnnotation(String anno) {
        this.annotation.add(anno);
        return this;
    }

    public Node addAnnotation(Class clazz) {
        this.importClass(clazz);
        this.annotation.add(clazz.getSimpleName());
        return this;
    }

    public Node addAnnotation(Class clazz, Format format) {
        this.importClass(clazz);
        this.imports.addAll(format.getImports());
        this.annotation.add(clazz.getSimpleName() + "(" + format.getContent() + ")");
        return this;
    }

    public String getComments() {
        return this.comments != null ? this.comments : "";
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public int getLevel() {
        return this.level;
    }

    public String getIndex() {
        int level = this.level == 0 ? 1 : this.level;
        return StringUtil.repeat(JAngel.tabBreak, level - 1);
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public Node getParent() {
        return this.parent;
    }

    public void setParent(Node parent) {
        this.parent = parent;
    }

    public Node prev() {
        if (this.parent != null) {
            Nodes children = this.parent.children();
            try {
                return (Node)children.get(children.indexOf(this) - 1);
            }
            catch (IndexOutOfBoundsException ignored) {
                return null;
            }
        }
        return null;
    }

    public Node next() {
        if (this.parent != null) {
            Nodes children = this.parent.children();
            try {
                return (Node)children.get(children.indexOf(this) + 1);
            }
            catch (IndexOutOfBoundsException ignored) {
                return null;
            }
        }
        return null;
    }

    public Nodes children() {
        return this.children.stream().filter(node -> node.content().trim().length() > 0).collect(Collectors.toCollection(Nodes::new));
    }

    public void insert(Node node) {
        this.children.add(0, node);
        node.setContainer(this.container);
        this.container.importClass(node.imports);
        node.imports = this.container.getImports();
        node.level = this.level + 1;
        node.parent = this;
    }

    public void insert(int index, Node node) {
        this.children.add(index, node);
        node.setContainer(this.container);
        this.container.importClass(node.imports);
        node.imports = this.container.getImports();
        node.level = this.level + 1;
        node.parent = this;
    }

    public void append(Node node) {
        this.children.add(node);
        node.setContainer(this.container);
        this.container.importClass(node.imports);
        node.imports = this.container.getImports();
        node.level = this.level + 1;
        node.parent = this;
    }

    public void appendLine() {
        Node<T> node = new Node<T>();
        node.body(JAngel.lineBreak);
        this.children.add(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove() {
        if (this.parent != null) {
            int index = this.parent.children.indexOf(this);
            try {
                Node prev = (Node)this.parent.children.get(index - 1);
                Node next = (Node)this.parent.children.get(index + 1);
                if (prev.body().trim().length() == 0 && next.body().trim().length() == 0) {
                    this.parent.children.remove(next);
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            }
            finally {
                this.parent.children.remove(this);
            }
        }
    }

    public JAngelContainer getContainer() {
        return this.container;
    }

    public void setContainer(JAngelContainer container) {
        this.container = container;
    }

    public void importClass(String className) {
        if (!className.startsWith("java.lang")) {
            this.imports.add("import " + className + ";" + JAngel.lineBreak);
        }
    }

    public void importClass(Class<?> clazz) {
        this.importClass(clazz.getName());
    }

    public String body() {
        if (this.body != null) {
            return this.body;
        }
        return this.childrenContent();
    }

    public void body(String body) {
        this.body = body;
    }

    public String childrenContent() {
        StringBuilder builder = new StringBuilder();
        this.children.forEach(node -> builder.append(node.toString()));
        return builder.toString();
    }

    public String content() {
        StringBuilder builder = new StringBuilder();
        if (this.comments != null) {
            builder.append(this.getIndex()).append(this.getComments().trim()).append(JAngel.lineBreak);
        }
        if (this.annotation.size() > 0) {
            StringBuilder anno = new StringBuilder();
            this.annotation.forEach(item -> anno.append(this.getIndex()).append("@").append((String)item).append(JAngel.lineBreak));
            builder.append(anno.toString());
        }
        builder.append(this.body());
        return builder.toString();
    }

    public Node getByName(String name) {
        return Select.getByName(this, name);
    }

    public Nodes getNodesByName(String name) {
        return Select.getNodesByName(this, name);
    }

    public Node getChildByName(String name) {
        return Select.getChildByName(this, name);
    }

    public Nodes getChildNodesByName(String name) {
        return Select.getChildNodesByName(this, name);
    }

    public String toString() {
        return this.content();
    }
}

