/*
 * Decompiled with CFR 0.152.
 */
package com.linln.devtools.generate.utils.jAngel.parser;

import com.linln.devtools.generate.utils.jAngel.JAngel;
import com.linln.devtools.generate.utils.jAngel.nodes.BlockNode;
import com.linln.devtools.generate.utils.jAngel.nodes.ClassNode;
import com.linln.devtools.generate.utils.jAngel.nodes.Document;
import com.linln.devtools.generate.utils.jAngel.nodes.FieldNode;
import com.linln.devtools.generate.utils.jAngel.nodes.Format;
import com.linln.devtools.generate.utils.jAngel.nodes.LineNode;
import com.linln.devtools.generate.utils.jAngel.nodes.MethodNode;
import com.linln.devtools.generate.utils.jAngel.nodes.Modifier;
import com.linln.devtools.generate.utils.jAngel.nodes.Node;
import com.linln.devtools.generate.utils.jAngel.utils.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Parser {
    private Document document;
    private Set<String> imports = new TreeSet<String>();
    private List<Node> pushNode = new ArrayList<Node>();
    private List<String> pushLine = new ArrayList<String>();

    public Document getDocument() {
        return this.document;
    }

    public void line(String line) {
        this.pushLine.add(line);
        if (this.document == null) {
            this.parseClass(line);
            this.parseImport(line);
        } else if (this.document.getClazz() != null) {
            if (this.fieldNode(line)) {
                return;
            }
            if (this.lineNode(line)) {
                return;
            }
            if (this.methodNode(line)) {
                return;
            }
            if (this.blockNode(line)) {
                return;
            }
            if (StringUtil.matcher(line, '}') != -1) {
                this.pushNode.remove(this.pushNode.size() - 1);
                if (StringUtil.matcher(line, '@') == -1) {
                    this.pushLine.clear();
                }
            }
            if (line.trim().length() == 0 && this.pushNode.size() >= 1) {
                this.pushNode.get(this.pushNode.size() - 1).appendLine();
            }
        }
    }

    private void parseClass(String line) {
        String regex = "\\b(class|interface|enum)\\b\\s.*\\{";
        Matcher m = Pattern.compile(regex).matcher(line);
        if (m.find()) {
            String group = m.group();
            List<String> words = StringUtil.extWord(group.substring(0, group.length() - 1), Character.valueOf(','));
            this.document = JAngel.create(words.get(1));
            this.document.getContainer().importClass(this.imports);
            ClassNode clazz = this.document.getClazz();
            clazz.setType(words.get(0));
            int ext = words.indexOf("extends");
            int impl = words.indexOf("implements");
            if (ext != -1) {
                if (clazz.getType().equals("interface")) {
                    int size = impl != -1 ? impl : words.size();
                    for (int i = ext + 1; i < size; ++i) {
                        clazz.addExtends(words.get(i));
                    }
                } else {
                    clazz.addExtends(words.get(ext + 1));
                }
            }
            if (impl != -1) {
                for (int i = impl + 1; i < words.size(); ++i) {
                    clazz.addImplements(words.get(i));
                }
            }
            this.pushNode.add(clazz);
            this.before(clazz);
        }
    }

    private void parseImport(String line) {
        String regex = "\\bimport\\bs*.*;";
        Matcher m = Pattern.compile(regex).matcher(line);
        if (m.find()) {
            this.imports.add(m.group() + JAngel.lineBreak);
        }
    }

    private boolean fieldNode(String line) {
        int matcher = StringUtil.matcher(line, ';');
        if (matcher != -1 && !line.trim().startsWith("return")) {
            String beforeAll = this.getBeforeAll();
            String regex = "[\\w\\t ]*([\\w!\\[\\]]*(<.*>)?)?\\s+[\\w!]+\\s*(=+.+)?;";
            Matcher m = Pattern.compile(regex, 32).matcher(beforeAll);
            if (m.find()) {
                FieldNode node = new FieldNode();
                String group = m.group();
                int key = StringUtil.matcher(group, '=');
                if (key != -1) {
                    node.setValue(group.substring(key + 1, group.length() - 1).trim());
                    matcher = key;
                }
                List<String> list = StringUtil.extWord(group.substring(0, matcher), new Character[0]);
                this.pushNode.get(this.pushNode.size() - 1).append(node);
                this.modifier(node, list);
                this.before(node);
                return true;
            }
        }
        return false;
    }

    private boolean lineNode(String line) {
        int matcher = StringUtil.matcher(line, ';');
        if (matcher != -1) {
            int index;
            String beforeAll = this.getBeforeAll(true);
            LineNode node = new LineNode();
            if (beforeAll.trim().startsWith("return")) {
                node.setName("return");
            } else if (beforeAll.contains(" new ") && (index = beforeAll.indexOf(40)) != -1) {
                List<String> words = StringUtil.extWord(beforeAll.substring(0, index), new Character[0]);
                node.setName(words.get(words.size() - 1));
            } else {
                index = StringUtil.matcher(beforeAll, '.');
                if (index != -1) {
                    node.setName(beforeAll.substring(0, index));
                } else {
                    index = beforeAll.indexOf(40);
                    if (index != -1) {
                        List<String> words = StringUtil.extWord(beforeAll.substring(0, index), new Character[0]);
                        node.setName(words.get(words.size() - 1));
                    } else {
                        List<String> words = StringUtil.extWord(beforeAll, new Character[0]);
                        node.setName(words.get(0));
                    }
                }
            }
            node.body(beforeAll);
            this.pushNode.get(this.pushNode.size() - 1).append(node);
            this.before(node);
            return true;
        }
        return false;
    }

    private boolean methodNode(String line) {
        Node lastNode = this.pushNode.get(this.pushNode.size() - 1);
        if (lastNode instanceof ClassNode && StringUtil.matcher(line, '{') != -1) {
            String beforeAll = this.getBeforeAll();
            String regex = "[\\w\\t\\[\\] !<>,]*\\s+[\\w!]+\\s*\\(.*\\)\\s*\\{";
            Matcher m = Pattern.compile(regex, 32).matcher(beforeAll);
            if (m.find()) {
                MethodNode node = new MethodNode();
                String group = m.group();
                List<String> list = StringUtil.extWord(group.substring(0, group.indexOf("(")), new Character[0]);
                String params = group.substring(group.indexOf(40) + 1, group.lastIndexOf(41));
                lastNode.append(node);
                node.addParam(new Format(params, new Object[0]));
                this.modifier(node, list);
                this.before(node);
                this.pushNode.add(node);
                return true;
            }
        }
        return false;
    }

    private boolean blockNode(String line) {
        boolean bool = false;
        int matcher = StringUtil.matcher(line, '{');
        if (matcher != -1) {
            if (StringUtil.matcher(line, '@') != -1) {
                Node node = new Node();
                node.setContainer(this.document.getContainer());
                this.pushNode.add(node);
            } else {
                Node lastNode = this.pushNode.get(this.pushNode.size() - 1);
                BlockNode node = new BlockNode();
                String trim = line.trim();
                if (trim.startsWith("}")) {
                    ((BlockNode)lastNode).preBlock();
                    node.sufBlock();
                    node.setName(trim.substring(1, StringUtil.matcher(trim, '{')).trim());
                    this.pushNode.remove(this.pushNode.size() - 1);
                    lastNode = this.pushNode.get(this.pushNode.size() - 1);
                    bool = true;
                }
                String regex = "^\\w+|\\(.*\\)";
                Matcher m = Pattern.compile(regex).matcher(trim);
                int i = 1;
                while (m.find()) {
                    String group = m.group();
                    if (i == 1 && !bool) {
                        node.setName(group);
                    }
                    if (i == 2) {
                        node.setParams(group.substring(1, group.length() - 1));
                    }
                    ++i;
                }
                lastNode.append(node);
                this.pushNode.add(node);
                this.before(node);
            }
        }
        return bool;
    }

    private void modifier(Modifier node, List<String> wordList) {
        if (wordList.size() > 0) {
            node.setName(wordList.get(wordList.size() - 1));
            if (wordList.size() >= 2) {
                node.setType(wordList.get(wordList.size() - 2));
            }
            if (wordList.contains("public")) {
                node.accessSym("public");
            }
            if (wordList.contains("protected")) {
                node.accessSym("protected");
            }
            if (wordList.contains("private")) {
                node.accessSym("private");
            }
            if (wordList.contains("static")) {
                node.staticSym();
            }
            if (wordList.contains("final")) {
                node.finalSym();
            }
            if (wordList.contains("abstract")) {
                node.abstractSym();
            }
        }
    }

    private String getBeforeAll() {
        return this.getBeforeAll(false);
    }

    private String getBeforeAll(boolean anno) {
        String trim;
        StringBuilder builder = new StringBuilder();
        for (int i = this.pushLine.size() - 1; !(i < 0 || (trim = this.pushLine.get(i).trim()).length() == 0 || trim.startsWith("/") || trim.startsWith("*") || anno && trim.startsWith("@")); --i) {
            builder.insert(0, this.pushLine.get(i));
        }
        return builder.toString();
    }

    private void before(Node node) {
        String line;
        String push;
        int size = this.pushLine.size() - 1;
        while (!(size <= 0 || (push = (line = this.pushLine.get(--size)).trim()).length() <= 0 || push.endsWith(";") || push.endsWith("{") || push.endsWith("}"))) {
            if (push.startsWith("@")) {
                String regex = "\\)\\s+\\w+";
                Matcher m = Pattern.compile(regex).matcher(push);
                if (m.find()) continue;
                node.pushAnnotation(push.substring(1));
                continue;
            }
            if (push.startsWith("/")) {
                node.setComments(push + JAngel.lineBreak + node.getComments());
                continue;
            }
            if (!push.startsWith("*")) continue;
            node.setComments(line + node.getComments());
        }
        this.pushLine.clear();
    }
}

