/*
 * Decompiled with CFR 0.152.
 */
package com.linln.devtools.generate.utils.parser;

import com.linln.devtools.generate.utils.CodeUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class HtmlParseUtil {
    private static String lineBreak = CodeUtil.lineBreak;
    private static String docType = "<!DOCTYPE html>" + lineBreak;

    public static Document document(String path) throws IOException {
        Document document = Jsoup.parse((File)new File(path), (String)"UTF-8");
        Document.OutputSettings outputSettings = document.outputSettings();
        outputSettings.prettyPrint(false);
        return document;
    }

    public static Element getJsoup(Document document, String jsoup) {
        Elements elements = document.getElementsByAttributeValue("jsoup", jsoup);
        Element element = (Element)elements.get(0);
        element.removeAttr("jsoup");
        return element;
    }

    public static String tabBreak(Element element) {
        String preTab = element.previousSibling().toString();
        if (preTab.trim().length() > 0) {
            int count = 0;
            boolean hasWhile = true;
            while (hasWhile) {
                if (element.hasParent() || "html".equals(element.tagName())) {
                    element = element.parent();
                    ++count;
                    continue;
                }
                hasWhile = false;
            }
            return CodeUtil.lineBreak + CodeUtil.repeat(CodeUtil.tabBreak, count - 1);
        }
        return preTab;
    }

    public static String html(Document document) {
        Element htmlEle = document.head().parent();
        StringBuilder html = new StringBuilder("<html");
        List hAttrs = htmlEle.attributes().asList();
        for (int i = 0; i < hAttrs.size(); ++i) {
            if (i == 0) {
                html.append(" ");
            } else {
                html.append(lineBreak).append(CodeUtil.blank(6));
            }
            html.append(((Attribute)hAttrs.get(i)).getKey()).append("=\"").append(((Attribute)hAttrs.get(i)).getValue()).append("\"");
        }
        html.append(">").append(lineBreak);
        String head = document.head().toString() + lineBreak;
        Element bodyEle = document.body();
        StringBuilder bodyJoint = new StringBuilder("<body");
        bodyEle.attributes().forEach(attr -> bodyJoint.append(" ").append(attr.getKey()).append("=\"").append(attr.getValue()).append("\""));
        bodyJoint.append(">").append(lineBreak);
        bodyJoint.append(CodeUtil.tabBreak).append(bodyEle.html().trim()).append(lineBreak);
        bodyJoint.append("</body>").append(lineBreak);
        String body = bodyJoint.toString().replaceAll("((\r\n)|\n)[\\s\t ]*(\\1)+", "$1");
        return docType + html + head + body + "</html>";
    }
}

