/*
 * Decompiled with CFR 0.152.
 */
package com.linln.devtools.generate.utils.parser;

import com.linln.devtools.generate.domain.Generate;
import com.linln.devtools.generate.enums.ModuleType;
import com.linln.devtools.generate.enums.TierType;
import com.linln.devtools.generate.utils.CodeUtil;
import com.linln.devtools.generate.utils.jAngel.JAngel;
import com.linln.devtools.generate.utils.jAngel.nodes.ClassNode;
import com.linln.devtools.generate.utils.jAngel.nodes.Document;
import com.linln.devtools.generate.utils.jAngel.parser.Expression;
import java.text.SimpleDateFormat;
import java.util.Date;

public class JavaParseUtil {
    public static Document document(Generate generate, TierType type) {
        return JavaParseUtil.document(null, null, generate, type);
    }

    public static Document document(String path, Expression expression, Generate generate, TierType type) {
        Document document = null;
        String packageName = JavaParseUtil.getPackage(generate, type);
        if (path != null) {
            document = JAngel.parse(path, expression);
        } else {
            int last = packageName.lastIndexOf(46) + 1;
            document = JAngel.create(packageName.substring(last, packageName.length()));
        }
        document.setPackageName(packageName.substring(0, packageName.lastIndexOf(46)));
        ClassNode clazz = document.getClazz();
        String author = generate.getBasic().getAuthor();
        SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd");
        String comments = "/**" + CodeUtil.lineBreak + " * @author " + author + CodeUtil.lineBreak + " * @date " + df.format(new Date()) + CodeUtil.lineBreak + " */";
        clazz.setComments(comments);
        return document;
    }

    public static String getPackage(Generate generate, TierType type) {
        String packagePath = generate.getBasic().getPackagePath();
        String module = generate.getBasic().getGenModule();
        String entity = generate.getBasic().getTableEntity();
        String modules = ".modules.";
        String admin = ".admin.";
        if (!generate.getBasic().getModuleType().equals(ModuleType.ALONE.getCode())) {
            modules = admin;
        }
        if (generate.getBasic().getGenGroup() != null) {
            module = module + "." + generate.getBasic().getGenGroup();
        }
        switch (type) {
            case DOMAIN: {
                return packagePath + modules + module + ".domain." + entity;
            }
            case DAO: {
                return packagePath + modules + module + ".repository." + entity + "Repository";
            }
            case SERVICE: {
                return packagePath + modules + module + ".service." + entity + "Service";
            }
            case SERVICE_IMPL: {
                return packagePath + modules + module + ".service.impl." + entity + "ServiceImpl";
            }
            case CONTROLLER: {
                return packagePath + admin + module + ".controller." + entity + "Controller";
            }
            case VALID: {
                return packagePath + admin + module + ".validator." + entity + "Valid";
            }
        }
        return "";
    }
}

