/*
 * Decompiled with CFR 0.152.
 */
package com.linln.devtools.generate.utils.parser;

import com.linln.common.utils.ToolUtil;
import com.linln.devtools.generate.utils.CodeUtil;
import com.linln.devtools.generate.utils.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Parser;
import org.jsoup.select.Elements;

public class XmlParseUtil {
    private static final String ENCODE = "UTF-8";
    private static final String MODULE_NAME = "modules";
    private static final int INDENT_AMOUNT = 4;
    private static final String LINE_BREAK = CodeUtil.lineBreak;
    private static String docType = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + LINE_BREAK;
    private static final String POM_PATH = String.format("%s/%s/pom.xml", ToolUtil.getProjectPath(), "modules");

    public static Document document(String path) throws IOException {
        FileInputStream inputStream = new FileInputStream(path);
        Document document = Jsoup.parse((InputStream)inputStream, (String)ENCODE, (String)"", (Parser)Parser.xmlParser());
        Document.OutputSettings outputSettings = document.outputSettings();
        outputSettings.prettyPrint(false);
        return document;
    }

    public static String html(Document document) {
        Element project = (Element)document.getElementsByTag("project").get(0);
        StringBuilder html = new StringBuilder(docType + "<project");
        List pAttrs = project.attributes().asList();
        for (int i = 0; i < pAttrs.size(); ++i) {
            if (i == 0) {
                html.append(" ");
            } else {
                html.append(LINE_BREAK).append(CodeUtil.blank(9));
            }
            html.append(((Attribute)pAttrs.get(i)).getKey()).append("=\"").append(((Attribute)pAttrs.get(i)).getValue()).append("\"");
        }
        html.append(">").append(project.html()).append("</project>");
        return html.toString();
    }

    private static Element getPomModules() {
        try {
            return (Element)XmlParseUtil.document(POM_PATH).getElementsByTag(MODULE_NAME).get(0);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void addPomModule(String moduleName) {
        Element modules = XmlParseUtil.getPomModules();
        assert (modules != null);
        Document document = modules.ownerDocument();
        StringBuilder indenx = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            indenx.append(" ");
        }
        modules.append(indenx + "<module>" + moduleName + "</module>" + LINE_BREAK + indenx);
        FileUtil.saveWriter(new File(POM_PATH), XmlParseUtil.html(document));
    }

    public static List<String> getPomModuleList() {
        Element modules = XmlParseUtil.getPomModules();
        assert (modules != null);
        Elements moduleList = modules.getElementsByTag("module");
        ArrayList<String> list = new ArrayList<String>();
        moduleList.forEach(element -> list.add(element.text()));
        return list;
    }

    public static String getDependency(String moduleName) {
        StringBuilder dependency = new StringBuilder();
        dependency.append(CodeUtil.blank(4)).append("<dependency>").append(LINE_BREAK);
        dependency.append(CodeUtil.blank(12)).append("<groupId>com.linln.modules</groupId>").append(LINE_BREAK);
        dependency.append(CodeUtil.blank(12)).append("<artifactId>").append(moduleName).append("</artifactId>").append(LINE_BREAK);
        dependency.append(CodeUtil.blank(12)).append("<version>${project.version}</version>").append(LINE_BREAK);
        dependency.append(CodeUtil.blank(8)).append("</dependency>");
        return dependency.toString();
    }
}

