/*
 * Decompiled with CFR 0.152.
 */
package com.linln.component.thymeleaf.attribute;

import com.linln.component.thymeleaf.utility.DictUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.processor.element.AbstractAttributeTagProcessor;
import org.thymeleaf.processor.element.IElementTagStructureHandler;
import org.thymeleaf.standard.expression.FragmentExpression;
import org.thymeleaf.standard.expression.IStandardExpression;
import org.thymeleaf.standard.expression.IStandardExpressionParser;
import org.thymeleaf.standard.expression.NoOpToken;
import org.thymeleaf.standard.expression.StandardExpressionExecutionContext;
import org.thymeleaf.standard.expression.StandardExpressions;
import org.thymeleaf.templatemode.TemplateMode;

public class SelectDictAttrProcessor
extends AbstractAttributeTagProcessor {
    public static final int PRECEDENCE = 1400;
    public static final String ATTR_NAME = "dict";
    public static final String SELECTED_ATTR_NAME = "mo-selected";
    public static final String EMPTY_ATTR_NAME = "mo-empty";

    public SelectDictAttrProcessor(TemplateMode templateMode, String dialectPrefix) {
        super(templateMode, dialectPrefix, null, false, ATTR_NAME, true, 1400, true);
    }

    public SelectDictAttrProcessor(TemplateMode templateMode, String dialectPrefix, String attrName, int precedence) {
        super(templateMode, dialectPrefix, null, false, attrName, true, precedence, true);
    }

    protected void doProcess(ITemplateContext context, IProcessableElementTag tag, AttributeName attributeName, String attributeValue, IElementTagStructureHandler structureHandler) {
        String elementName = tag.getElementCompleteName();
        if (attributeValue.isEmpty() || !"select".equals(elementName)) {
            return;
        }
        Map<String, String> valueList = DictUtil.value(attributeValue);
        if (valueList != null && valueList.size() > 0) {
            this.doProcess(context, tag, attributeName, attributeValue, structureHandler, valueList);
        }
    }

    protected void doProcess(ITemplateContext context, IProcessableElementTag tag, AttributeName attributeName, String attributeValue, IElementTagStructureHandler structureHandler, Map<String, String> valueList) {
        Set postProcessors;
        String attributeSelectedValue = tag.getAttributeValue(SELECTED_ATTR_NAME);
        Object selectedValue = null;
        IEngineConfiguration configuration = context.getConfiguration();
        if (attributeSelectedValue != null && !attributeSelectedValue.isEmpty()) {
            Object expressionResult;
            IStandardExpressionParser expressionParser = StandardExpressions.getExpressionParser((IEngineConfiguration)configuration);
            IStandardExpression expression = expressionParser.parseExpression((IExpressionContext)context, attributeSelectedValue);
            if (expression != null && expression instanceof FragmentExpression) {
                FragmentExpression.ExecutedFragmentExpression executedFragmentExpression = FragmentExpression.createExecutedFragmentExpression((IExpressionContext)context, (FragmentExpression)((FragmentExpression)expression));
                expressionResult = FragmentExpression.resolveExecutedFragmentExpression((ITemplateContext)context, (FragmentExpression.ExecutedFragmentExpression)executedFragmentExpression, (boolean)true);
            } else {
                expressionResult = expression.execute((IExpressionContext)context, StandardExpressionExecutionContext.NORMAL);
            }
            if (expressionResult == NoOpToken.VALUE) {
                return;
            }
            selectedValue = expressionResult == null ? "" : expressionResult;
        }
        ArrayList<String> keyList = new ArrayList<String>();
        if (selectedValue instanceof List) {
            ((List)selectedValue).forEach(item -> keyList.add(String.valueOf(item)));
        } else {
            keyList.add(selectedValue == null ? "" : selectedValue.toString());
        }
        StringBuilder optionContent = new StringBuilder();
        valueList.forEach((key, val) -> {
            optionContent.append("<option value = '").append((String)key);
            if (keyList.contains(String.valueOf(key))) {
                optionContent.append("' ").append("selected='selected");
            }
            optionContent.append("'>").append((String)val).append("</option>");
        });
        String attributeEmptyValue = tag.getAttributeValue(EMPTY_ATTR_NAME);
        if (attributeEmptyValue != null) {
            String emptyStr = "<option value=''>" + attributeEmptyValue + "</option>";
            optionContent.insert(0, emptyStr);
        }
        if ((postProcessors = configuration.getPostProcessors(this.getTemplateMode())).isEmpty()) {
            structureHandler.removeAttribute(SELECTED_ATTR_NAME);
            structureHandler.removeAttribute(EMPTY_ATTR_NAME);
            structureHandler.setBody((CharSequence)optionContent, false);
        }
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }
}

