/*
 * Decompiled with CFR 0.152.
 */
package com.linln.component.thymeleaf.attribute;

import com.linln.component.thymeleaf.attribute.SelectDictAttrProcessor;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.processor.element.IElementTagStructureHandler;
import org.thymeleaf.standard.expression.FragmentExpression;
import org.thymeleaf.standard.expression.IStandardExpression;
import org.thymeleaf.standard.expression.IStandardExpressionParser;
import org.thymeleaf.standard.expression.NoOpToken;
import org.thymeleaf.standard.expression.StandardExpressionExecutionContext;
import org.thymeleaf.standard.expression.StandardExpressions;
import org.thymeleaf.templatemode.TemplateMode;

public class SelectListAttrProcessor
extends SelectDictAttrProcessor {
    public static final int PRECEDENCE = 1400;
    public static final String ATTR_NAME = "list";

    public SelectListAttrProcessor(TemplateMode templateMode, String dialectPrefix) {
        super(templateMode, dialectPrefix, ATTR_NAME, 1400);
    }

    @Override
    protected void doProcess(ITemplateContext context, IProcessableElementTag tag, AttributeName attributeName, String attributeValue, IElementTagStructureHandler structureHandler) {
        Object expressionResult;
        String elementName = tag.getElementCompleteName();
        if (attributeValue.isEmpty() || !"select".equals(elementName)) {
            return;
        }
        IEngineConfiguration configuration = context.getConfiguration();
        IStandardExpressionParser expressionParser = StandardExpressions.getExpressionParser((IEngineConfiguration)configuration);
        IStandardExpression expression = expressionParser.parseExpression((IExpressionContext)context, attributeValue);
        if (expression != null && expression instanceof FragmentExpression) {
            FragmentExpression.ExecutedFragmentExpression executedFragmentExpression = FragmentExpression.createExecutedFragmentExpression((IExpressionContext)context, (FragmentExpression)((FragmentExpression)expression));
            expressionResult = FragmentExpression.resolveExecutedFragmentExpression((ITemplateContext)context, (FragmentExpression.ExecutedFragmentExpression)executedFragmentExpression, (boolean)true);
        } else {
            expressionResult = expression.execute((IExpressionContext)context, StandardExpressionExecutionContext.RESTRICTED);
            if (expressionResult == NoOpToken.VALUE) {
                return;
            }
        }
        LinkedHashMap<String, String> valueList = new LinkedHashMap<String, String>();
        if (expressionResult.getClass().isArray()) {
            int length = Array.getLength(expressionResult);
            for (int i = 0; i < length; ++i) {
                String value = String.valueOf(Array.get(expressionResult, i));
                valueList.put(value, value);
            }
        } else if (expressionResult instanceof Collection) {
            Collection list = (Collection)expressionResult;
            list.forEach(item -> valueList.put(String.valueOf(item), String.valueOf(item)));
        } else if (expressionResult instanceof Map) {
            Map list = (Map)expressionResult;
            list.forEach((key, item) -> valueList.put(String.valueOf(key), String.valueOf(item)));
        }
        if (valueList.size() > 0) {
            this.doProcess(context, tag, attributeName, attributeValue, structureHandler, valueList);
        }
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }
}

