/*
 * Decompiled with CFR 0.152.
 */
package com.linln.component.thymeleaf.utility;

import com.linln.common.utils.EhCacheUtil;
import com.linln.common.utils.SpringContextUtil;
import com.linln.modules.system.domain.Dict;
import com.linln.modules.system.service.DictService;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;

public class DictUtil {
    private static Cache dictCache = EhCacheUtil.getDictCache();

    public static Map<String, String> value(String label) {
        LinkedHashMap<String, String> value = null;
        Element dictEle = dictCache.get((Serializable)((Object)label));
        if (dictEle != null) {
            value = (LinkedHashMap<String, String>)dictEle.getObjectValue();
        } else {
            DictService dictService = (DictService)SpringContextUtil.getBean(DictService.class);
            Dict dict = dictService.getByNameOk(label);
            if (dict != null) {
                String dictValue = dict.getValue();
                String[] outerSplit = dictValue.split(",");
                value = new LinkedHashMap<String, String>();
                for (String osp : outerSplit) {
                    String[] split = osp.split(":");
                    if (split.length <= 1) continue;
                    value.put(split[0], split[1]);
                }
                dictCache.put(new Element((Object)dict.getName(), value));
            }
        }
        return value;
    }

    public static String keyValue(String label, String code) {
        Map<String, String> list = DictUtil.value(label);
        if (list != null) {
            return list.get(code);
        }
        return "";
    }

    public static String dataStatus(Byte status) {
        String label = "DATA_STATUS";
        return DictUtil.keyValue(label, String.valueOf(status));
    }

    public static void clearCache(String label) {
        Element dictEle = dictCache.get((Serializable)((Object)label));
        if (dictEle != null) {
            dictCache.remove((Serializable)((Object)label));
        }
    }
}

