/*
 * Decompiled with CFR 0.152.
 */
package org.bsoftware.ward.handlers;

import java.io.IOException;
import org.bsoftware.ward.components.UtilitiesComponent;
import org.bsoftware.ward.dto.ErrorDto;
import org.bsoftware.ward.exceptions.ApplicationNotSetUpException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.ui.Model;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
@Order(value=-2147483648)
public class ControllerExceptionHandler {
    @Autowired
    private UtilitiesComponent utilitiesComponent;

    @ResponseBody
    @ExceptionHandler(value={ApplicationNotSetUpException.class})
    public ResponseEntity<?> applicationNotSetUpExceptionHandler(ApplicationNotSetUpException applicationNotSetUpException) {
        return new ResponseEntity((Object)new ErrorDto((Exception)applicationNotSetUpException), HttpStatus.BAD_REQUEST);
    }

    @ResponseBody
    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResponseEntity<?> methodArgumentNotValidExceptionHandler(MethodArgumentNotValidException methodArgumentNotValidException) {
        return new ResponseEntity((Object)new ErrorDto((Exception)methodArgumentNotValidException), HttpStatus.UNPROCESSABLE_ENTITY);
    }

    @ExceptionHandler(value={Exception.class})
    public String exceptionHandler(Model model) throws IOException {
        model.addAttribute("theme", (Object)this.utilitiesComponent.getThemeName());
        return "error/500";
    }
}

