/*
 * Decompiled with CFR 0.152.
 */
package org.bsoftware.ward.services;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.bsoftware.ward.Ward;
import org.bsoftware.ward.components.UtilitiesComponent;
import org.bsoftware.ward.dto.InfoDto;
import org.bsoftware.ward.dto.MachineDto;
import org.bsoftware.ward.dto.ProcessorDto;
import org.bsoftware.ward.dto.ProjectDto;
import org.bsoftware.ward.dto.SetupDto;
import org.bsoftware.ward.dto.StorageDto;
import org.bsoftware.ward.dto.UptimeDto;
import org.bsoftware.ward.exceptions.ApplicationNotSetUpException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.GlobalMemory;
import oshi.hardware.HWDiskStore;
import oshi.hardware.PhysicalMemory;
import oshi.software.os.OperatingSystem;

@Service
public class InfoService {
    @Autowired
    private SystemInfo systemInfo;
    @Autowired
    private UtilitiesComponent utilitiesComponent;

    private String getConvertedFrequency(long[] hertzArray) {
        long totalFrequency = Arrays.stream(hertzArray).sum();
        long hertz = totalFrequency / (long)hertzArray.length;
        if ((double)hertz / 1000000.0 > 999.0) {
            return (double)Math.round((double)hertz / 1.0E9 * 10.0) / 10.0 + " GHz";
        }
        return Math.round((double)hertz / 1000000.0) + " MHz";
    }

    private String getConvertedCapacity(long bits) {
        if ((double)bits / 1049000.0 > 999.0) {
            if ((double)bits / 1.074E9 > 999.0) {
                return (double)Math.round((double)bits / 1.1E12 * 10.0) / 10.0 + " TiB";
            }
            return Math.round((double)bits / 1.074E9) + " GiB";
        }
        return Math.round((double)bits / 1049000.0) + " MiB";
    }

    private ProcessorDto getProcessor() {
        ProcessorDto processorDto = new ProcessorDto();
        CentralProcessor centralProcessor = this.systemInfo.getHardware().getProcessor();
        String name = centralProcessor.getProcessorIdentifier().getName();
        if (name.contains("@")) {
            name = name.substring(0, name.indexOf(64) - 1);
        }
        processorDto.setName(name.trim());
        int coreCount = centralProcessor.getLogicalProcessorCount();
        processorDto.setCoreCount(coreCount + (coreCount > 1 ? " Cores" : " Core"));
        processorDto.setClockSpeed(this.getConvertedFrequency(centralProcessor.getCurrentFreq()));
        String BitDepthPrefix = centralProcessor.getProcessorIdentifier().isCpu64bit() ? "64" : "32";
        processorDto.setBitDepth(BitDepthPrefix + "-bit");
        return processorDto;
    }

    private MachineDto getMachine() {
        MachineDto machineDto = new MachineDto();
        OperatingSystem operatingSystem = this.systemInfo.getOperatingSystem();
        OperatingSystem.OSVersionInfo osVersionInfo = this.systemInfo.getOperatingSystem().getVersionInfo();
        GlobalMemory globalMemory = this.systemInfo.getHardware().getMemory();
        machineDto.setOperatingSystem(operatingSystem.getFamily() + " " + osVersionInfo.getVersion() + ", " + osVersionInfo.getCodeName());
        machineDto.setTotalRam(this.getConvertedCapacity(globalMemory.getTotal()) + " Ram");
        Optional physicalMemoryOptional = globalMemory.getPhysicalMemory().stream().findFirst();
        if (physicalMemoryOptional.isPresent()) {
            machineDto.setRamTypeOrOSBitDepth(((PhysicalMemory)physicalMemoryOptional.get()).getMemoryType());
        } else {
            machineDto.setRamTypeOrOSBitDepth(operatingSystem.getBitness() + "-bit");
        }
        int processCount = operatingSystem.getProcessCount();
        machineDto.setProcCount(processCount + (processCount > 1 ? " Procs" : " Proc"));
        return machineDto;
    }

    private StorageDto getStorage() {
        StorageDto storageDto = new StorageDto();
        List hwDiskStores = this.systemInfo.getHardware().getDiskStores();
        GlobalMemory globalMemory = this.systemInfo.getHardware().getMemory();
        Optional hwDiskStoreOptional = hwDiskStores.stream().findFirst();
        if (hwDiskStoreOptional.isPresent()) {
            String mainStorage = ((HWDiskStore)hwDiskStoreOptional.get()).getModel();
            if (mainStorage.contains("(Standard disk drives)")) {
                mainStorage = mainStorage.substring(0, mainStorage.indexOf("(Standard disk drives)") - 1);
            }
            storageDto.setMainStorage(mainStorage.trim());
        } else {
            storageDto.setMainStorage("Undefined");
        }
        long total = hwDiskStores.stream().mapToLong(HWDiskStore::getSize).sum();
        storageDto.setTotal(this.getConvertedCapacity(total) + " Total");
        int diskCount = hwDiskStores.size();
        storageDto.setDiskCount(diskCount + (diskCount > 1 ? " Disks" : " Disk"));
        storageDto.setSwapAmount(this.getConvertedCapacity(globalMemory.getVirtualMemory().getSwapTotal()) + " Swap");
        return storageDto;
    }

    private UptimeDto getUptime() {
        UptimeDto uptimeDto = new UptimeDto();
        long uptimeInSeconds = this.systemInfo.getOperatingSystem().getSystemUptime();
        uptimeDto.setDays(String.format("%02d", (int)Math.floor(uptimeInSeconds / 86400L)));
        uptimeDto.setHours(String.format("%02d", (int)Math.floor(uptimeInSeconds % 86400L / 3600L)));
        uptimeDto.setMinutes(String.format("%02d", (int)Math.floor(uptimeInSeconds / 60L % 60L)));
        uptimeDto.setSeconds(String.format("%02d", (int)Math.floor(uptimeInSeconds % 60L)));
        return uptimeDto;
    }

    private SetupDto getSetup() throws IOException {
        SetupDto setupDto = new SetupDto();
        File file = new File("setup.ini");
        setupDto.setServerName(this.utilitiesComponent.getFromIniFile(file, "setup", "serverName"));
        return setupDto;
    }

    private ProjectDto getProject() throws IOException {
        ProjectDto projectDto = new ProjectDto();
        Properties properties = new Properties();
        InputStream inputStream = this.getClass().getResourceAsStream("/META-INF/maven/org.b-software/ward/pom.properties");
        if (inputStream != null) {
            properties.load(inputStream);
            String version = properties.getProperty("version");
            projectDto.setVersion("Ward: v" + version);
        } else {
            projectDto.setVersion("Developer mode");
        }
        return projectDto;
    }

    public InfoDto getInfo() throws Exception {
        if (!Ward.isFirstLaunch()) {
            InfoDto infoDto = new InfoDto();
            infoDto.setProcessor(this.getProcessor());
            infoDto.setMachine(this.getMachine());
            infoDto.setStorage(this.getStorage());
            infoDto.setUptime(this.getUptime());
            infoDto.setSetup(this.getSetup());
            infoDto.setProject(this.getProject());
            return infoDto;
        }
        throw new ApplicationNotSetUpException();
    }
}

