/*
 * Decompiled with CFR 0.152.
 */
package org.bsoftware.ward.services;

import java.util.Arrays;
import org.bsoftware.ward.Ward;
import org.bsoftware.ward.dto.UsageDto;
import org.bsoftware.ward.exceptions.ApplicationNotSetUpException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.GlobalMemory;
import oshi.software.os.FileSystem;
import oshi.software.os.OSFileStore;
import oshi.util.Util;

@Service
public class UsageService {
    @Autowired
    private SystemInfo systemInfo;

    private int getProcessor() {
        CentralProcessor centralProcessor = this.systemInfo.getHardware().getProcessor();
        long[] prevTicksArray = centralProcessor.getSystemCpuLoadTicks();
        long prevTotalTicks = Arrays.stream(prevTicksArray).sum();
        long prevIdleTicks = prevTicksArray[CentralProcessor.TickType.IDLE.getIndex()];
        Util.sleep((long)1000L);
        long[] currTicksArray = centralProcessor.getSystemCpuLoadTicks();
        long currTotalTicks = Arrays.stream(currTicksArray).sum();
        long currIdleTicks = currTicksArray[CentralProcessor.TickType.IDLE.getIndex()];
        return (int)Math.round((1.0 - (double)(currIdleTicks - prevIdleTicks) / (double)(currTotalTicks - prevTotalTicks)) * 100.0);
    }

    private int getRam() {
        GlobalMemory globalMemory = this.systemInfo.getHardware().getMemory();
        long totalMemory = globalMemory.getTotal();
        long availableMemory = globalMemory.getAvailable();
        return (int)Math.round(100.0 - (double)availableMemory / (double)totalMemory * 100.0);
    }

    private int getStorage() {
        FileSystem fileSystem = this.systemInfo.getOperatingSystem().getFileSystem();
        long totalStorage = fileSystem.getFileStores().stream().mapToLong(OSFileStore::getTotalSpace).sum();
        long freeStorage = fileSystem.getFileStores().stream().mapToLong(OSFileStore::getFreeSpace).sum();
        return (int)Math.round((double)(totalStorage - freeStorage) / (double)totalStorage * 100.0);
    }

    public UsageDto getUsage() throws ApplicationNotSetUpException {
        if (!Ward.isFirstLaunch()) {
            UsageDto usageDto = new UsageDto();
            usageDto.setProcessor(this.getProcessor());
            usageDto.setRam(this.getRam());
            usageDto.setStorage(this.getStorage());
            return usageDto;
        }
        throw new ApplicationNotSetUpException();
    }
}

