/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.wmi.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBDatabaseException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.wmi.model.WMIClass;
import org.jkiss.dbeaver.ext.wmi.model.WMIContainer;
import org.jkiss.dbeaver.ext.wmi.model.WMIDataSource;
import org.jkiss.dbeaver.ext.wmi.model.WMIObjectCollectorSink;
import org.jkiss.dbeaver.model.DBPCloseableObject;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.utils.CommonUtils;
import org.jkiss.wmi.service.WMIException;
import org.jkiss.wmi.service.WMIObject;
import org.jkiss.wmi.service.WMIQualifiedObject;
import org.jkiss.wmi.service.WMIService;

public class WMINamespace
extends WMIContainer
implements DBSObjectContainer,
DBPCloseableObject {
    private static final Log log = Log.getLog(WMINamespace.class);
    protected WMIDataSource dataSource;
    private String name;
    protected WMIService service;
    private volatile List<WMINamespace> namespaces;
    private volatile List<WMIClass> rooClasses;
    private volatile List<WMIClass> associations;
    private volatile List<WMIClass> allClasses;

    public WMINamespace(WMINamespace parent, WMIDataSource dataSource, String name, WMIService service) {
        super(parent);
        this.dataSource = dataSource;
        this.name = name;
        this.service = service;
    }

    @Override
    public DBSObject getParentObject() {
        return this.parent != null ? this.parent : this.dataSource.getContainer();
    }

    @Override
    @NotNull
    public WMIDataSource getDataSource() {
        return this.dataSource;
    }

    public WMIService getService() throws WMIException {
        if (this.service == null) {
            this.service = this.parent.getService().openNamespace(this.name);
        }
        return this.service;
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<WMINamespace> getNamespaces(DBRProgressMonitor monitor) throws DBException {
        if (this.namespaces == null) {
            WMINamespace wMINamespace = this;
            synchronized (wMINamespace) {
                if (this.namespaces == null) {
                    this.namespaces = this.loadNamespaces(monitor);
                }
            }
        }
        return this.namespaces;
    }

    List<WMINamespace> loadNamespaces(DBRProgressMonitor monitor) throws DBException {
        try {
            WMIObjectCollectorSink sink = new WMIObjectCollectorSink(monitor, this.getService());
            this.getService().enumInstances("__NAMESPACE", sink, 1L);
            sink.waitForFinish();
            ArrayList<WMINamespace> children = new ArrayList<WMINamespace>();
            for (WMIObject object : sink.getObjectList()) {
                String nsName = CommonUtils.toString((Object)object.getValue("Name"));
                children.add(new WMINamespace(this, this.dataSource, nsName, null));
                object.release();
            }
            DBUtils.orderObjects(children);
            return children;
        }
        catch (WMIException e) {
            throw new DBDatabaseException((Throwable)e, (DBPDataSource)this.getDataSource());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Association
    public Collection<WMIClass> getRootClasses(DBRProgressMonitor monitor) throws DBException {
        if (this.rooClasses == null) {
            WMINamespace wMINamespace = this;
            synchronized (wMINamespace) {
                if (this.rooClasses == null) {
                    this.loadClasses(monitor);
                }
            }
        }
        return this.rooClasses;
    }

    @Association
    public Collection<WMIClass> getClasses(DBRProgressMonitor monitor) throws DBException {
        this.getRootClasses(monitor);
        return this.allClasses;
    }

    public WMIClass getClass(DBRProgressMonitor monitor, String name) throws DBException {
        return (WMIClass)DBUtils.findObject(this.getClasses(monitor), (String)name);
    }

    @Association
    public Collection<WMIClass> getAssociations(DBRProgressMonitor monitor) throws DBException {
        this.getRootClasses(monitor);
        return this.associations;
    }

    void loadClasses(DBRProgressMonitor monitor) throws DBException {
        boolean showSystemObjects = this.getDataSource().getContainer().getNavigatorSettings().isShowSystemObjects();
        try {
            WMIObjectCollectorSink sink = new WMIObjectCollectorSink(monitor, this.getService());
            this.getService().enumClasses(null, sink, 0L);
            sink.waitForFinish();
            ArrayList<WMIClass> allClasses = new ArrayList<WMIClass>();
            ArrayList<WMIClass> allAssociations = new ArrayList<WMIClass>();
            ArrayList<WMIClass> rootClasses = new ArrayList<WMIClass>();
            for (WMIObject object : sink.getObjectList()) {
                WMIClass wmiClass;
                WMIClass superClass = null;
                String superClassName = (String)object.getValue("__SUPERCLASS");
                if (superClassName != null) {
                    for (WMIClass c : allClasses) {
                        if (!c.getName().equals(superClassName)) continue;
                        superClass = c;
                        break;
                    }
                    if (superClass == null) {
                        for (WMIClass c : allAssociations) {
                            if (!c.getName().equals(superClassName)) continue;
                            superClass = c;
                            break;
                        }
                        if (superClass == null) {
                            log.warn((Object)("Super class '" + superClassName + "' not found"));
                        }
                    }
                }
                if ((wmiClass = new WMIClass(this, superClass, object)).isAssociation()) {
                    allAssociations.add(wmiClass);
                } else {
                    allClasses.add(wmiClass);
                    if (superClass == null) {
                        rootClasses.add(wmiClass);
                    }
                }
                if (superClass == null) continue;
                superClass.addSubClass(wmiClass);
            }
            if (!showSystemObjects) {
                Iterator iter = allClasses.iterator();
                while (iter.hasNext()) {
                    WMIClass wmiClass = (WMIClass)iter.next();
                    if (!wmiClass.isSystem()) continue;
                    iter.remove();
                }
            }
            DBUtils.orderObjects(rootClasses);
            DBUtils.orderObjects(allClasses);
            DBUtils.orderObjects(allAssociations);
            this.rooClasses = rootClasses;
            this.allClasses = allClasses;
            this.associations = allAssociations;
        }
        catch (WMIException e) {
            throw new DBDatabaseException((Throwable)e, (DBPDataSource)this.getDataSource());
        }
    }

    public Collection<? extends WMIContainer> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        ArrayList<WMIContainer> children = new ArrayList<WMIContainer>();
        children.addAll(this.getNamespaces(monitor));
        children.addAll(this.getClasses(monitor));
        children.addAll(this.getAssociations(monitor));
        return children;
    }

    public WMIContainer getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        return (WMIContainer)DBUtils.findObject(this.getChildren(monitor), (String)childName);
    }

    @NotNull
    public Class<? extends WMIContainer> getPrimaryChildType(@Nullable DBRProgressMonitor monitor) throws DBException {
        return WMIContainer.class;
    }

    public void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
        this.getNamespaces(monitor);
        this.getClasses(monitor);
    }

    public void close() {
        if (!CommonUtils.isEmpty(this.namespaces)) {
            for (WMINamespace namespace : this.namespaces) {
                namespace.close();
            }
            this.namespaces.clear();
        }
        if (!CommonUtils.isEmpty(this.allClasses)) {
            for (WMIClass wmiClass : this.allClasses) {
                wmiClass.close();
            }
            this.allClasses.clear();
            this.rooClasses.clear();
        }
        if (this.parent != null && this.service != null) {
            this.service.close();
            this.service = null;
        }
    }

    @Override
    protected WMIQualifiedObject getQualifiedObject() {
        return null;
    }
}

