/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.utilities;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import sun.jvm.hotspot.utilities.Interval;
import sun.jvm.hotspot.utilities.IntervalNode;
import sun.jvm.hotspot.utilities.RBColor;
import sun.jvm.hotspot.utilities.RBNode;
import sun.jvm.hotspot.utilities.RBTree;

public class IntervalTree
extends RBTree {
    private Comparator endpointComparator;

    public IntervalTree(Comparator endpointComparator) {
        super(new IntervalComparator(endpointComparator));
        this.endpointComparator = endpointComparator;
    }

    public void insert(Interval interval, Object data) {
        IntervalNode node = new IntervalNode(interval, this.endpointComparator, data);
        this.insertNode(node);
    }

    public List findAllNodesIntersecting(Interval interval) {
        ArrayList retList = new ArrayList();
        this.searchForIntersectingNodesFrom((IntervalNode)this.getRoot(), interval, retList);
        return retList;
    }

    @Override
    public void print() {
        this.printOn(System.out);
    }

    @Override
    public void printOn(PrintStream tty) {
        this.printFromNode(this.getRoot(), tty, 0);
    }

    @Override
    protected Object getNodeValue(RBNode node) {
        return ((IntervalNode)node).getInterval();
    }

    @Override
    protected void verify() {
        super.verify();
        this.verifyFromNode(this.getRoot());
    }

    private void verifyFromNode(RBNode node) {
        if (node == null) {
            return;
        }
        IntervalNode intNode = (IntervalNode)node;
        if (!intNode.getMaxEndpoint().equals(intNode.computeMaxEndpoint())) {
            this.print();
            throw new RuntimeException("Node's max endpoint was not updated properly");
        }
        if (!intNode.getMinEndpoint().equals(intNode.computeMinEndpoint())) {
            this.print();
            throw new RuntimeException("Node's min endpoint was not updated properly");
        }
        this.verifyFromNode(node.getLeft());
        this.verifyFromNode(node.getRight());
    }

    private void searchForIntersectingNodesFrom(IntervalNode node, Interval interval, List resultList) {
        IntervalNode right;
        if (node == null) {
            return;
        }
        IntervalNode left = (IntervalNode)node.getLeft();
        if (left != null && this.endpointComparator.compare(left.getMaxEndpoint(), interval.getLowEndpoint()) > 0) {
            this.searchForIntersectingNodesFrom(left, interval, resultList);
        }
        if (node.getInterval().overlaps(interval, this.endpointComparator)) {
            resultList.add(node);
        }
        if ((right = (IntervalNode)node.getRight()) != null && this.endpointComparator.compare(interval.getHighEndpoint(), right.getMinEndpoint()) > 0) {
            this.searchForIntersectingNodesFrom(right, interval, resultList);
        }
    }

    private void printFromNode(RBNode node, PrintStream tty, int indentDepth) {
        for (int i = 0; i < indentDepth; ++i) {
            tty.print(" ");
        }
        tty.print("-");
        if (node == null) {
            tty.println();
            return;
        }
        tty.println(" " + node + " (min " + ((IntervalNode)node).getMinEndpoint() + ", max " + ((IntervalNode)node).getMaxEndpoint() + ")" + (node.getColor() == RBColor.RED ? " (red)" : " (black)"));
        if (node.getLeft() != null) {
            this.printFromNode(node.getLeft(), tty, indentDepth + 2);
        }
        if (node.getRight() != null) {
            this.printFromNode(node.getRight(), tty, indentDepth + 2);
        }
    }

    static class IntervalComparator
    implements Comparator {
        private Comparator endpointComparator;

        public IntervalComparator(Comparator endpointComparator) {
            this.endpointComparator = endpointComparator;
        }

        public int compare(Object o1, Object o2) {
            Interval i1 = (Interval)o1;
            Interval i2 = (Interval)o2;
            return this.endpointComparator.compare(i1.getLowEndpoint(), i2.getLowEndpoint());
        }
    }
}

