/*
 * Decompiled with CFR 0.152.
 */
package javax.lang.model.util;

import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.AbstractElementVisitor6;

@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class ElementScanner6<R, P>
extends AbstractElementVisitor6<R, P> {
    protected final R DEFAULT_VALUE;

    protected ElementScanner6() {
        this.DEFAULT_VALUE = null;
    }

    protected ElementScanner6(R r) {
        this.DEFAULT_VALUE = r;
    }

    public final R scan(Iterable<? extends Element> iterable, P p) {
        R r = this.DEFAULT_VALUE;
        for (Element element : iterable) {
            r = this.scan(element, p);
        }
        return r;
    }

    public R scan(Element element, P p) {
        return element.accept(this, p);
    }

    public final R scan(Element element) {
        return this.scan(element, null);
    }

    @Override
    public R visitPackage(PackageElement packageElement, P p) {
        return this.scan(packageElement.getEnclosedElements(), p);
    }

    @Override
    public R visitType(TypeElement typeElement, P p) {
        return this.scan(typeElement.getEnclosedElements(), p);
    }

    @Override
    public R visitVariable(VariableElement variableElement, P p) {
        if (variableElement.getKind() != ElementKind.RESOURCE_VARIABLE) {
            return this.scan(variableElement.getEnclosedElements(), p);
        }
        return this.visitUnknown(variableElement, p);
    }

    @Override
    public R visitExecutable(ExecutableElement executableElement, P p) {
        return this.scan(executableElement.getParameters(), p);
    }

    @Override
    public R visitTypeParameter(TypeParameterElement typeParameterElement, P p) {
        return this.scan(typeParameterElement.getEnclosedElements(), p);
    }
}

