/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.Size;
import com.sun.glass.ui.monocle.NativeCursor;
import com.sun.glass.ui.monocle.NativeCursors;
import com.sun.glass.ui.monocle.NativePlatformFactory;
import com.sun.glass.ui.monocle.NativeScreen;
import com.sun.glass.ui.monocle.SysFS;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;

class OMAPCursor
extends NativeCursor {
    private int hotspotX;
    private int hotspotY;
    private int offsetX;
    private int offsetY;
    private int cursorX;
    private int cursorY;
    private static final int INT_KEY = 0x12121212;
    private static final int SHORT_KEY = 43947;
    private static final int CURSOR_WIDTH = 16;
    private static final int CURSOR_HEIGHT = 16;
    private Buffer cursorBuffer;
    private Buffer offsetCursorBuffer;
    private byte[] offsetCursor;
    private int screenWidth;
    private int screenHeight;
    private int cursorDepth;
    private int transparentPixel;

    OMAPCursor() {
        try {
            SysFS.write("/sys/class/graphics/fb1/virtual_size", "16,16");
            SysFS.write("/sys/devices/platform/omapdss/overlay1/output_size", "16,16");
            SysFS.write("/sys/devices/platform/omapdss/manager0/trans_key_enabled", "1");
            SysFS.write("/sys/devices/platform/omapdss/manager0/trans_key_type", "video-source");
            this.cursorDepth = SysFS.readInt("/sys/class/graphics/fb1/bits_per_pixel");
            switch (this.cursorDepth) {
                case 16: {
                    this.transparentPixel = 43947;
                    break;
                }
                case 32: {
                    this.transparentPixel = 0x12121212;
                    break;
                }
                default: {
                    throw new IOException("Cannot use an OMAP cursor with a bit depth of " + this.cursorDepth);
                }
            }
            SysFS.write("/sys/devices/platform/omapdss/manager0/trans_key_value", Long.toString(this.transparentPixel));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.err.println("Failed to initialize OMAP cursor");
        }
        NativeScreen nativeScreen = NativePlatformFactory.getNativePlatform().getScreen();
        this.screenWidth = nativeScreen.getWidth();
        this.screenHeight = nativeScreen.getHeight();
    }

    @Override
    Size getBestSize() {
        return new Size(16, 16);
    }

    @Override
    void setVisibility(boolean bl) {
        try {
            SysFS.write("/sys/devices/platform/omapdss/overlay1/enabled", bl ? "1" : "0");
        }
        catch (IOException iOException) {
            System.err.format("Failed to %s OMAP cursor\n", bl ? "enable" : "disable");
        }
        this.isVisible = bl;
    }

    private void updateImage(boolean bl) {
        int n = Math.max(0, 16 + this.cursorX - this.screenWidth);
        int n2 = Math.max(0, 16 + this.cursorY - this.screenHeight);
        if (n != this.offsetX || n2 != this.offsetY || bl) {
            NativeCursors.offsetCursor(this.cursorBuffer, this.offsetCursorBuffer, n, n2, 16, 16, this.cursorDepth, this.transparentPixel);
            this.offsetX = n;
            this.offsetY = n2;
            try {
                SysFS.write("/dev/fb1", this.offsetCursor);
            }
            catch (IOException iOException) {
                System.err.println("Failed to write OMAP cursor image");
            }
        }
    }

    @Override
    void setImage(byte[] byArray) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(byArray.length);
        this.cursorBuffer = this.cursorDepth == 32 ? byteBuffer.asIntBuffer() : byteBuffer.asShortBuffer();
        NativeCursors.colorKeyCursor(byArray, this.cursorBuffer, this.cursorDepth, this.transparentPixel);
        this.offsetCursor = new byte[byArray.length];
        byteBuffer = ByteBuffer.wrap(this.offsetCursor);
        this.offsetCursorBuffer = this.cursorDepth == 32 ? byteBuffer.asIntBuffer() : byteBuffer.asShortBuffer();
        this.updateImage(true);
    }

    @Override
    void setLocation(int n, int n2) {
        this.cursorX = n;
        this.cursorY = n2;
        this.updateImage(false);
        try {
            SysFS.write("/sys/devices/platform/omapdss/overlay1/position", this.cursorX - this.hotspotX - this.offsetX + "," + (this.cursorY - this.hotspotY - this.offsetY));
        }
        catch (IOException iOException) {
            System.err.println("Failed to set OMAP cursor position");
        }
    }

    @Override
    void setHotSpot(int n, int n2) {
        this.hotspotX = n;
        this.hotspotY = n2;
    }

    @Override
    void shutdown() {
        try {
            SysFS.write("/sys/devices/platform/omapdss/overlay1/enabled", "0");
        }
        catch (IOException iOException) {
            System.err.println("Failed to shut down OMAP cursor");
        }
    }
}

