/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.UnsupportedEncodingException;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import sun.misc.MessageUtils;
import sun.nio.cs.ArrayDecoder;
import sun.nio.cs.ArrayEncoder;
import sun.nio.cs.HistoricallyNamedCharset;

class StringCoding {
    private static final ThreadLocal<SoftReference<StringDecoder>> decoder = new ThreadLocal();
    private static final ThreadLocal<SoftReference<StringEncoder>> encoder = new ThreadLocal();
    private static boolean warnUnsupportedCharset = true;

    private StringCoding() {
    }

    private static <T> T deref(ThreadLocal<SoftReference<T>> threadLocal) {
        SoftReference<T> softReference = threadLocal.get();
        if (softReference == null) {
            return null;
        }
        return softReference.get();
    }

    private static <T> void set(ThreadLocal<SoftReference<T>> threadLocal, T t) {
        threadLocal.set(new SoftReference<T>(t));
    }

    private static byte[] safeTrim(byte[] byArray, int n, Charset charset, boolean bl) {
        if (n == byArray.length && (bl || System.getSecurityManager() == null)) {
            return byArray;
        }
        return Arrays.copyOf(byArray, n);
    }

    private static char[] safeTrim(char[] cArray, int n, Charset charset, boolean bl) {
        if (n == cArray.length && (bl || System.getSecurityManager() == null)) {
            return cArray;
        }
        return Arrays.copyOf(cArray, n);
    }

    private static int scale(int n, float f) {
        return (int)((double)n * (double)f);
    }

    private static Charset lookupCharset(String string) {
        if (Charset.isSupported(string)) {
            try {
                return Charset.forName(string);
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                throw new Error(unsupportedCharsetException);
            }
        }
        return null;
    }

    private static void warnUnsupportedCharset(String string) {
        if (warnUnsupportedCharset) {
            MessageUtils.err("WARNING: Default charset " + string + " not supported, using ISO-8859-1 instead");
            warnUnsupportedCharset = false;
        }
    }

    static char[] decode(String string, byte[] byArray, int n, int n2) throws UnsupportedEncodingException {
        String string2;
        StringDecoder stringDecoder = (StringDecoder)StringCoding.deref(decoder);
        String string3 = string2 = string == null ? "ISO-8859-1" : string;
        if (stringDecoder == null || !string2.equals(stringDecoder.requestedCharsetName()) && !string2.equals(stringDecoder.charsetName())) {
            stringDecoder = null;
            try {
                Charset charset = StringCoding.lookupCharset(string2);
                if (charset != null) {
                    stringDecoder = new StringDecoder(charset, string2);
                }
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
                // empty catch block
            }
            if (stringDecoder == null) {
                throw new UnsupportedEncodingException(string2);
            }
            StringCoding.set(decoder, stringDecoder);
        }
        return stringDecoder.decode(byArray, n, n2);
    }

    static char[] decode(Charset charset, byte[] byArray, int n, int n2) {
        CharsetDecoder charsetDecoder = charset.newDecoder();
        int n3 = StringCoding.scale(n2, charsetDecoder.maxCharsPerByte());
        char[] cArray = new char[n3];
        if (n2 == 0) {
            return cArray;
        }
        boolean bl = false;
        if (System.getSecurityManager() != null && !(bl = charset.getClass().getClassLoader0() == null)) {
            byArray = Arrays.copyOfRange(byArray, n, n + n2);
            n = 0;
        }
        charsetDecoder.onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).reset();
        if (charsetDecoder instanceof ArrayDecoder) {
            int n4 = ((ArrayDecoder)((Object)charsetDecoder)).decode(byArray, n, n2, cArray);
            return StringCoding.safeTrim(cArray, n4, charset, bl);
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n, n2);
        CharBuffer charBuffer = CharBuffer.wrap(cArray);
        try {
            CoderResult coderResult = charsetDecoder.decode(byteBuffer, charBuffer, true);
            if (!coderResult.isUnderflow()) {
                coderResult.throwException();
            }
            if (!(coderResult = charsetDecoder.flush(charBuffer)).isUnderflow()) {
                coderResult.throwException();
            }
        }
        catch (CharacterCodingException characterCodingException) {
            throw new Error(characterCodingException);
        }
        return StringCoding.safeTrim(cArray, charBuffer.position(), charset, bl);
    }

    static char[] decode(byte[] byArray, int n, int n2) {
        String string = Charset.defaultCharset().name();
        try {
            return StringCoding.decode(string, byArray, n, n2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            StringCoding.warnUnsupportedCharset(string);
            try {
                return StringCoding.decode("ISO-8859-1", byArray, n, n2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException2) {
                MessageUtils.err("ISO-8859-1 charset not available: " + unsupportedEncodingException2.toString());
                System.exit(1);
                return null;
            }
        }
    }

    static byte[] encode(String string, char[] cArray, int n, int n2) throws UnsupportedEncodingException {
        String string2;
        StringEncoder stringEncoder = (StringEncoder)StringCoding.deref(encoder);
        String string3 = string2 = string == null ? "ISO-8859-1" : string;
        if (stringEncoder == null || !string2.equals(stringEncoder.requestedCharsetName()) && !string2.equals(stringEncoder.charsetName())) {
            stringEncoder = null;
            try {
                Charset charset = StringCoding.lookupCharset(string2);
                if (charset != null) {
                    stringEncoder = new StringEncoder(charset, string2);
                }
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
                // empty catch block
            }
            if (stringEncoder == null) {
                throw new UnsupportedEncodingException(string2);
            }
            StringCoding.set(encoder, stringEncoder);
        }
        return stringEncoder.encode(cArray, n, n2);
    }

    static byte[] encode(Charset charset, char[] cArray, int n, int n2) {
        CharsetEncoder charsetEncoder = charset.newEncoder();
        int n3 = StringCoding.scale(n2, charsetEncoder.maxBytesPerChar());
        byte[] byArray = new byte[n3];
        if (n2 == 0) {
            return byArray;
        }
        boolean bl = false;
        if (System.getSecurityManager() != null && !(bl = charset.getClass().getClassLoader0() == null)) {
            cArray = Arrays.copyOfRange(cArray, n, n + n2);
            n = 0;
        }
        charsetEncoder.onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).reset();
        if (charsetEncoder instanceof ArrayEncoder) {
            int n4 = ((ArrayEncoder)((Object)charsetEncoder)).encode(cArray, n, n2, byArray);
            return StringCoding.safeTrim(byArray, n4, charset, bl);
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        CharBuffer charBuffer = CharBuffer.wrap(cArray, n, n2);
        try {
            CoderResult coderResult = charsetEncoder.encode(charBuffer, byteBuffer, true);
            if (!coderResult.isUnderflow()) {
                coderResult.throwException();
            }
            if (!(coderResult = charsetEncoder.flush(byteBuffer)).isUnderflow()) {
                coderResult.throwException();
            }
        }
        catch (CharacterCodingException characterCodingException) {
            throw new Error(characterCodingException);
        }
        return StringCoding.safeTrim(byArray, byteBuffer.position(), charset, bl);
    }

    static byte[] encode(char[] cArray, int n, int n2) {
        String string = Charset.defaultCharset().name();
        try {
            return StringCoding.encode(string, cArray, n, n2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            StringCoding.warnUnsupportedCharset(string);
            try {
                return StringCoding.encode("ISO-8859-1", cArray, n, n2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException2) {
                MessageUtils.err("ISO-8859-1 charset not available: " + unsupportedEncodingException2.toString());
                System.exit(1);
                return null;
            }
        }
    }

    private static class StringEncoder {
        private Charset cs;
        private CharsetEncoder ce;
        private final String requestedCharsetName;
        private final boolean isTrusted;

        private StringEncoder(Charset charset, String string) {
            this.requestedCharsetName = string;
            this.cs = charset;
            this.ce = charset.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
            this.isTrusted = charset.getClass().getClassLoader0() == null;
        }

        String charsetName() {
            if (this.cs instanceof HistoricallyNamedCharset) {
                return ((HistoricallyNamedCharset)((Object)this.cs)).historicalName();
            }
            return this.cs.name();
        }

        final String requestedCharsetName() {
            return this.requestedCharsetName;
        }

        byte[] encode(char[] cArray, int n, int n2) {
            int n3 = StringCoding.scale(n2, this.ce.maxBytesPerChar());
            byte[] byArray = new byte[n3];
            if (n2 == 0) {
                return byArray;
            }
            if (this.ce instanceof ArrayEncoder) {
                int n4 = ((ArrayEncoder)((Object)this.ce)).encode(cArray, n, n2, byArray);
                return StringCoding.safeTrim(byArray, n4, this.cs, this.isTrusted);
            }
            this.ce.reset();
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            CharBuffer charBuffer = CharBuffer.wrap(cArray, n, n2);
            try {
                CoderResult coderResult = this.ce.encode(charBuffer, byteBuffer, true);
                if (!coderResult.isUnderflow()) {
                    coderResult.throwException();
                }
                if (!(coderResult = this.ce.flush(byteBuffer)).isUnderflow()) {
                    coderResult.throwException();
                }
            }
            catch (CharacterCodingException characterCodingException) {
                throw new Error(characterCodingException);
            }
            return StringCoding.safeTrim(byArray, byteBuffer.position(), this.cs, this.isTrusted);
        }
    }

    private static class StringDecoder {
        private final String requestedCharsetName;
        private final Charset cs;
        private final CharsetDecoder cd;
        private final boolean isTrusted;

        private StringDecoder(Charset charset, String string) {
            this.requestedCharsetName = string;
            this.cs = charset;
            this.cd = charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
            this.isTrusted = charset.getClass().getClassLoader0() == null;
        }

        String charsetName() {
            if (this.cs instanceof HistoricallyNamedCharset) {
                return ((HistoricallyNamedCharset)((Object)this.cs)).historicalName();
            }
            return this.cs.name();
        }

        final String requestedCharsetName() {
            return this.requestedCharsetName;
        }

        char[] decode(byte[] byArray, int n, int n2) {
            int n3 = StringCoding.scale(n2, this.cd.maxCharsPerByte());
            char[] cArray = new char[n3];
            if (n2 == 0) {
                return cArray;
            }
            if (this.cd instanceof ArrayDecoder) {
                int n4 = ((ArrayDecoder)((Object)this.cd)).decode(byArray, n, n2, cArray);
                return StringCoding.safeTrim(cArray, n4, this.cs, this.isTrusted);
            }
            this.cd.reset();
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n, n2);
            CharBuffer charBuffer = CharBuffer.wrap(cArray);
            try {
                CoderResult coderResult = this.cd.decode(byteBuffer, charBuffer, true);
                if (!coderResult.isUnderflow()) {
                    coderResult.throwException();
                }
                if (!(coderResult = this.cd.flush(charBuffer)).isUnderflow()) {
                    coderResult.throwException();
                }
            }
            catch (CharacterCodingException characterCodingException) {
                throw new Error(characterCodingException);
            }
            return StringCoding.safeTrim(cArray, charBuffer.position(), this.cs, this.isTrusted);
        }
    }
}

