/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.LinkedList;
import javax.crypto.SecretKey;
import sun.security.ssl.CipherSuite;
import sun.security.ssl.JsseJce;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.SSLHandshake;
import sun.security.util.MessageDigestSpi2;

final class HandshakeHash {
    private TranscriptHash transcriptHash = new CacheOnlyHash();
    private LinkedList<byte[]> reserves = new LinkedList();
    private boolean hasBeenUsed = false;

    HandshakeHash() {
    }

    void determine(ProtocolVersion protocolVersion, CipherSuite cipherSuite) {
        if (!(this.transcriptHash instanceof CacheOnlyHash)) {
            throw new IllegalStateException("Not expected instance of transcript hash");
        }
        CacheOnlyHash cacheOnlyHash = (CacheOnlyHash)this.transcriptHash;
        this.transcriptHash = protocolVersion.useTLS13PlusSpec() ? new T13HandshakeHash(cipherSuite) : (protocolVersion.useTLS12PlusSpec() || protocolVersion.isTLCP11() ? new T12HandshakeHash(cipherSuite) : (protocolVersion.useTLS10PlusSpec() ? new T10HandshakeHash(cipherSuite) : new S30HandshakeHash(cipherSuite)));
        byte[] byArray = cacheOnlyHash.baos.toByteArray();
        if (byArray.length != 0) {
            this.transcriptHash.update(byArray, 0, byArray.length);
        }
    }

    HandshakeHash copy() {
        if (this.transcriptHash instanceof CacheOnlyHash) {
            HandshakeHash handshakeHash = new HandshakeHash();
            handshakeHash.transcriptHash = ((CacheOnlyHash)this.transcriptHash).copy();
            handshakeHash.reserves = new LinkedList<byte[]>(this.reserves);
            handshakeHash.hasBeenUsed = this.hasBeenUsed;
            return handshakeHash;
        }
        throw new IllegalStateException("Hash does not support copying");
    }

    void receive(byte[] byArray) {
        this.reserves.add(Arrays.copyOf(byArray, byArray.length));
    }

    void receive(ByteBuffer byteBuffer, int n) {
        if (byteBuffer.hasArray()) {
            int n2 = byteBuffer.position() + byteBuffer.arrayOffset();
            int n3 = n2 + n;
            this.reserves.add(Arrays.copyOfRange(byteBuffer.array(), n2, n3));
        } else {
            int n4 = byteBuffer.position();
            byte[] byArray = new byte[n];
            byteBuffer.get(byArray);
            byteBuffer.position(n4);
            this.reserves.add(Arrays.copyOf(byArray, byArray.length));
        }
    }

    void receive(ByteBuffer byteBuffer) {
        this.receive(byteBuffer, byteBuffer.remaining());
    }

    void push(byte[] byArray) {
        this.reserves.push(Arrays.copyOf(byArray, byArray.length));
    }

    byte[] removeLastReceived() {
        return this.reserves.removeLast();
    }

    void deliver(byte[] byArray) {
        this.update();
        this.transcriptHash.update(byArray, 0, byArray.length);
    }

    void deliver(byte[] byArray, int n, int n2) {
        this.update();
        this.transcriptHash.update(byArray, n, n2);
    }

    void deliver(ByteBuffer byteBuffer) {
        this.update();
        if (byteBuffer.hasArray()) {
            this.transcriptHash.update(byteBuffer.array(), byteBuffer.position() + byteBuffer.arrayOffset(), byteBuffer.remaining());
        } else {
            int n = byteBuffer.position();
            byte[] byArray = new byte[byteBuffer.remaining()];
            byteBuffer.get(byArray);
            byteBuffer.position(n);
            this.transcriptHash.update(byArray, 0, byArray.length);
        }
    }

    void utilize() {
        if (this.hasBeenUsed) {
            return;
        }
        if (this.reserves.size() != 0) {
            byte[] byArray = this.reserves.remove();
            this.transcriptHash.update(byArray, 0, byArray.length);
            this.hasBeenUsed = true;
        }
    }

    void consume() {
        if (this.hasBeenUsed) {
            this.hasBeenUsed = false;
            return;
        }
        if (this.reserves.size() != 0) {
            byte[] byArray = this.reserves.remove();
            this.transcriptHash.update(byArray, 0, byArray.length);
        }
    }

    void update() {
        while (this.reserves.size() != 0) {
            byte[] byArray = this.reserves.remove();
            this.transcriptHash.update(byArray, 0, byArray.length);
        }
        this.hasBeenUsed = false;
    }

    byte[] digest() {
        return this.transcriptHash.digest();
    }

    void finish() {
        this.transcriptHash = new CacheOnlyHash();
        this.reserves = new LinkedList();
        this.hasBeenUsed = false;
    }

    byte[] archived() {
        return this.transcriptHash.archived();
    }

    byte[] digest(String string) {
        T10HandshakeHash t10HandshakeHash = (T10HandshakeHash)this.transcriptHash;
        return t10HandshakeHash.digest(string);
    }

    byte[] digest(String string, SecretKey secretKey) {
        S30HandshakeHash s30HandshakeHash = (S30HandshakeHash)this.transcriptHash;
        return s30HandshakeHash.digest(string, secretKey);
    }

    byte[] digest(boolean bl, SecretKey secretKey) {
        S30HandshakeHash s30HandshakeHash = (S30HandshakeHash)this.transcriptHash;
        return s30HandshakeHash.digest(bl, secretKey);
    }

    public boolean isHashable(byte by) {
        return by != SSLHandshake.HELLO_REQUEST.id;
    }

    static final class NonCloneableHash
    implements TranscriptHash {
        private final MessageDigest md;
        private final ByteArrayOutputStream baos = new ByteArrayOutputStream();

        NonCloneableHash(MessageDigest messageDigest) {
            this.md = messageDigest;
        }

        @Override
        public void update(byte[] byArray, int n, int n2) {
            this.baos.write(byArray, n, n2);
        }

        @Override
        public byte[] digest() {
            byte[] byArray = this.baos.toByteArray();
            this.md.reset();
            return this.md.digest(byArray);
        }

        @Override
        public byte[] archived() {
            return this.baos.toByteArray();
        }
    }

    static final class CloneableHash
    implements TranscriptHash {
        private final MessageDigest md;

        CloneableHash(MessageDigest messageDigest) {
            this.md = messageDigest;
        }

        @Override
        public void update(byte[] byArray, int n, int n2) {
            this.md.update(byArray, n, n2);
        }

        @Override
        public byte[] digest() {
            try {
                return ((MessageDigest)this.md.clone()).digest();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return new byte[0];
            }
        }

        @Override
        public byte[] archived() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    static final class T13HandshakeHash
    implements TranscriptHash {
        private final TranscriptHash transcriptHash;

        T13HandshakeHash(CipherSuite cipherSuite) {
            MessageDigest messageDigest = JsseJce.getMessageDigest(cipherSuite.hashAlg.name);
            this.transcriptHash = messageDigest instanceof Cloneable ? new CloneableHash(messageDigest) : new NonCloneableHash(messageDigest);
        }

        @Override
        public void update(byte[] byArray, int n, int n2) {
            this.transcriptHash.update(byArray, n, n2);
        }

        @Override
        public byte[] digest() {
            return this.transcriptHash.digest();
        }

        @Override
        public byte[] archived() {
            throw new UnsupportedOperationException("TLS 1.3 does not require archived.");
        }
    }

    static final class T12HandshakeHash
    implements TranscriptHash {
        private final TranscriptHash transcriptHash;
        private final ByteArrayOutputStream baos;

        T12HandshakeHash(CipherSuite cipherSuite) {
            MessageDigest messageDigest = JsseJce.getMessageDigest(cipherSuite.hashAlg.name);
            if (messageDigest instanceof Cloneable) {
                this.transcriptHash = new CloneableHash(messageDigest);
                this.baos = new ByteArrayOutputStream();
            } else {
                this.transcriptHash = new NonCloneableHash(messageDigest);
                this.baos = null;
            }
        }

        @Override
        public void update(byte[] byArray, int n, int n2) {
            this.transcriptHash.update(byArray, n, n2);
            if (this.baos != null) {
                this.baos.write(byArray, n, n2);
            }
        }

        @Override
        public byte[] digest() {
            return this.transcriptHash.digest();
        }

        @Override
        public byte[] archived() {
            if (this.baos != null) {
                return this.baos.toByteArray();
            }
            return this.transcriptHash.archived();
        }
    }

    static final class T10HandshakeHash
    implements TranscriptHash {
        private final TranscriptHash md5;
        private final TranscriptHash sha;
        private final ByteArrayOutputStream baos;

        T10HandshakeHash(CipherSuite cipherSuite) {
            MessageDigest messageDigest = JsseJce.getMessageDigest("MD5");
            MessageDigest messageDigest2 = JsseJce.getMessageDigest("SHA");
            boolean bl = false;
            if (messageDigest instanceof Cloneable) {
                this.md5 = new CloneableHash(messageDigest);
            } else {
                bl = true;
                this.md5 = new NonCloneableHash(messageDigest);
            }
            if (messageDigest2 instanceof Cloneable) {
                this.sha = new CloneableHash(messageDigest2);
            } else {
                bl = true;
                this.sha = new NonCloneableHash(messageDigest2);
            }
            this.baos = bl ? null : new ByteArrayOutputStream();
        }

        @Override
        public void update(byte[] byArray, int n, int n2) {
            this.md5.update(byArray, n, n2);
            this.sha.update(byArray, n, n2);
            if (this.baos != null) {
                this.baos.write(byArray, n, n2);
            }
        }

        @Override
        public byte[] digest() {
            byte[] byArray = new byte[36];
            System.arraycopy(this.md5.digest(), 0, byArray, 0, 16);
            System.arraycopy(this.sha.digest(), 0, byArray, 16, 20);
            return byArray;
        }

        byte[] digest(String string) {
            if ("RSA".equalsIgnoreCase(string)) {
                return this.digest();
            }
            return this.sha.digest();
        }

        @Override
        public byte[] archived() {
            if (this.baos != null) {
                return this.baos.toByteArray();
            }
            if (this.md5 instanceof NonCloneableHash) {
                return this.md5.archived();
            }
            return this.sha.archived();
        }
    }

    static final class S30HandshakeHash
    implements TranscriptHash {
        static final byte[] MD5_pad1 = S30HandshakeHash.genPad(54, 48);
        static final byte[] MD5_pad2 = S30HandshakeHash.genPad(92, 48);
        static final byte[] SHA_pad1 = S30HandshakeHash.genPad(54, 40);
        static final byte[] SHA_pad2 = S30HandshakeHash.genPad(92, 40);
        private static final byte[] SSL_CLIENT = new byte[]{67, 76, 78, 84};
        private static final byte[] SSL_SERVER = new byte[]{83, 82, 86, 82};
        private final MessageDigest mdMD5 = JsseJce.getMessageDigest("MD5");
        private final MessageDigest mdSHA = JsseJce.getMessageDigest("SHA");
        private final TranscriptHash md5;
        private final TranscriptHash sha;
        private final ByteArrayOutputStream baos;

        S30HandshakeHash(CipherSuite cipherSuite) {
            boolean bl = false;
            if (this.mdMD5 instanceof Cloneable) {
                this.md5 = new CloneableHash(this.mdMD5);
            } else {
                bl = true;
                this.md5 = new NonCloneableHash(this.mdMD5);
            }
            if (this.mdSHA instanceof Cloneable) {
                this.sha = new CloneableHash(this.mdSHA);
            } else {
                bl = true;
                this.sha = new NonCloneableHash(this.mdSHA);
            }
            this.baos = bl ? null : new ByteArrayOutputStream();
        }

        @Override
        public void update(byte[] byArray, int n, int n2) {
            this.md5.update(byArray, n, n2);
            this.sha.update(byArray, n, n2);
            if (this.baos != null) {
                this.baos.write(byArray, n, n2);
            }
        }

        @Override
        public byte[] digest() {
            byte[] byArray = new byte[36];
            System.arraycopy(this.md5.digest(), 0, byArray, 0, 16);
            System.arraycopy(this.sha.digest(), 0, byArray, 16, 20);
            return byArray;
        }

        @Override
        public byte[] archived() {
            if (this.baos != null) {
                return this.baos.toByteArray();
            }
            if (this.md5 instanceof NonCloneableHash) {
                return this.md5.archived();
            }
            return this.sha.archived();
        }

        byte[] digest(boolean bl, SecretKey secretKey) {
            MessageDigest messageDigest = this.cloneMd5();
            MessageDigest messageDigest2 = this.cloneSha();
            if (bl) {
                messageDigest.update(SSL_CLIENT);
                messageDigest2.update(SSL_CLIENT);
            } else {
                messageDigest.update(SSL_SERVER);
                messageDigest2.update(SSL_SERVER);
            }
            S30HandshakeHash.updateDigest(messageDigest, MD5_pad1, MD5_pad2, secretKey);
            S30HandshakeHash.updateDigest(messageDigest2, SHA_pad1, SHA_pad2, secretKey);
            byte[] byArray = new byte[36];
            System.arraycopy(messageDigest.digest(), 0, byArray, 0, 16);
            System.arraycopy(messageDigest2.digest(), 0, byArray, 16, 20);
            return byArray;
        }

        byte[] digest(String string, SecretKey secretKey) {
            if ("RSA".equalsIgnoreCase(string)) {
                MessageDigest messageDigest = this.cloneMd5();
                MessageDigest messageDigest2 = this.cloneSha();
                S30HandshakeHash.updateDigest(messageDigest, MD5_pad1, MD5_pad2, secretKey);
                S30HandshakeHash.updateDigest(messageDigest2, SHA_pad1, SHA_pad2, secretKey);
                byte[] byArray = new byte[36];
                System.arraycopy(messageDigest.digest(), 0, byArray, 0, 16);
                System.arraycopy(messageDigest2.digest(), 0, byArray, 16, 20);
                return byArray;
            }
            MessageDigest messageDigest = this.cloneSha();
            S30HandshakeHash.updateDigest(messageDigest, SHA_pad1, SHA_pad2, secretKey);
            return messageDigest.digest();
        }

        private static byte[] genPad(int n, int n2) {
            byte[] byArray = new byte[n2];
            Arrays.fill(byArray, (byte)n);
            return byArray;
        }

        private MessageDigest cloneMd5() {
            MessageDigest messageDigest;
            if (this.mdMD5 instanceof Cloneable) {
                try {
                    messageDigest = (MessageDigest)this.mdMD5.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    throw new RuntimeException("MessageDigest does no support clone operation");
                }
            } else {
                messageDigest = JsseJce.getMessageDigest("MD5");
                messageDigest.update(this.md5.archived());
            }
            return messageDigest;
        }

        private MessageDigest cloneSha() {
            MessageDigest messageDigest;
            if (this.mdSHA instanceof Cloneable) {
                try {
                    messageDigest = (MessageDigest)this.mdSHA.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    throw new RuntimeException("MessageDigest does no support clone operation");
                }
            } else {
                messageDigest = JsseJce.getMessageDigest("SHA");
                messageDigest.update(this.sha.archived());
            }
            return messageDigest;
        }

        private static void updateDigest(MessageDigest messageDigest, byte[] byArray, byte[] byArray2, SecretKey secretKey) {
            byte[] byArray3;
            byte[] byArray4 = byArray3 = "RAW".equals(secretKey.getFormat()) ? secretKey.getEncoded() : null;
            if (byArray3 != null) {
                messageDigest.update(byArray3);
            } else {
                S30HandshakeHash.digestKey(messageDigest, secretKey);
            }
            messageDigest.update(byArray);
            byte[] byArray5 = messageDigest.digest();
            if (byArray3 != null) {
                messageDigest.update(byArray3);
            } else {
                S30HandshakeHash.digestKey(messageDigest, secretKey);
            }
            messageDigest.update(byArray2);
            messageDigest.update(byArray5);
        }

        private static void digestKey(MessageDigest messageDigest, SecretKey secretKey) {
            try {
                if (!(messageDigest instanceof MessageDigestSpi2)) {
                    throw new Exception("Digest does not support implUpdate(SecretKey)");
                }
                ((MessageDigestSpi2)((Object)messageDigest)).engineUpdate(secretKey);
            }
            catch (Exception exception) {
                throw new RuntimeException("Could not obtain encoded key and MessageDigest cannot digest key", exception);
            }
        }
    }

    private static final class CacheOnlyHash
    implements TranscriptHash {
        private final ByteArrayOutputStream baos = new ByteArrayOutputStream();

        CacheOnlyHash() {
        }

        @Override
        public void update(byte[] byArray, int n, int n2) {
            this.baos.write(byArray, n, n2);
        }

        @Override
        public byte[] digest() {
            throw new IllegalStateException("Not expected call to handshake hash digest");
        }

        @Override
        public byte[] archived() {
            return this.baos.toByteArray();
        }

        CacheOnlyHash copy() {
            CacheOnlyHash cacheOnlyHash = new CacheOnlyHash();
            try {
                this.baos.writeTo(cacheOnlyHash.baos);
            }
            catch (IOException iOException) {
                throw new RuntimeException("unable to to clone hash state");
            }
            return cacheOnlyHash;
        }
    }

    static interface TranscriptHash {
        public void update(byte[] var1, int var2, int var3);

        public byte[] digest();

        public byte[] archived();
    }
}

