/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.CryptoPrimitive;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.KeySpec;
import java.security.spec.SM2KeyAgreementParamSpec;
import java.security.spec.SM2PublicKeySpec;
import java.text.MessageFormat;
import java.util.EnumSet;
import java.util.Locale;
import javax.crypto.SecretKey;
import javax.net.ssl.SSLHandshakeException;
import sun.misc.HexDumpEncoder;
import sun.security.ssl.Alert;
import sun.security.ssl.ClientHandshakeContext;
import sun.security.ssl.ConnectionContext;
import sun.security.ssl.HandshakeContext;
import sun.security.ssl.HandshakeOutStream;
import sun.security.ssl.HandshakeProducer;
import sun.security.ssl.JsseJce;
import sun.security.ssl.Record;
import sun.security.ssl.SM2EKeyExchange;
import sun.security.ssl.SSLConsumer;
import sun.security.ssl.SSLCredentials;
import sun.security.ssl.SSLHandshake;
import sun.security.ssl.SSLKeyDerivation;
import sun.security.ssl.SSLKeyExchange;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.SSLTrafficKeyDerivation;
import sun.security.ssl.ServerHandshakeContext;
import sun.security.ssl.SupportedGroupsExtension;
import sun.security.ssl.TLCPAuthentication;
import sun.security.ssl.Utilities;

public class SM2EClientKeyExchange {
    static final SSLConsumer sm2eHandshakeConsumer = new SM2EClientKeyExchangeConsumer();
    static final HandshakeProducer sm2eHandshakeProducer = new SM2EClientKeyExchangeProducer();

    private static final class SM2EClientKeyExchangeConsumer
    implements SSLConsumer {
        private SM2EClientKeyExchangeConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, ByteBuffer byteBuffer) throws IOException {
            Object object6;
            Object object2;
            Object object3;
            Object object42;
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            SM2EKeyExchange.SM2EPossession sM2EPossession = null;
            for (Object object42 : serverHandshakeContext.handshakePossessions) {
                if (!(object42 instanceof SM2EKeyExchange.SM2EPossession)) continue;
                sM2EPossession = (SM2EKeyExchange.SM2EPossession)object42;
                break;
            }
            if (sM2EPossession == null) {
                throw serverHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "No expected SM2E possessions for client key exchange");
            }
            Object object5 = SupportedGroupsExtension.NamedGroup.valueOf(sM2EPossession.popEncPublicKey.getParams());
            if (object5 != SupportedGroupsExtension.NamedGroup.CURVESM2) {
                throw serverHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Unsupported EC server cert for SM2E client key exchange");
            }
            object42 = SSLKeyExchange.valueOf(serverHandshakeContext.negotiatedCipherSuite.keyExchange, serverHandshakeContext.negotiatedProtocol);
            if (object42 == null) {
                throw serverHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key exchange type");
            }
            SM2EClientKeyExchangeMessage sM2EClientKeyExchangeMessage = new SM2EClientKeyExchangeMessage((HandshakeContext)serverHandshakeContext, byteBuffer);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Consuming SM2E ClientKeyExchange handshake message", sM2EClientKeyExchangeMessage);
            }
            try {
                object3 = JsseJce.getKeyFactory("SM2");
                object2 = (ECPublicKey)((KeyFactory)object3).generatePublic((KeySpec)new SM2PublicKeySpec(sM2EClientKeyExchangeMessage.encodedPoint));
                if (serverHandshakeContext.algorithmConstraints != null && !serverHandshakeContext.algorithmConstraints.permits(EnumSet.of(CryptoPrimitive.KEY_AGREEMENT), (Key)object2)) {
                    throw new SSLHandshakeException("ECPublicKey does not comply to algorithm constraints");
                }
                serverHandshakeContext.handshakeCredentials.add(new SM2EKeyExchange.SM2ECredentials((ECPublicKey)object2, (SupportedGroupsExtension.NamedGroup)((Object)object5)));
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw (SSLHandshakeException)new SSLHandshakeException("Could not generate ECPublicKey").initCause(generalSecurityException);
            }
            object3 = null;
            for (Object object6 : serverHandshakeContext.handshakeCredentials) {
                if (!(object6 instanceof TLCPAuthentication.TLCP11Credentials)) continue;
                object3 = (TLCPAuthentication.TLCP11Credentials)object6;
                break;
            }
            object2 = new SM2KeyAgreementParamSpec(sM2EPossession.popEncPrivateKey, sM2EPossession.popEncPublicKey, (ECPublicKey)((TLCPAuthentication.TLCP11Credentials)object3).popEncPublicKey, true, 48);
            object6 = ((SSLKeyExchange)object42).createKeyDerivation(serverHandshakeContext);
            SecretKey secretKey = object6.deriveKey("MasterSecret", (AlgorithmParameterSpec)object2);
            serverHandshakeContext.handshakeSession.setMasterSecret(secretKey);
            SSLTrafficKeyDerivation sSLTrafficKeyDerivation = SSLTrafficKeyDerivation.valueOf(serverHandshakeContext.negotiatedProtocol);
            if (sSLTrafficKeyDerivation == null) {
                throw serverHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key derivation: " + (Object)((Object)serverHandshakeContext.negotiatedProtocol));
            }
            serverHandshakeContext.handshakeKeyDerivation = sSLTrafficKeyDerivation.createKeyDerivation(serverHandshakeContext, secretKey);
        }
    }

    private static final class SM2EClientKeyExchangeProducer
    implements HandshakeProducer {
        private SM2EClientKeyExchangeProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            SSLCredentials sSLCredentials;
            Object object4;
            Object object22;
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            SM2EKeyExchange.SM2ECredentials sM2ECredentials = null;
            for (Object object22 : clientHandshakeContext.handshakeCredentials) {
                if (!(object22 instanceof SM2EKeyExchange.SM2ECredentials)) continue;
                sM2ECredentials = (SM2EKeyExchange.SM2ECredentials)object22;
                break;
            }
            if (sM2ECredentials == null) {
                throw clientHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "No SM2E credentials negotiated for client key exchange");
            }
            Object object3 = null;
            for (Object object4 : clientHandshakeContext.handshakePossessions) {
                if (!(object4 instanceof TLCPAuthentication.TLCP11Possession)) continue;
                object3 = (TLCPAuthentication.TLCP11Possession)object4;
                break;
            }
            object22 = new SM2EKeyExchange.SM2EPossession((TLCPAuthentication.TLCP11Possession)object3, sM2ECredentials.namedGroup, clientHandshakeContext.sslContext.getSecureRandom());
            clientHandshakeContext.handshakePossessions.add(object22);
            object4 = new SM2EClientKeyExchangeMessage((HandshakeContext)clientHandshakeContext, ((SM2EKeyExchange.SM2EPossession)object22).encode());
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Produced SM2E ClientKeyExchange handshake message", object4);
            }
            ((SSLHandshake.HandshakeMessage)object4).write(clientHandshakeContext.handshakeOutput);
            clientHandshakeContext.handshakeOutput.flush();
            TLCPAuthentication.TLCP11Credentials tLCP11Credentials = null;
            Object object5 = clientHandshakeContext.handshakeCredentials.iterator();
            while (object5.hasNext()) {
                sSLCredentials = (SSLCredentials)object5.next();
                if (!(sSLCredentials instanceof TLCPAuthentication.TLCP11Credentials)) continue;
                tLCP11Credentials = (TLCPAuthentication.TLCP11Credentials)sSLCredentials;
                break;
            }
            if ((object5 = SSLKeyExchange.valueOf(clientHandshakeContext.negotiatedCipherSuite.keyExchange, clientHandshakeContext.negotiatedProtocol)) == null) {
                throw clientHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key exchange type");
            }
            sSLCredentials = new SM2KeyAgreementParamSpec((ECPrivateKey)((TLCPAuthentication.TLCP11Possession)object3).popEncPrivateKey, (ECPublicKey)((TLCPAuthentication.TLCP11Possession)object3).popEncPublicKey, (ECPublicKey)tLCP11Credentials.popEncPublicKey, false, 48);
            SSLKeyDerivation sSLKeyDerivation = ((SSLKeyExchange)object5).createKeyDerivation(clientHandshakeContext);
            SecretKey secretKey = sSLKeyDerivation.deriveKey("MasterSecret", (AlgorithmParameterSpec)((Object)sSLCredentials));
            clientHandshakeContext.handshakeSession.setMasterSecret(secretKey);
            SSLTrafficKeyDerivation sSLTrafficKeyDerivation = SSLTrafficKeyDerivation.valueOf(clientHandshakeContext.negotiatedProtocol);
            if (sSLTrafficKeyDerivation == null) {
                throw clientHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key derivation: " + (Object)((Object)clientHandshakeContext.negotiatedProtocol));
            }
            clientHandshakeContext.handshakeKeyDerivation = sSLTrafficKeyDerivation.createKeyDerivation(clientHandshakeContext, secretKey);
            return null;
        }
    }

    private static final class SM2EClientKeyExchangeMessage
    extends SSLHandshake.HandshakeMessage {
        private static final byte CURVE_NAMED_CURVE = 3;
        private final byte[] encodedPoint;

        SM2EClientKeyExchangeMessage(HandshakeContext handshakeContext, byte[] byArray) {
            super(handshakeContext);
            this.encodedPoint = byArray;
        }

        SM2EClientKeyExchangeMessage(HandshakeContext handshakeContext, ByteBuffer byteBuffer) throws IOException {
            super(handshakeContext);
            Record.getInt8(byteBuffer);
            Record.getInt16(byteBuffer);
            this.encodedPoint = byteBuffer.remaining() != 0 ? Record.getBytes8(byteBuffer) : new byte[0];
        }

        @Override
        public SSLHandshake handshakeType() {
            return SSLHandshake.CLIENT_KEY_EXCHANGE;
        }

        @Override
        public int messageLength() {
            if (this.encodedPoint == null || this.encodedPoint.length == 0) {
                return 0;
            }
            return 1 + this.encodedPoint.length + 3;
        }

        @Override
        public void send(HandshakeOutStream handshakeOutStream) throws IOException {
            handshakeOutStream.putInt8(3);
            handshakeOutStream.putInt16(SupportedGroupsExtension.NamedGroup.CURVESM2.id);
            if (this.encodedPoint != null && this.encodedPoint.length != 0) {
                handshakeOutStream.putBytes8(this.encodedPoint);
            }
        }

        public String toString() {
            MessageFormat messageFormat = new MessageFormat("\"SM2 ClientKeyExchange\": '{'\n  \"SM2 public\": '{'\n{0}\n  '}',\n'}'", Locale.ENGLISH);
            if (this.encodedPoint == null || this.encodedPoint.length == 0) {
                Object[] objectArray = new Object[]{"    <implicit>"};
                return messageFormat.format(objectArray);
            }
            HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
            Object[] objectArray = new Object[]{Utilities.indent(hexDumpEncoder.encodeBuffer(this.encodedPoint), "    ")};
            return messageFormat.format(objectArray);
        }
    }
}

