/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.SM2PublicKeySpec;
import java.security.spec.SM2SignatureParameterSpec;
import java.text.MessageFormat;
import java.util.Locale;
import sun.misc.HexDumpEncoder;
import sun.security.ssl.Alert;
import sun.security.ssl.ClientHandshakeContext;
import sun.security.ssl.ConnectionContext;
import sun.security.ssl.HandshakeContext;
import sun.security.ssl.HandshakeOutStream;
import sun.security.ssl.HandshakeProducer;
import sun.security.ssl.JsseJce;
import sun.security.ssl.Record;
import sun.security.ssl.SM2EKeyExchange;
import sun.security.ssl.SSLConsumer;
import sun.security.ssl.SSLHandshake;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.ServerHandshakeContext;
import sun.security.ssl.SignatureScheme;
import sun.security.ssl.SupportedGroupsExtension;
import sun.security.ssl.TLCPAuthentication;
import sun.security.ssl.Utilities;
import sun.security.util.SMUtil;

public class SM2EServerKeyExchange {
    static final SSLConsumer sm2eHandshakeConsumer = new SM2EServerKeyExchangeConsumer();
    static final HandshakeProducer sm2eHandshakeProducer = new SM2EServerKeyExchangeProducer();

    private static final class SM2EServerKeyExchangeConsumer
    implements SSLConsumer {
        private SM2EServerKeyExchangeConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, ByteBuffer byteBuffer) throws IOException {
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            SM2EServerKeyExchangeMessage sM2EServerKeyExchangeMessage = new SM2EServerKeyExchangeMessage(clientHandshakeContext, byteBuffer);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Consuming SM2 ServerKeyExchange handshake message", sM2EServerKeyExchangeMessage);
            }
            clientHandshakeContext.handshakeCredentials.add(new SM2EKeyExchange.SM2ECredentials(sM2EServerKeyExchangeMessage.publicKey, sM2EServerKeyExchangeMessage.namedGroup));
        }
    }

    private static final class SM2EServerKeyExchangeProducer
    implements HandshakeProducer {
        private SM2EServerKeyExchangeProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            SM2EServerKeyExchangeMessage sM2EServerKeyExchangeMessage = new SM2EServerKeyExchangeMessage(serverHandshakeContext);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Produced SM2 ServerKeyExchange handshake message", sM2EServerKeyExchangeMessage);
            }
            sM2EServerKeyExchangeMessage.write(serverHandshakeContext.handshakeOutput);
            serverHandshakeContext.handshakeOutput.flush();
            return null;
        }
    }

    private static final class SM2EServerKeyExchangeMessage
    extends SSLHandshake.HandshakeMessage {
        private static final byte CURVE_NAMED_CURVE = 3;
        private final SupportedGroupsExtension.NamedGroup namedGroup;
        private final byte[] publicPoint;
        private final byte[] paramsSignature;
        private final ECPublicKey publicKey;

        SM2EServerKeyExchangeMessage(HandshakeContext handshakeContext) throws IOException {
            super(handshakeContext);
            byte[] byArray;
            Signature signature;
            Object object2;
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)handshakeContext;
            SM2EKeyExchange.SM2EPossession sM2EPossession = null;
            TLCPAuthentication.TLCP11Possession tLCP11Possession = null;
            for (Object object2 : serverHandshakeContext.handshakePossessions) {
                if (object2 instanceof SM2EKeyExchange.SM2EPossession) {
                    sM2EPossession = (SM2EKeyExchange.SM2EPossession)object2;
                    if (tLCP11Possession == null) continue;
                    break;
                }
                if (!(object2 instanceof TLCPAuthentication.TLCP11Possession)) continue;
                tLCP11Possession = (TLCPAuthentication.TLCP11Possession)object2;
                if (sM2EPossession == null) continue;
                break;
            }
            if (sM2EPossession == null) {
                throw serverHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "No SM2 credentials negotiated for server key exchange");
            }
            ECParameterSpec eCParameterSpec = sM2EPossession.popEncPublicKey.getParams();
            SupportedGroupsExtension.NamedGroup namedGroup = this.namedGroup = eCParameterSpec != null ? SupportedGroupsExtension.NamedGroup.valueOf(eCParameterSpec) : null;
            if (this.namedGroup == null || this.namedGroup != SupportedGroupsExtension.NamedGroup.CURVESM2) {
                throw serverHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Missing or improper named group: " + (Object)((Object)this.namedGroup));
            }
            object2 = sM2EPossession.popEncPublicKey.getW();
            if (object2 == null) {
                throw serverHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Missing public point for named group: " + (Object)((Object)this.namedGroup));
            }
            this.publicKey = sM2EPossession.ephemeralPublicKey;
            this.publicPoint = SMUtil.encodePubPoint((ECPoint)this.publicKey.getW());
            try {
                signature = Signature.getInstance(SignatureScheme.SM2SIG_SM3.algorithm);
                signature.setParameter((AlgorithmParameterSpec)new SM2SignatureParameterSpec((ECPublicKey)tLCP11Possession.popSignPublicKey));
                signature.initSign(tLCP11Possession.popSignPrivateKey);
            }
            catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException generalSecurityException) {
                throw serverHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Unsupported signature algorithm: " + sM2EPossession.popEncPrivateKey.getAlgorithm(), generalSecurityException);
            }
            try {
                SM2EServerKeyExchangeMessage.updateSignature(signature, serverHandshakeContext.clientHelloRandom.randomBytes, serverHandshakeContext.serverHelloRandom.randomBytes, this.namedGroup.id, this.publicPoint);
                byArray = signature.sign();
            }
            catch (SignatureException signatureException) {
                throw serverHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Failed to sign ecdhe parameters: " + sM2EPossession.popEncPrivateKey.getAlgorithm(), signatureException);
            }
            this.paramsSignature = byArray;
        }

        SM2EServerKeyExchangeMessage(HandshakeContext handshakeContext, ByteBuffer byteBuffer) throws IOException {
            super(handshakeContext);
            ECPublicKey eCPublicKey;
            Object object2;
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)handshakeContext;
            byte by = (byte)Record.getInt8(byteBuffer);
            if (by != 3) {
                throw clientHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Unsupported ECCurveType: " + by);
            }
            int n = Record.getInt16(byteBuffer);
            this.namedGroup = SupportedGroupsExtension.NamedGroup.valueOf(n);
            if (this.namedGroup == null) {
                throw clientHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Unknown named group ID: " + n);
            }
            if (!SupportedGroupsExtension.SupportedGroups.isSupported(this.namedGroup)) {
                throw clientHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Unsupported named group: " + (Object)((Object)this.namedGroup));
            }
            this.publicPoint = Record.getBytes8(byteBuffer);
            if (this.publicPoint.length == 0) {
                throw clientHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Insufficient Point data: " + (Object)((Object)this.namedGroup));
            }
            TLCPAuthentication.TLCP11Credentials tLCP11Credentials = null;
            for (Object object2 : clientHandshakeContext.handshakeCredentials) {
                if (!(object2 instanceof TLCPAuthentication.TLCP11Credentials)) continue;
                tLCP11Credentials = (TLCPAuthentication.TLCP11Credentials)object2;
                break;
            }
            try {
                object2 = JsseJce.getKeyFactory("SM2");
                eCPublicKey = (ECPublicKey)((KeyFactory)object2).generatePublic((KeySpec)new SM2PublicKeySpec(this.publicPoint));
            }
            catch (NoSuchAlgorithmException | InvalidKeySpecException generalSecurityException) {
                throw clientHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Invalid ECPoint: " + (Object)((Object)this.namedGroup), generalSecurityException);
            }
            this.publicKey = eCPublicKey;
            if (tLCP11Credentials == null) {
                if (byteBuffer.hasRemaining()) {
                    throw clientHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Invalid DH ServerKeyExchange: unknown extra data");
                }
                this.paramsSignature = null;
                return;
            }
            this.paramsSignature = Record.getBytes16(byteBuffer);
            try {
                object2 = Signature.getInstance(SignatureScheme.SM2SIG_SM3.algorithm);
                ((Signature)object2).setParameter((AlgorithmParameterSpec)new SM2SignatureParameterSpec((ECPublicKey)tLCP11Credentials.popSignPublicKey));
                ((Signature)object2).initVerify(tLCP11Credentials.popSignPublicKey);
            }
            catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException generalSecurityException) {
                throw clientHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Unsupported signature algorithm: " + tLCP11Credentials.popSignPublicKey.getAlgorithm(), generalSecurityException);
            }
            try {
                SM2EServerKeyExchangeMessage.updateSignature((Signature)object2, clientHandshakeContext.clientHelloRandom.randomBytes, clientHandshakeContext.serverHelloRandom.randomBytes, this.namedGroup.id, this.publicPoint);
                if (!((Signature)object2).verify(this.paramsSignature)) {
                    throw clientHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Invalid SM2 ServerKeyExchange signature");
                }
            }
            catch (SignatureException signatureException) {
                throw clientHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Cannot verify SM2 ServerKeyExchange signature", signatureException);
            }
        }

        @Override
        public SSLHandshake handshakeType() {
            return SSLHandshake.SERVER_KEY_EXCHANGE;
        }

        @Override
        public int messageLength() {
            int n = 0;
            if (this.paramsSignature != null) {
                n = 2 + this.paramsSignature.length;
            }
            return 4 + this.publicPoint.length + n;
        }

        @Override
        public void send(HandshakeOutStream handshakeOutStream) throws IOException {
            handshakeOutStream.putInt8(3);
            handshakeOutStream.putInt16(this.namedGroup.id);
            handshakeOutStream.putBytes8(this.publicPoint);
            if (this.paramsSignature != null) {
                handshakeOutStream.putBytes16(this.paramsSignature);
            }
        }

        public String toString() {
            if (this.paramsSignature != null) {
                MessageFormat messageFormat = new MessageFormat("\"SM2 ServerKeyExchange\": '{'\n  \"parameters\":  '{'\n    \"named group\": \"{0}\"\n    \"ecdh public\": '{'\n{1}\n    '}',\n  '}',\n  \"signature\": '{'\n{2}\n  '}'\n'}'", Locale.ENGLISH);
                HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
                Object[] objectArray = new Object[]{this.namedGroup.name, Utilities.indent(hexDumpEncoder.encodeBuffer(this.publicPoint), "      "), Utilities.indent(hexDumpEncoder.encodeBuffer(this.paramsSignature), "    ")};
                return messageFormat.format(objectArray);
            }
            MessageFormat messageFormat = new MessageFormat("\"SM2 ServerKeyExchange\": '{'\n  \"parameters\":  '{'\n    \"named group\": \"{0}\"\n    \"ecdh public\": '{'\n{1}\n    '}',\n  '}'\n'}'", Locale.ENGLISH);
            HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
            Object[] objectArray = new Object[]{this.namedGroup.name, Utilities.indent(hexDumpEncoder.encodeBuffer(this.publicPoint), "      ")};
            return messageFormat.format(objectArray);
        }

        private static void updateSignature(Signature signature, byte[] byArray, byte[] byArray2, int n, byte[] byArray3) throws SignatureException {
            signature.update(byArray);
            signature.update(byArray2);
            signature.update((byte)3);
            signature.update((byte)(n >> 8 & 0xFF));
            signature.update((byte)(n & 0xFF));
            signature.update((byte)byArray3.length);
            signature.update(byArray3);
        }
    }
}

