/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PublicKey;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.text.Format;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import sun.security.ssl.Alert;
import sun.security.ssl.CipherSuite;
import sun.security.ssl.ClientAuthType;
import sun.security.ssl.ClientHandshakeContext;
import sun.security.ssl.ConnectionContext;
import sun.security.ssl.HandshakeContext;
import sun.security.ssl.HandshakeOutStream;
import sun.security.ssl.HandshakeProducer;
import sun.security.ssl.Record;
import sun.security.ssl.SSLConfiguration;
import sun.security.ssl.SSLConsumer;
import sun.security.ssl.SSLHandshake;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.ServerHandshakeContext;
import sun.security.ssl.TLCPAuthentication;
import sun.security.util.SMUtil;

public class TLCPCertificateMessage {
    static final SSLConsumer tlcp11HandshakeConsumer = new TLCP11CertificateConsumer();
    static final HandshakeProducer tlcp11HandshakeProducer = new TLCP11CertificateProducer();
    private static final CertListFormat DEF_CERT_LIST_FORMAT = CertListFormat.format(AccessController.doPrivileged(new PrivilegedAction<String>(){

        @Override
        public String run() {
            return System.getProperty("jdk.tlcp.certListFormat", CertListFormat.SIGN_ENC_CA.format);
        }
    }));

    private static X509Certificate[] mergeCertChains(X509Certificate[] x509CertificateArray, X509Certificate[] x509CertificateArray2) {
        if (x509CertificateArray == null || x509CertificateArray.length == 0 || x509CertificateArray2 == null || x509CertificateArray2.length == 0) {
            return new X509Certificate[0];
        }
        X509Certificate[] x509CertificateArray3 = new X509Certificate[x509CertificateArray.length + 1];
        if (DEF_CERT_LIST_FORMAT == CertListFormat.SIGN_CA_ENC) {
            System.arraycopy(x509CertificateArray, 0, x509CertificateArray3, 0, x509CertificateArray.length);
            x509CertificateArray3[x509CertificateArray3.length - 1] = x509CertificateArray2[0];
        } else {
            x509CertificateArray3[0] = x509CertificateArray[0];
            x509CertificateArray3[1] = x509CertificateArray2[0];
            if (x509CertificateArray.length > 1) {
                System.arraycopy(x509CertificateArray, 1, x509CertificateArray3, 2, x509CertificateArray.length - 1);
            }
        }
        return x509CertificateArray3;
    }

    static final class TLCP11CertificateConsumer
    implements SSLConsumer {
        private TLCP11CertificateConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, ByteBuffer byteBuffer) throws IOException {
            HandshakeContext handshakeContext = (HandshakeContext)connectionContext;
            handshakeContext.handshakeConsumers.remove(SSLHandshake.CERTIFICATE.id);
            TLCP11CertificateMessage tLCP11CertificateMessage = new TLCP11CertificateMessage(handshakeContext, byteBuffer);
            if (handshakeContext.sslConfig.isClientMode) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Consuming server Certificate handshake message", tLCP11CertificateMessage);
                }
                this.onCertificate((ClientHandshakeContext)connectionContext, tLCP11CertificateMessage);
            } else {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Consuming client Certificate handshake message", tLCP11CertificateMessage);
                }
                this.onCertificate((ServerHandshakeContext)connectionContext, tLCP11CertificateMessage);
            }
        }

        private void onCertificate(ServerHandshakeContext serverHandshakeContext, TLCP11CertificateMessage tLCP11CertificateMessage) throws IOException {
            List<byte[]> list = tLCP11CertificateMessage.encodedCertChain;
            if (list == null || list.isEmpty()) {
                serverHandshakeContext.handshakeConsumers.remove(SSLHandshake.CERTIFICATE_VERIFY.id);
                if (serverHandshakeContext.sslConfig.clientAuthType != ClientAuthType.CLIENT_AUTH_REQUESTED) {
                    throw serverHandshakeContext.conContext.fatal(Alert.BAD_CERTIFICATE, "Empty client certificate chain");
                }
                return;
            }
            X509Certificate[] x509CertificateArray = new X509Certificate[list.size()];
            try {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                int n = 0;
                for (byte[] byArray : list) {
                    x509CertificateArray[n++] = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(byArray));
                }
            }
            catch (CertificateException certificateException) {
                throw serverHandshakeContext.conContext.fatal(Alert.BAD_CERTIFICATE, "Failed to parse server certificates", certificateException);
            }
            TLCP11CertificateConsumer.checkClientCerts(serverHandshakeContext, x509CertificateArray);
            serverHandshakeContext.handshakeCredentials.add(TLCP11CertificateConsumer.createCredentials(x509CertificateArray, serverHandshakeContext));
            serverHandshakeContext.handshakeSession.setPeerCertificates(x509CertificateArray);
        }

        private void onCertificate(ClientHandshakeContext clientHandshakeContext, TLCP11CertificateMessage tLCP11CertificateMessage) throws IOException {
            Object object;
            List<byte[]> list = tLCP11CertificateMessage.encodedCertChain;
            if (list == null || list.isEmpty()) {
                throw clientHandshakeContext.conContext.fatal(Alert.BAD_CERTIFICATE, "Empty server certificate chain");
            }
            X509Certificate[] x509CertificateArray = new X509Certificate[list.size()];
            if (x509CertificateArray.length < 2) {
                throw clientHandshakeContext.conContext.fatal(Alert.BAD_CERTIFICATE, "Server must send at least two certificates");
            }
            try {
                object = CertificateFactory.getInstance("X.509");
                int n = 0;
                for (byte[] byArray : list) {
                    x509CertificateArray[n++] = (X509Certificate)((CertificateFactory)object).generateCertificate(new ByteArrayInputStream(byArray));
                }
            }
            catch (CertificateException certificateException) {
                throw clientHandshakeContext.conContext.fatal(Alert.BAD_CERTIFICATE, "Failed to parse server certificates", certificateException);
            }
            if (!(clientHandshakeContext.reservedServerCerts == null || clientHandshakeContext.handshakeSession.useExtendedMasterSecret || (object = clientHandshakeContext.sslConfig.identificationProtocol) != null && !((String)object).isEmpty() || TLCP11CertificateConsumer.isIdentityEquivalent(x509CertificateArray[0], clientHandshakeContext.reservedServerCerts[0]))) {
                throw clientHandshakeContext.conContext.fatal(Alert.BAD_CERTIFICATE, "server certificate change is restricted during renegotiation");
            }
            if (clientHandshakeContext.staplingActive) {
                clientHandshakeContext.deferredCerts = x509CertificateArray;
            } else {
                TLCP11CertificateConsumer.checkServerCerts(clientHandshakeContext, x509CertificateArray);
            }
            clientHandshakeContext.handshakeCredentials.add(TLCP11CertificateConsumer.createCredentials(x509CertificateArray, clientHandshakeContext));
            clientHandshakeContext.handshakeSession.setPeerCertificates(x509CertificateArray);
        }

        private static TLCPAuthentication.TLCP11Credentials createCredentials(X509Certificate[] x509CertificateArray, HandshakeContext handshakeContext) throws SSLException {
            X509Certificate x509Certificate = null;
            X509Certificate x509Certificate2 = null;
            X509Certificate[] x509CertificateArray2 = null;
            X509Certificate[] x509CertificateArray3 = null;
            if (x509CertificateArray.length == 1) {
                x509Certificate = x509CertificateArray[0];
                x509Certificate2 = x509CertificateArray[0];
                x509CertificateArray2 = new X509Certificate[]{x509Certificate};
                x509CertificateArray3 = new X509Certificate[]{x509Certificate2};
            } else if (x509CertificateArray.length == 2) {
                x509Certificate = x509CertificateArray[0];
                x509Certificate2 = x509CertificateArray[1];
                x509CertificateArray2 = new X509Certificate[]{x509Certificate};
                x509CertificateArray3 = new X509Certificate[]{x509Certificate2};
            } else if (x509CertificateArray.length > 2) {
                CertListFormat certListFormat = null;
                certListFormat = SMUtil.isCA((X509Certificate)x509CertificateArray[x509CertificateArray.length - 1]) ? CertListFormat.SIGN_ENC_CA : (SMUtil.isCA((X509Certificate)x509CertificateArray[1]) ? CertListFormat.SIGN_CA_ENC : DEF_CERT_LIST_FORMAT);
                x509CertificateArray2 = new X509Certificate[x509CertificateArray.length - 1];
                x509CertificateArray3 = new X509Certificate[x509CertificateArray.length - 1];
                if (certListFormat == CertListFormat.SIGN_CA_ENC) {
                    x509Certificate = x509CertificateArray[0];
                    System.arraycopy(x509CertificateArray, 0, x509CertificateArray2, 0, x509CertificateArray.length - 1);
                    x509CertificateArray3[0] = x509Certificate2 = x509CertificateArray[x509CertificateArray.length - 1];
                    System.arraycopy(x509CertificateArray, 1, x509CertificateArray3, 1, x509CertificateArray.length - 2);
                } else {
                    x509CertificateArray2[0] = x509Certificate = x509CertificateArray[0];
                    System.arraycopy(x509CertificateArray, 2, x509CertificateArray2, 1, x509CertificateArray.length - 2);
                    x509CertificateArray3[0] = x509Certificate2 = x509CertificateArray[1];
                    System.arraycopy(x509CertificateArray, 2, x509CertificateArray3, 1, x509CertificateArray.length - 2);
                }
            }
            if (!SMUtil.isSignCert((X509Certificate)x509Certificate)) {
                throw handshakeContext.conContext.fatal(Alert.BAD_CERTIFICATE, "The sign cert doesn't contain key usage digitalSignature");
            }
            if (!SMUtil.isEncCert((X509Certificate)x509Certificate2)) {
                throw handshakeContext.conContext.fatal(Alert.BAD_CERTIFICATE, "The enc cert doesn't contain key usages in keyEncipherment, dataEncipherment and keyAgreement.");
            }
            return new TLCPAuthentication.TLCP11Credentials(x509Certificate.getPublicKey(), x509CertificateArray2, x509Certificate2.getPublicKey(), x509CertificateArray3);
        }

        private static boolean isIdentityEquivalent(X509Certificate x509Certificate, X509Certificate x509Certificate2) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Collection<List<?>> collection;
            Collection<List<?>> collection2;
            block9: {
                block8: {
                    if (x509Certificate.equals(x509Certificate2)) {
                        return true;
                    }
                    collection2 = null;
                    try {
                        collection2 = x509Certificate.getSubjectAlternativeNames();
                    }
                    catch (CertificateParsingException certificateParsingException) {
                        if (!SSLLogger.isOn || !SSLLogger.isOn("handshake")) break block8;
                        SSLLogger.fine("Attempt to obtain subjectAltNames extension failed!", new Object[0]);
                    }
                }
                collection = null;
                try {
                    collection = x509Certificate2.getSubjectAlternativeNames();
                }
                catch (CertificateParsingException certificateParsingException) {
                    if (!SSLLogger.isOn || !SSLLogger.isOn("handshake")) break block9;
                    SSLLogger.fine("Attempt to obtain subjectAltNames extension failed!", new Object[0]);
                }
            }
            if (collection2 != null && collection != null) {
                object4 = TLCP11CertificateConsumer.getSubjectAltNames(collection2, 7);
                object3 = TLCP11CertificateConsumer.getSubjectAltNames(collection, 7);
                if (object4 != null && object3 != null && TLCP11CertificateConsumer.isEquivalent((Collection<String>)object4, (Collection<String>)object3)) {
                    return true;
                }
                object2 = TLCP11CertificateConsumer.getSubjectAltNames(collection2, 2);
                object = TLCP11CertificateConsumer.getSubjectAltNames(collection, 2);
                if (object2 != null && object != null && TLCP11CertificateConsumer.isEquivalent((Collection<String>)object2, (Collection<String>)object)) {
                    return true;
                }
            }
            object4 = x509Certificate.getSubjectX500Principal();
            object3 = x509Certificate2.getSubjectX500Principal();
            object2 = x509Certificate.getIssuerX500Principal();
            object = x509Certificate2.getIssuerX500Principal();
            return !((X500Principal)object4).getName().isEmpty() && !((X500Principal)object3).getName().isEmpty() && ((X500Principal)object4).equals(object3) && ((X500Principal)object2).equals(object);
        }

        private static Collection<String> getSubjectAltNames(Collection<List<?>> collection, int n) {
            HashSet<String> hashSet = null;
            for (List<?> list : collection) {
                String string;
                int n2 = (Integer)list.get(0);
                if (n2 != n || (string = (String)list.get(1)) == null || string.isEmpty()) continue;
                if (hashSet == null) {
                    hashSet = new HashSet<String>(collection.size());
                }
                hashSet.add(string);
            }
            return hashSet;
        }

        private static boolean isEquivalent(Collection<String> collection, Collection<String> collection2) {
            for (String string : collection) {
                for (String string2 : collection2) {
                    if (!string.equalsIgnoreCase(string2)) continue;
                    return true;
                }
            }
            return false;
        }

        static void checkServerCerts(ClientHandshakeContext clientHandshakeContext, X509Certificate[] x509CertificateArray) throws IOException {
            X509TrustManager x509TrustManager = clientHandshakeContext.sslContext.getX509TrustManager();
            String string = clientHandshakeContext.negotiatedCipherSuite.keyExchange == CipherSuite.KeyExchange.K_RSA_EXPORT || clientHandshakeContext.negotiatedCipherSuite.keyExchange == CipherSuite.KeyExchange.K_DHE_RSA_EXPORT ? CipherSuite.KeyExchange.K_RSA.name : clientHandshakeContext.negotiatedCipherSuite.keyExchange.name;
            try {
                if (x509TrustManager instanceof X509ExtendedTrustManager) {
                    if (clientHandshakeContext.conContext.transport instanceof SSLEngine) {
                        SSLEngine sSLEngine = (SSLEngine)((Object)clientHandshakeContext.conContext.transport);
                        ((X509ExtendedTrustManager)x509TrustManager).checkServerTrusted((X509Certificate[])x509CertificateArray.clone(), string, sSLEngine);
                    } else {
                        SSLSocket sSLSocket = (SSLSocket)((Object)clientHandshakeContext.conContext.transport);
                        ((X509ExtendedTrustManager)x509TrustManager).checkServerTrusted((X509Certificate[])x509CertificateArray.clone(), string, sSLSocket);
                    }
                } else {
                    throw new CertificateException("Improper X509TrustManager implementation");
                }
                clientHandshakeContext.handshakeSession.setPeerCertificates(x509CertificateArray);
            }
            catch (CertificateException certificateException) {
                throw clientHandshakeContext.conContext.fatal(TLCP11CertificateConsumer.getCertificateAlert(clientHandshakeContext, certificateException), certificateException);
            }
        }

        private static void checkClientCerts(ServerHandshakeContext serverHandshakeContext, X509Certificate[] x509CertificateArray) throws IOException {
            block14: {
                String string;
                X509TrustManager x509TrustManager = serverHandshakeContext.sslContext.getX509TrustManager();
                PublicKey publicKey = x509CertificateArray[0].getPublicKey();
                String string2 = publicKey.getAlgorithm();
                switch (string2) {
                    case "RSA": 
                    case "DSA": 
                    case "EC": 
                    case "RSASSA-PSS": {
                        string = string2;
                        break;
                    }
                    default: {
                        string = "UNKNOWN";
                    }
                }
                try {
                    if (x509TrustManager instanceof X509ExtendedTrustManager) {
                        Object object;
                        if (serverHandshakeContext.conContext.transport instanceof SSLEngine) {
                            object = (SSLEngine)((Object)serverHandshakeContext.conContext.transport);
                            ((X509ExtendedTrustManager)x509TrustManager).checkClientTrusted((X509Certificate[])x509CertificateArray.clone(), string, (SSLEngine)object);
                        } else {
                            object = (SSLSocket)((Object)serverHandshakeContext.conContext.transport);
                            ((X509ExtendedTrustManager)x509TrustManager).checkClientTrusted((X509Certificate[])x509CertificateArray.clone(), string, (Socket)object);
                        }
                        break block14;
                    }
                    throw new CertificateException("Improper X509TrustManager implementation");
                }
                catch (CertificateException certificateException) {
                    throw serverHandshakeContext.conContext.fatal(Alert.CERTIFICATE_UNKNOWN, certificateException);
                }
            }
        }

        private static Alert getCertificateAlert(ClientHandshakeContext clientHandshakeContext, CertificateException certificateException) {
            Alert alert = Alert.CERTIFICATE_UNKNOWN;
            Throwable throwable = certificateException.getCause();
            if (throwable instanceof CertPathValidatorException) {
                CertPathValidatorException certPathValidatorException = (CertPathValidatorException)throwable;
                CertPathValidatorException.Reason reason = certPathValidatorException.getReason();
                if (reason == CertPathValidatorException.BasicReason.REVOKED) {
                    alert = clientHandshakeContext.staplingActive ? Alert.BAD_CERT_STATUS_RESPONSE : Alert.CERTIFICATE_REVOKED;
                } else if (reason == CertPathValidatorException.BasicReason.UNDETERMINED_REVOCATION_STATUS) {
                    alert = clientHandshakeContext.staplingActive ? Alert.BAD_CERT_STATUS_RESPONSE : Alert.CERTIFICATE_UNKNOWN;
                } else if (reason == CertPathValidatorException.BasicReason.ALGORITHM_CONSTRAINED) {
                    alert = Alert.UNSUPPORTED_CERTIFICATE;
                } else if (reason == CertPathValidatorException.BasicReason.EXPIRED) {
                    alert = Alert.CERTIFICATE_EXPIRED;
                } else if (reason == CertPathValidatorException.BasicReason.INVALID_SIGNATURE || reason == CertPathValidatorException.BasicReason.NOT_YET_VALID) {
                    alert = Alert.BAD_CERTIFICATE;
                }
            }
            return alert;
        }
    }

    private static final class TLCP11CertificateProducer
    implements HandshakeProducer {
        private TLCP11CertificateProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            HandshakeContext handshakeContext = (HandshakeContext)connectionContext;
            if (handshakeContext.sslConfig.isClientMode) {
                return this.onProduceCertificate((ClientHandshakeContext)connectionContext, handshakeMessage);
            }
            return this.onProduceCertificate((ServerHandshakeContext)connectionContext, handshakeMessage);
        }

        private byte[] onProduceCertificate(ServerHandshakeContext serverHandshakeContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            Object object2;
            TLCPAuthentication.TLCP11Possession tLCP11Possession = null;
            for (Object object2 : serverHandshakeContext.handshakePossessions) {
                if (!(object2 instanceof TLCPAuthentication.TLCP11Possession)) continue;
                tLCP11Possession = (TLCPAuthentication.TLCP11Possession)object2;
                break;
            }
            if (tLCP11Possession == null) {
                throw serverHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "No expected X.509 certificate for server authentication");
            }
            serverHandshakeContext.handshakeSession.setLocalPrivateKey(tLCP11Possession.popSignPrivateKey);
            X509Certificate[] x509CertificateArray = TLCPCertificateMessage.mergeCertChains(tLCP11Possession.popSignCerts, tLCP11Possession.popEncCerts);
            serverHandshakeContext.handshakeSession.setLocalCertificates(x509CertificateArray);
            object2 = new TLCP11CertificateMessage((HandshakeContext)serverHandshakeContext, x509CertificateArray);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Produced server Certificate handshake message", object2);
            }
            ((SSLHandshake.HandshakeMessage)object2).write(serverHandshakeContext.handshakeOutput);
            serverHandshakeContext.handshakeOutput.flush();
            return null;
        }

        private byte[] onProduceCertificate(ClientHandshakeContext clientHandshakeContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            Object object2;
            TLCPAuthentication.TLCP11Possession tLCP11Possession = null;
            for (Object object2 : clientHandshakeContext.handshakePossessions) {
                if (!(object2 instanceof TLCPAuthentication.TLCP11Possession)) continue;
                tLCP11Possession = (TLCPAuthentication.TLCP11Possession)object2;
                break;
            }
            if (tLCP11Possession == null) {
                if (clientHandshakeContext.negotiatedProtocol.isTLCP11() || clientHandshakeContext.negotiatedProtocol.useTLS10PlusSpec()) {
                    if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                        SSLLogger.fine("No X.509 certificate for client authentication, use empty Certificate message instead", new Object[0]);
                    }
                    tLCP11Possession = new TLCPAuthentication.TLCP11Possession(null, new X509Certificate[0], null, new X509Certificate[0]);
                } else {
                    if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                        SSLLogger.fine("No X.509 certificate for client authentication, send a no_certificate alert", new Object[0]);
                    }
                    clientHandshakeContext.conContext.warning(Alert.NO_CERTIFICATE);
                    return null;
                }
            }
            clientHandshakeContext.handshakeSession.setLocalPrivateKey(tLCP11Possession.popSignPrivateKey);
            X509Certificate[] x509CertificateArray = TLCPCertificateMessage.mergeCertChains(tLCP11Possession.popSignCerts, tLCP11Possession.popEncCerts);
            if (x509CertificateArray != null && x509CertificateArray.length != 0) {
                clientHandshakeContext.handshakeSession.setLocalCertificates(x509CertificateArray);
            } else {
                clientHandshakeContext.handshakeSession.setLocalCertificates(null);
            }
            object2 = new TLCP11CertificateMessage((HandshakeContext)clientHandshakeContext, x509CertificateArray);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Produced client Certificate handshake message", object2);
            }
            ((SSLHandshake.HandshakeMessage)object2).write(clientHandshakeContext.handshakeOutput);
            clientHandshakeContext.handshakeOutput.flush();
            return null;
        }
    }

    static final class TLCP11CertificateMessage
    extends SSLHandshake.HandshakeMessage {
        final List<byte[]> encodedCertChain;

        TLCP11CertificateMessage(HandshakeContext handshakeContext, X509Certificate[] x509CertificateArray) throws SSLException {
            super(handshakeContext);
            ArrayList<byte[]> arrayList = new ArrayList<byte[]>(x509CertificateArray.length);
            for (X509Certificate x509Certificate : x509CertificateArray) {
                try {
                    arrayList.add(x509Certificate.getEncoded());
                }
                catch (CertificateEncodingException certificateEncodingException) {
                    throw handshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Could not encode certificate (" + x509Certificate.getSubjectX500Principal() + ")", certificateEncodingException);
                }
            }
            this.encodedCertChain = arrayList;
        }

        TLCP11CertificateMessage(HandshakeContext handshakeContext, ByteBuffer byteBuffer) throws IOException {
            super(handshakeContext);
            int n;
            if (n > byteBuffer.remaining()) {
                throw handshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Error parsing certificate message:no sufficient data");
            }
            if (n > 0) {
                byte[] byArray;
                LinkedList<byte[]> linkedList = new LinkedList<byte[]>();
                for (n = Record.getInt24(byteBuffer); n > 0; n -= 3 + byArray.length) {
                    byArray = Record.getBytes24(byteBuffer);
                    linkedList.add(byArray);
                    if (linkedList.size() <= SSLConfiguration.maxCertificateChainLength) continue;
                    throw new SSLProtocolException("The certificate chain length (" + linkedList.size() + ") exceeds the maximum allowed length (" + SSLConfiguration.maxCertificateChainLength + ")");
                }
                this.encodedCertChain = linkedList;
            } else {
                this.encodedCertChain = Collections.emptyList();
            }
        }

        @Override
        public SSLHandshake handshakeType() {
            return SSLHandshake.CERTIFICATE;
        }

        @Override
        public int messageLength() {
            int n = 3;
            for (byte[] byArray : this.encodedCertChain) {
                n += byArray.length + 3;
            }
            return n;
        }

        @Override
        public void send(HandshakeOutStream handshakeOutStream) throws IOException {
            int n = 0;
            for (byte[] byArray : this.encodedCertChain) {
                n += byArray.length + 3;
            }
            handshakeOutStream.putInt24(n);
            for (byte[] byArray : this.encodedCertChain) {
                handshakeOutStream.putBytes24(byArray);
            }
        }

        public String toString() {
            int n;
            Object object;
            if (this.encodedCertChain.isEmpty()) {
                return "\"Certificates\": <empty list>";
            }
            Object[] objectArray = new Object[this.encodedCertChain.size()];
            try {
                object = CertificateFactory.getInstance("X.509");
                n = 0;
                for (byte[] byArray : this.encodedCertChain) {
                    Object object2;
                    try {
                        object2 = (X509Certificate)((CertificateFactory)object).generateCertificate(new ByteArrayInputStream(byArray));
                    }
                    catch (CertificateException certificateException) {
                        object2 = byArray;
                    }
                    objectArray[n++] = object2;
                }
            }
            catch (CertificateException certificateException) {
                n = 0;
                for (byte[] byArray : this.encodedCertChain) {
                    objectArray[n++] = byArray;
                }
            }
            object = new MessageFormat("\"Certificates\": [\n{0}\n]", Locale.ENGLISH);
            Object[] objectArray2 = new Object[]{SSLLogger.toString(objectArray)};
            return ((Format)object).format(objectArray2);
        }
    }

    private static enum CertListFormat {
        SIGN_ENC_CA("SIGN|ENC|CA"),
        SIGN_CA_ENC("SIGN|CA|ENC");

        private final String format;

        private CertListFormat(String string2) {
            this.format = string2;
        }

        static CertListFormat format(String string) {
            return CertListFormat.SIGN_CA_ENC.format.equalsIgnoreCase(string) ? SIGN_CA_ENC : SIGN_ENC_CA;
        }
    }
}

