/*
 * Decompiled with CFR 0.152.
 */
package java.security.spec;

import java.math.BigInteger;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.SM2ParameterSpec;
import java.util.Objects;

public final class SM2KeyAgreementParamSpec
implements AlgorithmParameterSpec {
    private static final byte[] DEFAULT_ID = new byte[]{49, 50, 51, 52, 53, 54, 55, 56, 49, 50, 51, 52, 53, 54, 55, 56};
    private final byte[] id;
    private final ECPrivateKey privateKey;
    private final ECPublicKey publicKey;
    private final byte[] peerId;
    private final ECPublicKey peerPublicKey;
    private final boolean isInitiator;
    private final int sharedKeyLength;

    public SM2KeyAgreementParamSpec(byte[] byArray, ECPrivateKey eCPrivateKey, ECPublicKey eCPublicKey, byte[] byArray2, ECPublicKey eCPublicKey2, boolean bl, int n) {
        Objects.requireNonNull(byArray, "id must not be null");
        Objects.requireNonNull(eCPrivateKey, "privateKey must not be null");
        Objects.requireNonNull(eCPublicKey, "publicKey must not be null");
        Objects.requireNonNull(byArray2, "peerId must not be null");
        Objects.requireNonNull(eCPublicKey2, "peerPublicKey must not be null");
        if (byArray.length >= 8192 || byArray2.length >= 8192) {
            throw new IllegalArgumentException("The length of ID must be less than 8192-bytes");
        }
        BigInteger bigInteger = eCPrivateKey.getS();
        if (bigInteger.compareTo(BigInteger.ZERO) <= 0 || bigInteger.compareTo(SM2ParameterSpec.ORDER) >= 0) {
            throw new IllegalArgumentException("The private key must be within the range [1, n - 1]");
        }
        this.id = (byte[])byArray.clone();
        this.privateKey = eCPrivateKey;
        this.publicKey = eCPublicKey;
        this.peerId = (byte[])byArray2.clone();
        this.peerPublicKey = eCPublicKey2;
        this.isInitiator = bl;
        this.sharedKeyLength = n;
    }

    public SM2KeyAgreementParamSpec(ECPrivateKey eCPrivateKey, ECPublicKey eCPublicKey, ECPublicKey eCPublicKey2, boolean bl, int n) {
        this(DEFAULT_ID, eCPrivateKey, eCPublicKey, DEFAULT_ID, eCPublicKey2, bl, n);
    }

    public byte[] id() {
        return (byte[])this.id.clone();
    }

    public ECPrivateKey privateKey() {
        return this.privateKey;
    }

    public ECPublicKey publicKey() {
        return this.publicKey;
    }

    public byte[] peerId() {
        return (byte[])this.peerId.clone();
    }

    public ECPublicKey peerPublicKey() {
        return this.peerPublicKey;
    }

    public boolean isInitiator() {
        return this.isInitiator;
    }

    public int sharedKeyLength() {
        return this.sharedKeyLength;
    }
}

