/*
 * Decompiled with CFR 0.152.
 */
package java.security.spec;

import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Objects;

public final class SM2SignatureParameterSpec
implements AlgorithmParameterSpec {
    private static final byte[] DEFAULT_ID = new byte[]{49, 50, 51, 52, 53, 54, 55, 56, 49, 50, 51, 52, 53, 54, 55, 56};
    private final byte[] id;
    private final ECPublicKey publicKey;

    public SM2SignatureParameterSpec(byte[] byArray, ECPublicKey eCPublicKey) {
        Objects.requireNonNull(byArray);
        Objects.requireNonNull(eCPublicKey);
        if (byArray.length >= 8192) {
            throw new IllegalArgumentException("The length of ID must be less than 8192-bytes");
        }
        this.id = (byte[])byArray.clone();
        this.publicKey = eCPublicKey;
    }

    public SM2SignatureParameterSpec(ECPublicKey eCPublicKey) {
        this(DEFAULT_ID, eCPublicKey);
    }

    public byte[] getId() {
        return (byte[])this.id.clone();
    }

    public ECPublicKey getPublicKey() {
        return this.publicKey;
    }
}

