/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECField;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.SM2ParameterSpec;
import sun.security.util.ArrayUtil;
import sun.security.util.KnownOIDs;

public final class SMUtil {
    public static int rotateLeft(int n, int n2) {
        return n << n2 | n >>> 32 - n2;
    }

    public static byte[] toByteArrayLE(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        ArrayUtil.reverse(byArray);
        return byArray;
    }

    public static int bytes4ToInt(byte[] byArray, int n) {
        return byArray[n] << 24 | (byArray[++n] & 0xFF) << 16 | (byArray[++n] & 0xFF) << 8 | byArray[++n] & 0xFF;
    }

    public static void intToBytes4(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)(n >>> 24);
        byArray[++n2] = (byte)(n >>> 16);
        byArray[++n2] = (byte)(n >>> 8);
        byArray[++n2] = (byte)n;
    }

    public static byte[] intToBytes4(int n) {
        byte[] byArray = new byte[4];
        SMUtil.intToBytes4(n, byArray, 0);
        return byArray;
    }

    public static void intsToBytes(int[] nArray, int n, byte[] byArray, int n2, int n3) {
        for (int i = n; i < n + n3; ++i) {
            SMUtil.intToBytes4(nArray[i], byArray, n2 + i * 4);
        }
    }

    public static byte[] bigIntToBytes32(BigInteger bigInteger) {
        byte[] byArray = new byte[32];
        SMUtil.bigIntToBytes32(bigInteger, byArray);
        return byArray;
    }

    private static void bigIntToBytes32(BigInteger bigInteger, byte[] byArray) {
        byte[] byArray2 = bigInteger.toByteArray();
        if (byArray2.length == 32) {
            System.arraycopy(byArray2, 0, byArray, 0, 32);
        } else {
            int n = byArray2[0] == 0 && byArray2.length != 1 ? 1 : 0;
            int n2 = byArray2.length - n;
            if (n2 > 32) {
                throw new IllegalArgumentException("The value must not be longer than 32-bytes");
            }
            System.arraycopy(byArray2, n, byArray, 32 - n2, n2);
        }
    }

    public static byte[] hexToBytes(String string) {
        int n = string.length();
        byte[] byArray = new byte[n / 2];
        for (int i = 0; i < n; i += 2) {
            byArray[i / 2] = (byte)((Character.digit(string.charAt(i), 16) << 4) + Character.digit(string.charAt(i + 1), 16));
        }
        return byArray;
    }

    public static byte[] hexToBytesLE(String string) {
        byte[] byArray = SMUtil.hexToBytes(string);
        ArrayUtil.reverse(byArray);
        return byArray;
    }

    public static byte[] encodePubPoint(ECPoint eCPoint) {
        byte[] byArray = SMUtil.bigIntToBytes32(eCPoint.getAffineX());
        byte[] byArray2 = SMUtil.bigIntToBytes32(eCPoint.getAffineY());
        byte[] byArray3 = new byte[65];
        byArray3[0] = 4;
        System.arraycopy(byArray, 0, byArray3, 1, 32);
        System.arraycopy(byArray2, 0, byArray3, 33, 32);
        return byArray3;
    }

    public static byte[] encodePrivKey(BigInteger bigInteger) {
        return SMUtil.bigIntToBytes32(bigInteger);
    }

    public static void validatePublicKey(ECPoint eCPoint, ECParameterSpec eCParameterSpec) throws InvalidKeyException {
        BigInteger bigInteger;
        ECField eCField = eCParameterSpec.getCurve().getField();
        if (!(eCField instanceof ECFieldFp)) {
            throw new InvalidKeyException("Only curves over prime fields are supported");
        }
        Object object = (ECFieldFp)eCField;
        BigInteger bigInteger2 = ((ECFieldFp)object).getP();
        if (eCPoint.equals(ECPoint.POINT_INFINITY)) {
            throw new InvalidKeyException("Public point is at infinity");
        }
        object = eCPoint.getAffineX();
        if (((BigInteger)object).signum() < 0 || ((BigInteger)object).compareTo(bigInteger2) >= 0) {
            throw new InvalidKeyException("Public point x is not in the interval [0, p-1]");
        }
        BigInteger bigInteger3 = eCPoint.getAffineY();
        if (bigInteger3.signum() < 0 || bigInteger3.compareTo(bigInteger2) >= 0) {
            throw new InvalidKeyException("Public point y is not in the interval [0, p-1]");
        }
        BigInteger bigInteger4 = bigInteger3.modPow(BigInteger.valueOf(2L), bigInteger2);
        if (!bigInteger4.equals(bigInteger = ((BigInteger)object).pow(3).add(eCParameterSpec.getCurve().getA().multiply((BigInteger)object)).add(eCParameterSpec.getCurve().getB()).mod(bigInteger2))) {
            throw new InvalidKeyException("Public point is not on the curve");
        }
    }

    public static boolean isSMCert(X509Certificate x509Certificate) {
        if (!(x509Certificate.getPublicKey() instanceof ECPublicKey)) {
            return false;
        }
        ECParameterSpec eCParameterSpec = ((ECPublicKey)x509Certificate.getPublicKey()).getParams();
        return SM2ParameterSpec.ORDER.equals(eCParameterSpec.getOrder()) && KnownOIDs.SM3withSM2.value().equals(x509Certificate.getSigAlgOID());
    }

    public static boolean isCA(X509Certificate x509Certificate) {
        return x509Certificate.getBasicConstraints() != -1;
    }

    public static boolean isSignCert(X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            return false;
        }
        boolean[] blArray = x509Certificate.getKeyUsage();
        return blArray == null || blArray[0];
    }

    public static boolean isEncCert(X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            return false;
        }
        boolean[] blArray = x509Certificate.getKeyUsage();
        return blArray == null || blArray[2] || blArray[3] || blArray[4];
    }

    private SMUtil() {
    }
}

