/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util.math.intpoly;

import java.math.BigInteger;
import sun.security.util.math.intpoly.IntegerPolynomial;

public class SM2OrderField
extends IntegerPolynomial {
    private static final int BITS_PER_LIMB = 26;
    private static final int NUM_LIMBS = 10;
    private static final int MAX_ADDS = 1;
    public static final BigInteger MODULUS = SM2OrderField.evaluateModulus();
    private static final long CARRY_ADD = 0x2000000L;
    private static final int LIMB_MASK = 0x3FFFFFF;

    public SM2OrderField() {
        super(26, 10, 1, MODULUS);
    }

    private static BigInteger evaluateModulus() {
        BigInteger bigInteger = BigInteger.valueOf(2L).pow(256);
        bigInteger = bigInteger.add(BigInteger.valueOf(30753059L));
        bigInteger = bigInteger.subtract(BigInteger.valueOf(16973234L).shiftLeft(26));
        bigInteger = bigInteger.add(BigInteger.valueOf(5420348L).shiftLeft(52));
        bigInteger = bigInteger.add(BigInteger.valueOf(28083992L).shiftLeft(78));
        bigInteger = bigInteger.subtract(BigInteger.valueOf(9305121L).shiftLeft(104));
        bigInteger = bigInteger.subtract(BigInteger.valueOf(65536L).shiftLeft(208));
        return bigInteger;
    }

    @Override
    protected void finalCarryReduceLast(long[] lArray) {
        long l = lArray[9] >> 22;
        lArray[9] = lArray[9] - (l << 22);
        long l2 = 30753059L * l;
        lArray[0] = lArray[0] + l2;
        l2 = -16973234L * l;
        lArray[1] = lArray[1] + l2;
        l2 = 5420348L * l;
        lArray[2] = lArray[2] + l2;
        l2 = 28083992L * l;
        lArray[3] = lArray[3] + l2;
        l2 = -9305121L * l;
        lArray[4] = lArray[4] + l2;
        l2 = -65536L * l;
        lArray[8] = lArray[8] + l2;
        l2 = 0x400000L * l;
        lArray[9] = lArray[9] + l2;
    }

    private void carryReduce(long[] lArray, long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9, long l10, long l11, long l12, long l13, long l14, long l15, long l16, long l17, long l18, long l19) {
        long l20 = 0L;
        long l21 = l + 0x2000000L >> 26;
        l -= l21 << 26;
        l2 += l21;
        l21 = l2 + 0x2000000L >> 26;
        l2 -= l21 << 26;
        l3 += l21;
        l21 = l3 + 0x2000000L >> 26;
        l3 -= l21 << 26;
        l4 += l21;
        l21 = l4 + 0x2000000L >> 26;
        l4 -= l21 << 26;
        l5 += l21;
        l21 = l5 + 0x2000000L >> 26;
        l5 -= l21 << 26;
        l6 += l21;
        l21 = l6 + 0x2000000L >> 26;
        l6 -= l21 << 26;
        l7 += l21;
        l21 = l7 + 0x2000000L >> 26;
        l7 -= l21 << 26;
        l8 += l21;
        l21 = l8 + 0x2000000L >> 26;
        l8 -= l21 << 26;
        l9 += l21;
        l21 = l9 + 0x2000000L >> 26;
        l9 -= l21 << 26;
        l10 += l21;
        l21 = l10 + 0x2000000L >> 26;
        l10 -= l21 << 26;
        l11 += l21;
        l21 = l11 + 0x2000000L >> 26;
        l11 -= l21 << 26;
        l12 += l21;
        l21 = l12 + 0x2000000L >> 26;
        l12 -= l21 << 26;
        l13 += l21;
        l21 = l13 + 0x2000000L >> 26;
        l13 -= l21 << 26;
        l14 += l21;
        l21 = l14 + 0x2000000L >> 26;
        l14 -= l21 << 26;
        l15 += l21;
        l21 = l15 + 0x2000000L >> 26;
        l15 -= l21 << 26;
        l16 += l21;
        l21 = l16 + 0x2000000L >> 26;
        l16 -= l21 << 26;
        l17 += l21;
        l21 = l17 + 0x2000000L >> 26;
        l17 -= l21 << 26;
        l18 += l21;
        l21 = l18 + 0x2000000L >> 26;
        l18 -= l21 << 26;
        l19 += l21;
        l21 = l19 + 0x2000000L >> 26;
        this.carryReduce0(lArray, l, l2, l3, l4, l5, l6, l7, l8, l9, l10, l11, l12, l13, l14, l15, l16, l17, l18, l19 -= l21 << 26, l20 += l21);
    }

    void carryReduce0(long[] lArray, long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9, long l10, long l11, long l12, long l13, long l14, long l15, long l16, long l17, long l18, long l19, long l20) {
        long l21 = 30753059L * l20;
        l10 += l21 << 4 & 0x3FFFFFFL;
        l11 += l21 >> 22;
        l21 = -16973234L * l20;
        l11 += l21 << 4 & 0x3FFFFFFL;
        l12 += l21 >> 22;
        l21 = 5420348L * l20;
        l12 += l21 << 4 & 0x3FFFFFFL;
        l13 += l21 >> 22;
        l21 = 28083992L * l20;
        l13 += l21 << 4 & 0x3FFFFFFL;
        l14 += l21 >> 22;
        l21 = -9305121L * l20;
        l14 += l21 << 4 & 0x3FFFFFFL;
        l15 += l21 >> 22;
        l21 = -65536L * l20;
        l18 += l21 << 4 & 0x3FFFFFFL;
        l19 += l21 >> 22;
        l21 = 0x400000L * l20;
        l19 += l21 << 4 & 0x3FFFFFFL;
        l20 += l21 >> 22;
        l21 = 30753059L * l19;
        l9 += l21 << 4 & 0x3FFFFFFL;
        l10 += l21 >> 22;
        l21 = -16973234L * l19;
        l10 += l21 << 4 & 0x3FFFFFFL;
        l11 += l21 >> 22;
        l21 = 5420348L * l19;
        l11 += l21 << 4 & 0x3FFFFFFL;
        l12 += l21 >> 22;
        l21 = 28083992L * l19;
        l12 += l21 << 4 & 0x3FFFFFFL;
        l13 += l21 >> 22;
        l21 = -9305121L * l19;
        l13 += l21 << 4 & 0x3FFFFFFL;
        l14 += l21 >> 22;
        l21 = -65536L * l19;
        l17 += l21 << 4 & 0x3FFFFFFL;
        l18 += l21 >> 22;
        l21 = 0x400000L * l19;
        l18 += l21 << 4 & 0x3FFFFFFL;
        l19 += l21 >> 22;
        l21 = 30753059L * l18;
        l8 += l21 << 4 & 0x3FFFFFFL;
        l9 += l21 >> 22;
        l21 = -16973234L * l18;
        l9 += l21 << 4 & 0x3FFFFFFL;
        l10 += l21 >> 22;
        l21 = 5420348L * l18;
        l10 += l21 << 4 & 0x3FFFFFFL;
        l11 += l21 >> 22;
        l21 = 28083992L * l18;
        l11 += l21 << 4 & 0x3FFFFFFL;
        l12 += l21 >> 22;
        l21 = -9305121L * l18;
        l12 += l21 << 4 & 0x3FFFFFFL;
        l13 += l21 >> 22;
        l21 = -65536L * l18;
        l16 += l21 << 4 & 0x3FFFFFFL;
        l17 += l21 >> 22;
        l21 = 0x400000L * l18;
        l17 += l21 << 4 & 0x3FFFFFFL;
        l18 += l21 >> 22;
        l21 = 30753059L * l17;
        l7 += l21 << 4 & 0x3FFFFFFL;
        l8 += l21 >> 22;
        l21 = -16973234L * l17;
        l8 += l21 << 4 & 0x3FFFFFFL;
        l9 += l21 >> 22;
        l21 = 5420348L * l17;
        l9 += l21 << 4 & 0x3FFFFFFL;
        l10 += l21 >> 22;
        l21 = 28083992L * l17;
        l10 += l21 << 4 & 0x3FFFFFFL;
        l11 += l21 >> 22;
        l21 = -9305121L * l17;
        l11 += l21 << 4 & 0x3FFFFFFL;
        l12 += l21 >> 22;
        l21 = -65536L * l17;
        l15 += l21 << 4 & 0x3FFFFFFL;
        l16 += l21 >> 22;
        l21 = 0x400000L * l17;
        l16 += l21 << 4 & 0x3FFFFFFL;
        l17 += l21 >> 22;
        l21 = 30753059L * l16;
        l6 += l21 << 4 & 0x3FFFFFFL;
        l7 += l21 >> 22;
        l21 = -16973234L * l16;
        l7 += l21 << 4 & 0x3FFFFFFL;
        l8 += l21 >> 22;
        l21 = 5420348L * l16;
        l8 += l21 << 4 & 0x3FFFFFFL;
        l9 += l21 >> 22;
        l21 = 28083992L * l16;
        l9 += l21 << 4 & 0x3FFFFFFL;
        l10 += l21 >> 22;
        l21 = -9305121L * l16;
        l10 += l21 << 4 & 0x3FFFFFFL;
        l11 += l21 >> 22;
        l21 = -65536L * l16;
        l14 += l21 << 4 & 0x3FFFFFFL;
        l15 += l21 >> 22;
        l21 = 0x400000L * l16;
        l15 += l21 << 4 & 0x3FFFFFFL;
        l16 += l21 >> 22;
        l21 = 30753059L * l15;
        l5 += l21 << 4 & 0x3FFFFFFL;
        l6 += l21 >> 22;
        l21 = -16973234L * l15;
        l6 += l21 << 4 & 0x3FFFFFFL;
        l7 += l21 >> 22;
        l21 = 5420348L * l15;
        l7 += l21 << 4 & 0x3FFFFFFL;
        l8 += l21 >> 22;
        l21 = 28083992L * l15;
        l8 += l21 << 4 & 0x3FFFFFFL;
        l9 += l21 >> 22;
        l21 = -9305121L * l15;
        l9 += l21 << 4 & 0x3FFFFFFL;
        l10 += l21 >> 22;
        l21 = -65536L * l15;
        l13 += l21 << 4 & 0x3FFFFFFL;
        l14 += l21 >> 22;
        l21 = 0x400000L * l15;
        l14 += l21 << 4 & 0x3FFFFFFL;
        l15 += l21 >> 22;
        l21 = 30753059L * l14;
        l4 += l21 << 4 & 0x3FFFFFFL;
        l5 += l21 >> 22;
        l21 = -16973234L * l14;
        l5 += l21 << 4 & 0x3FFFFFFL;
        l6 += l21 >> 22;
        l21 = 5420348L * l14;
        l6 += l21 << 4 & 0x3FFFFFFL;
        l7 += l21 >> 22;
        l21 = 28083992L * l14;
        l7 += l21 << 4 & 0x3FFFFFFL;
        l8 += l21 >> 22;
        l21 = -9305121L * l14;
        l8 += l21 << 4 & 0x3FFFFFFL;
        l9 += l21 >> 22;
        l21 = -65536L * l14;
        l12 += l21 << 4 & 0x3FFFFFFL;
        l13 += l21 >> 22;
        l21 = 0x400000L * l14;
        l13 += l21 << 4 & 0x3FFFFFFL;
        l14 += l21 >> 22;
        l21 = 30753059L * l13;
        l3 += l21 << 4 & 0x3FFFFFFL;
        l4 += l21 >> 22;
        l21 = -16973234L * l13;
        l4 += l21 << 4 & 0x3FFFFFFL;
        l5 += l21 >> 22;
        l21 = 5420348L * l13;
        l5 += l21 << 4 & 0x3FFFFFFL;
        l6 += l21 >> 22;
        l21 = 28083992L * l13;
        l6 += l21 << 4 & 0x3FFFFFFL;
        l7 += l21 >> 22;
        l21 = -9305121L * l13;
        l7 += l21 << 4 & 0x3FFFFFFL;
        l8 += l21 >> 22;
        l21 = -65536L * l13;
        l11 += l21 << 4 & 0x3FFFFFFL;
        l12 += l21 >> 22;
        l21 = 0x400000L * l13;
        l12 += l21 << 4 & 0x3FFFFFFL;
        l13 += l21 >> 22;
        l21 = 30753059L * l12;
        l2 += l21 << 4 & 0x3FFFFFFL;
        l3 += l21 >> 22;
        l21 = -16973234L * l12;
        l3 += l21 << 4 & 0x3FFFFFFL;
        l4 += l21 >> 22;
        l21 = 5420348L * l12;
        l4 += l21 << 4 & 0x3FFFFFFL;
        l5 += l21 >> 22;
        l21 = 28083992L * l12;
        l5 += l21 << 4 & 0x3FFFFFFL;
        l6 += l21 >> 22;
        l21 = -9305121L * l12;
        l6 += l21 << 4 & 0x3FFFFFFL;
        l7 += l21 >> 22;
        l21 = -65536L * l12;
        l10 += l21 << 4 & 0x3FFFFFFL;
        l11 += l21 >> 22;
        l21 = 0x400000L * l12;
        l11 += l21 << 4 & 0x3FFFFFFL;
        l12 += l21 >> 22;
        l21 = 30753059L * l11;
        l += l21 << 4 & 0x3FFFFFFL;
        l2 += l21 >> 22;
        l21 = -16973234L * l11;
        l2 += l21 << 4 & 0x3FFFFFFL;
        l3 += l21 >> 22;
        l21 = 5420348L * l11;
        l3 += l21 << 4 & 0x3FFFFFFL;
        l4 += l21 >> 22;
        l21 = 28083992L * l11;
        l4 += l21 << 4 & 0x3FFFFFFL;
        l5 += l21 >> 22;
        l21 = -9305121L * l11;
        l5 += l21 << 4 & 0x3FFFFFFL;
        l6 += l21 >> 22;
        l21 = -65536L * l11;
        l9 += l21 << 4 & 0x3FFFFFFL;
        l10 += l21 >> 22;
        l21 = 0x400000L * l11;
        l11 += l21 >> 22;
        l11 = 0L;
        this.carryReduce1(lArray, l, l2, l3, l4, l5, l6, l7, l8, l9, l10 += l21 << 4 & 0x3FFFFFFL, l11, l12, l13, l14, l15, l16, l17, l18, l19, l20);
    }

    void carryReduce1(long[] lArray, long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9, long l10, long l11, long l12, long l13, long l14, long l15, long l16, long l17, long l18, long l19, long l20) {
        long l21 = l + 0x2000000L >> 26;
        l -= l21 << 26;
        l2 += l21;
        l21 = l2 + 0x2000000L >> 26;
        l2 -= l21 << 26;
        l3 += l21;
        l21 = l3 + 0x2000000L >> 26;
        l3 -= l21 << 26;
        l4 += l21;
        l21 = l4 + 0x2000000L >> 26;
        l4 -= l21 << 26;
        l5 += l21;
        l21 = l5 + 0x2000000L >> 26;
        l5 -= l21 << 26;
        l6 += l21;
        l21 = l6 + 0x2000000L >> 26;
        l6 -= l21 << 26;
        l7 += l21;
        l21 = l7 + 0x2000000L >> 26;
        l7 -= l21 << 26;
        l8 += l21;
        l21 = l8 + 0x2000000L >> 26;
        l8 -= l21 << 26;
        l9 += l21;
        l21 = l9 + 0x2000000L >> 26;
        l9 -= l21 << 26;
        l10 += l21;
        l21 = l10 + 0x2000000L >> 26;
        this.carryReduce2(lArray, l, l2, l3, l4, l5, l6, l7, l8, l9, l10 -= l21 << 26, l11 += l21, l12, l13, l14, l15, l16, l17, l18, l19, l20);
    }

    void carryReduce2(long[] lArray, long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9, long l10, long l11, long l12, long l13, long l14, long l15, long l16, long l17, long l18, long l19, long l20) {
        long l21 = 30753059L * l11;
        l += l21 << 4 & 0x3FFFFFFL;
        l2 += l21 >> 22;
        l21 = -16973234L * l11;
        l2 += l21 << 4 & 0x3FFFFFFL;
        l3 += l21 >> 22;
        l21 = 5420348L * l11;
        l3 += l21 << 4 & 0x3FFFFFFL;
        l4 += l21 >> 22;
        l21 = 28083992L * l11;
        l4 += l21 << 4 & 0x3FFFFFFL;
        l5 += l21 >> 22;
        l21 = -9305121L * l11;
        l5 += l21 << 4 & 0x3FFFFFFL;
        l6 += l21 >> 22;
        l21 = -65536L * l11;
        l9 += l21 << 4 & 0x3FFFFFFL;
        l10 += l21 >> 22;
        l21 = 0x400000L * l11;
        l10 += l21 << 4 & 0x3FFFFFFL;
        l11 += l21 >> 22;
        l21 = l + 0x2000000L >> 26;
        l -= l21 << 26;
        l2 += l21;
        l21 = l2 + 0x2000000L >> 26;
        l2 -= l21 << 26;
        l3 += l21;
        l21 = l3 + 0x2000000L >> 26;
        l3 -= l21 << 26;
        l4 += l21;
        l21 = l4 + 0x2000000L >> 26;
        l4 -= l21 << 26;
        l5 += l21;
        l21 = l5 + 0x2000000L >> 26;
        l5 -= l21 << 26;
        l6 += l21;
        l21 = l6 + 0x2000000L >> 26;
        l6 -= l21 << 26;
        l7 += l21;
        l21 = l7 + 0x2000000L >> 26;
        l7 -= l21 << 26;
        l8 += l21;
        l21 = l8 + 0x2000000L >> 26;
        l8 -= l21 << 26;
        l9 += l21;
        l21 = l9 + 0x2000000L >> 26;
        l9 -= l21 << 26;
        l10 += l21;
        lArray[0] = l;
        lArray[1] = l2;
        lArray[2] = l3;
        lArray[3] = l4;
        lArray[4] = l5;
        lArray[5] = l6;
        lArray[6] = l7;
        lArray[7] = l8;
        lArray[8] = l9;
        lArray[9] = l10;
    }

    private void carryReduce(long[] lArray, long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9, long l10) {
        long l11 = 0L;
        long l12 = l + 0x2000000L >> 26;
        l -= l12 << 26;
        l2 += l12;
        l12 = l2 + 0x2000000L >> 26;
        l2 -= l12 << 26;
        l3 += l12;
        l12 = l3 + 0x2000000L >> 26;
        l3 -= l12 << 26;
        l4 += l12;
        l12 = l4 + 0x2000000L >> 26;
        l4 -= l12 << 26;
        l5 += l12;
        l12 = l5 + 0x2000000L >> 26;
        l5 -= l12 << 26;
        l6 += l12;
        l12 = l6 + 0x2000000L >> 26;
        l6 -= l12 << 26;
        l7 += l12;
        l12 = l7 + 0x2000000L >> 26;
        l7 -= l12 << 26;
        l8 += l12;
        l12 = l8 + 0x2000000L >> 26;
        l8 -= l12 << 26;
        l9 += l12;
        l12 = l9 + 0x2000000L >> 26;
        l9 -= l12 << 26;
        l10 += l12;
        l12 = l10 + 0x2000000L >> 26;
        this.carryReduce0(lArray, l, l2, l3, l4, l5, l6, l7, l8, l9, l10 -= l12 << 26, l11 += l12);
    }

    void carryReduce0(long[] lArray, long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9, long l10, long l11) {
        long l12 = 30753059L * l11;
        l += l12 << 4 & 0x3FFFFFFL;
        l2 += l12 >> 22;
        l12 = -16973234L * l11;
        l2 += l12 << 4 & 0x3FFFFFFL;
        l3 += l12 >> 22;
        l12 = 5420348L * l11;
        l3 += l12 << 4 & 0x3FFFFFFL;
        l4 += l12 >> 22;
        l12 = 28083992L * l11;
        l4 += l12 << 4 & 0x3FFFFFFL;
        l5 += l12 >> 22;
        l12 = -9305121L * l11;
        l5 += l12 << 4 & 0x3FFFFFFL;
        l6 += l12 >> 22;
        l12 = -65536L * l11;
        l9 += l12 << 4 & 0x3FFFFFFL;
        l10 += l12 >> 22;
        l12 = 0x400000L * l11;
        l10 += l12 << 4 & 0x3FFFFFFL;
        l11 += l12 >> 22;
        l12 = l + 0x2000000L >> 26;
        l -= l12 << 26;
        l2 += l12;
        l12 = l2 + 0x2000000L >> 26;
        l2 -= l12 << 26;
        l3 += l12;
        l12 = l3 + 0x2000000L >> 26;
        l3 -= l12 << 26;
        l4 += l12;
        l12 = l4 + 0x2000000L >> 26;
        l4 -= l12 << 26;
        l5 += l12;
        l12 = l5 + 0x2000000L >> 26;
        l5 -= l12 << 26;
        l6 += l12;
        l12 = l6 + 0x2000000L >> 26;
        l6 -= l12 << 26;
        l7 += l12;
        l12 = l7 + 0x2000000L >> 26;
        l7 -= l12 << 26;
        l8 += l12;
        l12 = l8 + 0x2000000L >> 26;
        l8 -= l12 << 26;
        l9 += l12;
        l12 = l9 + 0x2000000L >> 26;
        l9 -= l12 << 26;
        l10 += l12;
        lArray[0] = l;
        lArray[1] = l2;
        lArray[2] = l3;
        lArray[3] = l4;
        lArray[4] = l5;
        lArray[5] = l6;
        lArray[6] = l7;
        lArray[7] = l8;
        lArray[8] = l9;
        lArray[9] = l10;
    }

    @Override
    protected void mult(long[] lArray, long[] lArray2, long[] lArray3) {
        long l = lArray[0] * lArray2[0];
        long l2 = lArray[0] * lArray2[1] + lArray[1] * lArray2[0];
        long l3 = lArray[0] * lArray2[2] + lArray[1] * lArray2[1] + lArray[2] * lArray2[0];
        long l4 = lArray[0] * lArray2[3] + lArray[1] * lArray2[2] + lArray[2] * lArray2[1] + lArray[3] * lArray2[0];
        long l5 = lArray[0] * lArray2[4] + lArray[1] * lArray2[3] + lArray[2] * lArray2[2] + lArray[3] * lArray2[1] + lArray[4] * lArray2[0];
        long l6 = lArray[0] * lArray2[5] + lArray[1] * lArray2[4] + lArray[2] * lArray2[3] + lArray[3] * lArray2[2] + lArray[4] * lArray2[1] + lArray[5] * lArray2[0];
        long l7 = lArray[0] * lArray2[6] + lArray[1] * lArray2[5] + lArray[2] * lArray2[4] + lArray[3] * lArray2[3] + lArray[4] * lArray2[2] + lArray[5] * lArray2[1] + lArray[6] * lArray2[0];
        long l8 = lArray[0] * lArray2[7] + lArray[1] * lArray2[6] + lArray[2] * lArray2[5] + lArray[3] * lArray2[4] + lArray[4] * lArray2[3] + lArray[5] * lArray2[2] + lArray[6] * lArray2[1] + lArray[7] * lArray2[0];
        long l9 = lArray[0] * lArray2[8] + lArray[1] * lArray2[7] + lArray[2] * lArray2[6] + lArray[3] * lArray2[5] + lArray[4] * lArray2[4] + lArray[5] * lArray2[3] + lArray[6] * lArray2[2] + lArray[7] * lArray2[1] + lArray[8] * lArray2[0];
        long l10 = lArray[0] * lArray2[9] + lArray[1] * lArray2[8] + lArray[2] * lArray2[7] + lArray[3] * lArray2[6] + lArray[4] * lArray2[5] + lArray[5] * lArray2[4] + lArray[6] * lArray2[3] + lArray[7] * lArray2[2] + lArray[8] * lArray2[1] + lArray[9] * lArray2[0];
        long l11 = lArray[1] * lArray2[9] + lArray[2] * lArray2[8] + lArray[3] * lArray2[7] + lArray[4] * lArray2[6] + lArray[5] * lArray2[5] + lArray[6] * lArray2[4] + lArray[7] * lArray2[3] + lArray[8] * lArray2[2] + lArray[9] * lArray2[1];
        long l12 = lArray[2] * lArray2[9] + lArray[3] * lArray2[8] + lArray[4] * lArray2[7] + lArray[5] * lArray2[6] + lArray[6] * lArray2[5] + lArray[7] * lArray2[4] + lArray[8] * lArray2[3] + lArray[9] * lArray2[2];
        long l13 = lArray[3] * lArray2[9] + lArray[4] * lArray2[8] + lArray[5] * lArray2[7] + lArray[6] * lArray2[6] + lArray[7] * lArray2[5] + lArray[8] * lArray2[4] + lArray[9] * lArray2[3];
        long l14 = lArray[4] * lArray2[9] + lArray[5] * lArray2[8] + lArray[6] * lArray2[7] + lArray[7] * lArray2[6] + lArray[8] * lArray2[5] + lArray[9] * lArray2[4];
        long l15 = lArray[5] * lArray2[9] + lArray[6] * lArray2[8] + lArray[7] * lArray2[7] + lArray[8] * lArray2[6] + lArray[9] * lArray2[5];
        long l16 = lArray[6] * lArray2[9] + lArray[7] * lArray2[8] + lArray[8] * lArray2[7] + lArray[9] * lArray2[6];
        long l17 = lArray[7] * lArray2[9] + lArray[8] * lArray2[8] + lArray[9] * lArray2[7];
        long l18 = lArray[8] * lArray2[9] + lArray[9] * lArray2[8];
        long l19 = lArray[9] * lArray2[9];
        this.carryReduce(lArray3, l, l2, l3, l4, l5, l6, l7, l8, l9, l10, l11, l12, l13, l14, l15, l16, l17, l18, l19);
    }

    @Override
    protected void reduce(long[] lArray) {
        this.carryReduce(lArray, lArray[0], lArray[1], lArray[2], lArray[3], lArray[4], lArray[5], lArray[6], lArray[7], lArray[8], lArray[9]);
    }

    @Override
    protected void square(long[] lArray, long[] lArray2) {
        long l = lArray[0] * lArray[0];
        long l2 = 2L * (lArray[0] * lArray[1]);
        long l3 = 2L * (lArray[0] * lArray[2]) + lArray[1] * lArray[1];
        long l4 = 2L * (lArray[0] * lArray[3] + lArray[1] * lArray[2]);
        long l5 = 2L * (lArray[0] * lArray[4] + lArray[1] * lArray[3]) + lArray[2] * lArray[2];
        long l6 = 2L * (lArray[0] * lArray[5] + lArray[1] * lArray[4] + lArray[2] * lArray[3]);
        long l7 = 2L * (lArray[0] * lArray[6] + lArray[1] * lArray[5] + lArray[2] * lArray[4]) + lArray[3] * lArray[3];
        long l8 = 2L * (lArray[0] * lArray[7] + lArray[1] * lArray[6] + lArray[2] * lArray[5] + lArray[3] * lArray[4]);
        long l9 = 2L * (lArray[0] * lArray[8] + lArray[1] * lArray[7] + lArray[2] * lArray[6] + lArray[3] * lArray[5]) + lArray[4] * lArray[4];
        long l10 = 2L * (lArray[0] * lArray[9] + lArray[1] * lArray[8] + lArray[2] * lArray[7] + lArray[3] * lArray[6] + lArray[4] * lArray[5]);
        long l11 = 2L * (lArray[1] * lArray[9] + lArray[2] * lArray[8] + lArray[3] * lArray[7] + lArray[4] * lArray[6]) + lArray[5] * lArray[5];
        long l12 = 2L * (lArray[2] * lArray[9] + lArray[3] * lArray[8] + lArray[4] * lArray[7] + lArray[5] * lArray[6]);
        long l13 = 2L * (lArray[3] * lArray[9] + lArray[4] * lArray[8] + lArray[5] * lArray[7]) + lArray[6] * lArray[6];
        long l14 = 2L * (lArray[4] * lArray[9] + lArray[5] * lArray[8] + lArray[6] * lArray[7]);
        long l15 = 2L * (lArray[5] * lArray[9] + lArray[6] * lArray[8]) + lArray[7] * lArray[7];
        long l16 = 2L * (lArray[6] * lArray[9] + lArray[7] * lArray[8]);
        long l17 = 2L * (lArray[7] * lArray[9]) + lArray[8] * lArray[8];
        long l18 = 2L * (lArray[8] * lArray[9]);
        long l19 = lArray[9] * lArray[9];
        this.carryReduce(lArray2, l, l2, l3, l4, l5, l6, l7, l8, l9, l10, l11, l12, l13, l14, l15, l16, l17, l18, l19);
    }
}

