/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ec;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.SM2KeyAgreementParamSpec;
import java.security.spec.SM2ParameterSpec;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;
import sun.security.ec.ECOperations;
import sun.security.ec.point.MutablePoint;
import sun.security.provider.SM3Engine;
import sun.security.util.ArrayUtil;
import sun.security.util.SMUtil;

public final class SM2KeyAgreement
extends KeyAgreementSpi {
    private ECPrivateKey ephemeralPrivateKey;
    private SM2KeyAgreementParamSpec paramSpec;
    private ECPublicKey peerEphemeralPublicKey;
    private final SM3Engine sm3 = new SM3Engine();
    private static final BigInteger TWO_POW_W = BigInteger.ONE.shiftLeft(SM2KeyAgreement.w());
    private static final BigInteger TWO_POW_W_SUB_ONE = TWO_POW_W.subtract(BigInteger.ONE);
    private static final byte[] A = SMUtil.bigIntToBytes32((BigInteger)SM2ParameterSpec.CURVE.getA());
    private static final byte[] B = SMUtil.bigIntToBytes32((BigInteger)SM2ParameterSpec.CURVE.getB());
    private static final byte[] GEN_X = SMUtil.bigIntToBytes32((BigInteger)SM2ParameterSpec.GENERATOR.getAffineX());
    private static final byte[] GEN_Y = SMUtil.bigIntToBytes32((BigInteger)SM2ParameterSpec.GENERATOR.getAffineY());

    @Override
    protected void engineInit(Key key, SecureRandom secureRandom) {
        throw new UnsupportedOperationException("Use init(Key, AlgorithmParameterSpec, SecureRandom) instead");
    }

    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (!(key instanceof ECPrivateKey)) {
            throw new InvalidKeyException("Only accept ECPrivateKey");
        }
        if (!(algorithmParameterSpec instanceof SM2KeyAgreementParamSpec)) {
            throw new InvalidAlgorithmParameterException("Only accept SM2KeyAgreementParamSpec");
        }
        ECPrivateKey eCPrivateKey = (ECPrivateKey)key;
        BigInteger bigInteger = eCPrivateKey.getS();
        if (bigInteger.compareTo(BigInteger.ZERO) <= 0 || bigInteger.compareTo(SM2ParameterSpec.ORDER) >= 0) {
            throw new InvalidKeyException("The private key must be within the range [1, n - 1]");
        }
        this.ephemeralPrivateKey = eCPrivateKey;
        this.paramSpec = (SM2KeyAgreementParamSpec)algorithmParameterSpec;
        this.peerEphemeralPublicKey = null;
    }

    @Override
    protected Key engineDoPhase(Key key, boolean bl) throws InvalidKeyException, IllegalStateException {
        if (this.ephemeralPrivateKey == null || this.paramSpec == null) {
            throw new IllegalStateException("Not initialized");
        }
        if (this.peerEphemeralPublicKey != null) {
            throw new IllegalStateException("Phase already executed");
        }
        if (!bl) {
            throw new IllegalStateException("Only two party agreement supported, lastPhase must be true");
        }
        if (!(key instanceof ECPublicKey)) {
            throw new InvalidKeyException("Only accept ECPublicKey");
        }
        SM2KeyAgreement.validate((ECPublicKey)key);
        this.peerEphemeralPublicKey = (ECPublicKey)key;
        return null;
    }

    private static void validateCoordinate(BigInteger bigInteger, BigInteger bigInteger2) throws InvalidKeyException {
        if (bigInteger.compareTo(BigInteger.ZERO) < 0 || bigInteger.compareTo(bigInteger2) >= 0) {
            throw new InvalidKeyException("Invalid coordinate");
        }
    }

    private static void validate(ECPublicKey eCPublicKey) throws InvalidKeyException {
        BigInteger bigInteger = eCPublicKey.getW().getAffineX();
        BigInteger bigInteger2 = eCPublicKey.getW().getAffineY();
        BigInteger bigInteger3 = ECOperations.SM2OPS.getField().getSize();
        SM2KeyAgreement.validateCoordinate(bigInteger, bigInteger3);
        SM2KeyAgreement.validateCoordinate(bigInteger2, bigInteger3);
        BigInteger bigInteger4 = bigInteger.modPow(BigInteger.valueOf(3L), bigInteger3).add(SM2ParameterSpec.CURVE.getA().multiply(bigInteger)).add(SM2ParameterSpec.CURVE.getB()).mod(bigInteger3);
        BigInteger bigInteger5 = bigInteger2.modPow(BigInteger.valueOf(2L), bigInteger3);
        if (!bigInteger4.equals(bigInteger5)) {
            throw new InvalidKeyException("Point is not on curve");
        }
        byte[] byArray = SM2ParameterSpec.ORDER.toByteArray();
        ArrayUtil.reverse(byArray);
        MutablePoint mutablePoint = ECOperations.SM2OPS.multiply(ECOperations.SM2OPS.toAffPoint(eCPublicKey.getW()), byArray);
        if (!ECOperations.SM2OPS.isNeutral(mutablePoint)) {
            throw new InvalidKeyException("Point has incorrect order");
        }
    }

    private static int w() {
        return (int)Math.ceil((double)SM2ParameterSpec.ORDER.subtract(BigInteger.ONE).bitLength() / 2.0) - 1;
    }

    @Override
    protected byte[] engineGenerateSecret() throws IllegalStateException {
        byte[] byArray;
        if (this.ephemeralPrivateKey == null || this.peerEphemeralPublicKey == null) {
            throw new IllegalStateException("Not initialized correctly");
        }
        try {
            byArray = this.deriveKeyImpl();
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
        this.peerEphemeralPublicKey = null;
        return byArray;
    }

    private byte[] deriveKeyImpl() {
        BigInteger bigInteger = this.ephemeralPrivateKey.getS();
        MutablePoint mutablePoint = ECOperations.SM2OPS.multiply(ECOperations.SM2OPS.toAffPoint(SM2ParameterSpec.GENERATOR), SMUtil.toByteArrayLE((BigInteger)bigInteger));
        BigInteger bigInteger2 = mutablePoint.asAffine().getX().asBigInteger();
        BigInteger bigInteger3 = TWO_POW_W.add(bigInteger2.and(TWO_POW_W_SUB_ONE));
        BigInteger bigInteger4 = this.paramSpec.privateKey().getS();
        BigInteger bigInteger5 = bigInteger4.add(bigInteger3.multiply(bigInteger)).mod(SM2ParameterSpec.ORDER);
        ECPoint eCPoint = this.peerEphemeralPublicKey.getW();
        BigInteger bigInteger6 = eCPoint.getAffineX();
        BigInteger bigInteger7 = TWO_POW_W.add(bigInteger6.and(TWO_POW_W_SUB_ONE));
        ECPoint eCPoint2 = this.paramSpec.peerPublicKey().getW();
        MutablePoint mutablePoint2 = ECOperations.SM2OPS.multiply(ECOperations.SM2OPS.toAffPoint(eCPoint), SMUtil.toByteArrayLE((BigInteger)bigInteger7));
        ECOperations.SM2OPS.setSum(mutablePoint2, ECOperations.SM2OPS.toAffPoint(eCPoint2));
        MutablePoint mutablePoint3 = ECOperations.SM2OPS.multiply(mutablePoint2.asAffine(), SMUtil.toByteArrayLE((BigInteger)SM2ParameterSpec.COFACTOR.multiply(bigInteger5)));
        if (ECOperations.isInfinitePoint(mutablePoint3)) {
            throw new IllegalStateException("Generate secret failed");
        }
        ECPoint eCPoint3 = ECOperations.toECPoint(mutablePoint3);
        byte[] byArray = SMUtil.bigIntToBytes32((BigInteger)eCPoint3.getAffineX());
        byte[] byArray2 = SMUtil.bigIntToBytes32((BigInteger)eCPoint3.getAffineY());
        byte[] byArray3 = this.z(this.paramSpec.id(), this.paramSpec.publicKey().getW());
        byte[] byArray4 = this.z(this.paramSpec.peerId(), this.paramSpec.peerPublicKey().getW());
        byte[] byArray5 = this.combine(byArray, byArray2, byArray3, byArray4);
        return this.kdf(byArray5);
    }

    @Override
    protected int engineGenerateSecret(byte[] byArray, int n) throws IllegalStateException, ShortBufferException {
        if (n + this.paramSpec.sharedKeyLength() > byArray.length) {
            throw new ShortBufferException("Need " + this.paramSpec.sharedKeyLength() + " bytes, only " + (byArray.length - n) + " available");
        }
        byte[] byArray2 = this.engineGenerateSecret();
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        return byArray2.length;
    }

    @Override
    protected SecretKey engineGenerateSecret(String string) throws IllegalStateException, NoSuchAlgorithmException {
        if (string == null) {
            throw new NoSuchAlgorithmException("Algorithm must not be null");
        }
        return new SecretKeySpec(this.engineGenerateSecret(), string);
    }

    private byte[] z(byte[] byArray, ECPoint eCPoint) {
        int n = byArray.length << 3;
        this.sm3.update((byte)(n >>> 8));
        this.sm3.update((byte)n);
        this.sm3.update(byArray);
        this.sm3.update(A);
        this.sm3.update(B);
        this.sm3.update(GEN_X);
        this.sm3.update(GEN_Y);
        this.sm3.update(SMUtil.bigIntToBytes32((BigInteger)eCPoint.getAffineX()));
        this.sm3.update(SMUtil.bigIntToBytes32((BigInteger)eCPoint.getAffineY()));
        return this.sm3.doFinal();
    }

    private byte[] kdf(byte[] byArray) {
        byte[] byArray2 = new byte[this.paramSpec.sharedKeyLength()];
        byte[] byArray3 = new byte[32];
        int n = this.paramSpec.sharedKeyLength() % 32;
        int n2 = this.paramSpec.sharedKeyLength() / 32 + (n == 0 ? 0 : 1);
        for (int i = 1; i <= n2; ++i) {
            this.sm3.update(byArray);
            this.sm3.update(SMUtil.intToBytes4((int)i));
            this.sm3.doFinal(byArray3);
            int n3 = i == n2 && n != 0 ? n : 32;
            System.arraycopy(byArray3, 0, byArray2, (i - 1) * 32, n3);
        }
        return byArray2;
    }

    private byte[] combine(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        byte[] byArray5 = new byte[byArray.length + byArray2.length + byArray3.length + byArray4.length];
        System.arraycopy(byArray, 0, byArray5, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray5, byArray.length, byArray2.length);
        if (this.paramSpec.isInitiator()) {
            System.arraycopy(byArray3, 0, byArray5, byArray.length + byArray2.length, byArray3.length);
            System.arraycopy(byArray4, 0, byArray5, byArray.length + byArray2.length + byArray3.length, byArray4.length);
        } else {
            System.arraycopy(byArray4, 0, byArray5, byArray.length + byArray2.length, byArray4.length);
            System.arraycopy(byArray3, 0, byArray5, byArray.length + byArray2.length + byArray4.length, byArray3.length);
        }
        return byArray5;
    }
}

